// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{
    ConditionalFormatCell, ConditionalFormatCellRule, Format, Workbook, XlsxError,
};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let format1 = Format::new().set_background_color("FF0000");
    let format2 = Format::new().set_background_color("92D050");

    // Manually set the indices to get the same order as the target file.
    worksheet.format_dxf_index(&format2);
    worksheet.format_dxf_index(&format1);

    let data = [
        [90, 80, 50, 10, 20, 90, 40, 90, 30, 40],
        [20, 10, 90, 100, 30, 60, 70, 60, 50, 90],
        [10, 50, 60, 50, 20, 50, 80, 30, 40, 60],
        [10, 90, 20, 40, 10, 40, 50, 70, 90, 50],
        [70, 100, 10, 90, 10, 10, 20, 100, 100, 40],
        [20, 60, 10, 100, 30, 10, 20, 60, 100, 10],
        [10, 60, 10, 80, 100, 80, 30, 30, 70, 40],
        [30, 90, 60, 10, 10, 100, 40, 40, 30, 40],
        [80, 90, 10, 20, 20, 50, 80, 20, 60, 90],
        [60, 80, 30, 30, 10, 50, 80, 60, 50, 30],
    ];

    worksheet.write_row_matrix(0, 0, data)?;

    let conditional_format = ConditionalFormatCell::new()
        .set_rule(ConditionalFormatCellRule::GreaterThanOrEqualTo(50))
        .set_format(format1);

    worksheet.add_conditional_format(0, 0, 9, 9, &conditional_format)?;

    let conditional_format = ConditionalFormatCell::new()
        .set_rule(ConditionalFormatCellRule::LessThan(50))
        .set_format(format2);

    worksheet.add_conditional_format(0, 0, 9, 9, &conditional_format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_cond_format07() {
    let test_runner = common::TestRunner::new()
        .set_name("cond_format07")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
