// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.insert_checkbox(0, 0, false)?;
    worksheet.insert_checkbox(2, 2, true)?;
    worksheet.insert_checkbox(8, 4, false)?;
    worksheet.insert_checkbox(9, 4, true)?;

    workbook.save(filename)?;

    Ok(())
}

// Test with standard boolean value and format.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();
    let format = Format::new().set_checkbox();

    worksheet.write_boolean_with_format(0, 0, false, &format)?;
    worksheet.write_boolean_with_format(2, 2, true, &format)?;
    worksheet.write_boolean_with_format(8, 4, false, &format)?;
    worksheet.write_boolean_with_format(9, 4, true, &format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_checkbox02_1() {
    let test_runner = common::TestRunner::new()
        .set_name("checkbox02")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_checkbox02_2() {
    let test_runner = common::TestRunner::new()
        .set_name("checkbox02")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
