// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartType, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    // Add some test data for the chart(s).
    worksheet.write_column(0, 0, [27, 33, 44, 12, 1])?;
    worksheet.write_column(0, 1, [6, 8, 6, 4, 2])?;
    worksheet.write_column(0, 2, [20, 10, 30, 50, 40])?;
    worksheet.write_column(0, 3, [0, 27, 23, 30, 40])?;

    let mut chart = Chart::new(ChartType::Scatter);
    chart.set_axis_ids(63597952, 63616128);
    chart.set_axis2_ids(63617664, 63619456);

    chart
        .add_series()
        .set_categories(("Sheet1", 0, 0, 4, 0))
        .set_values(("Sheet1", 0, 1, 4, 1));

    chart
        .add_series()
        .set_categories(("Sheet1", 0, 2, 4, 2))
        .set_values(("Sheet1", 0, 3, 4, 3))
        .set_secondary_axis(true);

    worksheet.insert_chart(8, 4, &chart)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_chart_scatter07() {
    let test_runner = common::TestRunner::new()
        .set_name("chart_scatter07")
        .set_function(create_new_xlsx_file)
        .ignore_elements("xl/workbook.xml", "<fileVersion")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
