// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartType, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    // Add some test data for the chart(s).
    worksheet.write(0, 0, "1.1_1")?;
    worksheet.write(0, 1, "2.2_2")?;
    worksheet.write(1, 0, 1)?;
    worksheet.write(1, 1, 2)?;

    let mut chart = Chart::new(ChartType::Column);
    chart.set_axis_ids(60474496, 78612736);
    chart
        .add_series()
        .set_categories("=Sheet1!$A$1:$B$1")
        .set_values("=Sheet1!$A$2:$B$2");

    worksheet.insert_chart(8, 4, &chart)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_chart_column13() {
    let test_runner = common::TestRunner::new()
        .set_name("chart_column13")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
