// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartEmptyCells, ChartSeries, ChartType, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    // Add some test data for the chart(s).
    worksheet.write(0, 0, 1)?;
    worksheet.write(1, 0, 2)?;
    worksheet.write(3, 0, 4)?;
    worksheet.write(4, 0, 5)?;

    worksheet.write(0, 1, 2)?;
    worksheet.write(1, 1, 4)?;
    worksheet.write(3, 1, 8)?;
    worksheet.write(4, 1, 10)?;

    worksheet.write(0, 2, 3)?;
    worksheet.write(1, 2, 6)?;
    worksheet.write(3, 2, 12)?;
    worksheet.write(4, 2, 15)?;

    let mut chart = Chart::new(ChartType::Line);
    chart
        .push_series(ChartSeries::new().set_values(("Sheet1", 0, 0, 4, 0)))
        .push_series(ChartSeries::new().set_values(("Sheet1", 0, 1, 4, 1)))
        .push_series(ChartSeries::new().set_values(("Sheet1", 0, 2, 4, 2)));

    // Set the chart axis ids to match the random values in the Excel file.
    chart.set_axis_ids(42268928, 42990208);

    chart.show_empty_cells_as(ChartEmptyCells::Connected);

    worksheet.insert_chart(8, 4, &chart)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_chart_blank04() {
    let test_runner = common::TestRunner::new()
        .set_name("chart_blank04")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
