// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Button, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let button = Button::new();

    // Worksheet 1.
    let worksheet1 = workbook.add_worksheet();
    worksheet1.insert_button(1, 2, &button)?;

    // Worksheet 2.
    let worksheet2 = workbook.add_worksheet();
    worksheet2.insert_button(4, 4, &button)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_button04() {
    let test_runner = common::TestRunner::new()
        .set_name("button04")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
