// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, "NAN")?;
    worksheet.write(1, 0, "INF")?;
    worksheet.write(2, 0, "-INF")?;

    workbook.save(filename)?;

    Ok(())
}

// Test Nan and Inf mapping.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, f64::NAN)?;
    worksheet.write(1, 0, f64::INFINITY)?;
    worksheet.write(2, 0, f64::NEG_INFINITY)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_bootstrap73_1() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap73")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_bootstrap73_2() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap73")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
