// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test to generic write().
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, 10)?;
    worksheet.write(1, 0, 11)?;
    worksheet.write(2, 0, 12)?;
    worksheet.write(3, 0, 13)?;
    worksheet.write(4, 0, 14)?;

    worksheet.write(0, 1, 20)?;
    worksheet.write(1, 1, 21)?;
    worksheet.write(2, 1, 22)?;
    worksheet.write(3, 1, 23)?;
    worksheet.write(4, 1, 24)?;

    worksheet.write(0, 2, 30)?;
    worksheet.write(1, 2, 31)?;
    worksheet.write(2, 2, 32)?;
    worksheet.write(3, 2, 33)?;
    worksheet.write(4, 2, 34)?;

    worksheet.write(0, 4, 10)?;
    worksheet.write(0, 5, 11)?;
    worksheet.write(0, 6, 12)?;
    worksheet.write(0, 7, 13)?;
    worksheet.write(0, 8, 14)?;

    worksheet.write(1, 4, 20)?;
    worksheet.write(1, 5, 21)?;
    worksheet.write(1, 6, 22)?;
    worksheet.write(1, 7, 23)?;
    worksheet.write(1, 8, 24)?;

    worksheet.write(2, 4, 30)?;
    worksheet.write(2, 5, 31)?;
    worksheet.write(2, 6, 32)?;
    worksheet.write(2, 7, 33)?;
    worksheet.write(2, 8, 34)?;

    workbook.save(filename)?;

    Ok(())
}

// Test to generic write_row()/write_column().
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let matrix = [
        [10, 11, 12, 13, 14],
        [20, 21, 22, 23, 24],
        [30, 31, 32, 33, 34],
    ];

    worksheet.write_column_matrix(0, 0, matrix)?;
    worksheet.write_row_matrix(0, 4, matrix)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_bootstrap69_write() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap69")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_bootstrap69_write_matrix() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap69")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
