// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test to generic write().
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, 1)?;
    worksheet.write(1, 0, 2)?;
    worksheet.write(2, 0, 3)?;
    worksheet.write(3, 0, 4)?;
    worksheet.write(4, 0, 5)?;

    worksheet.write(0, 3, 1)?;
    worksheet.write(0, 4, 2)?;
    worksheet.write(0, 5, 3)?;
    worksheet.write(0, 6, 4)?;
    worksheet.write(0, 7, 5)?;

    worksheet.write(0, 1, "Hello")?;
    worksheet.write(1, 1, "Hello")?;
    worksheet.write(2, 1, "Hello")?;
    worksheet.write(3, 1, "Hello")?;
    worksheet.write(4, 1, "Hello")?;

    worksheet.write(1, 3, "Hello")?;
    worksheet.write(1, 4, "Hello")?;
    worksheet.write(1, 5, "Hello")?;
    worksheet.write(1, 6, "Hello")?;
    worksheet.write(1, 7, "Hello")?;

    workbook.save(filename)?;

    Ok(())
}

// Test to generic write_row()/write_column().
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let numbers1 = [1, 2, 3, 4, 5];
    let numbers2 = vec![1, 2, 3, 4, 5];
    let words = ["Hello"; 5];

    worksheet.write_column(0, 0, numbers1)?;
    worksheet.write_column(0, 1, words)?;

    worksheet.write_row(0, 3, numbers2)?;
    worksheet.write_row(1, 3, words)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_bootstrap68_write() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap68")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_bootstrap68_write_row() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap68")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
