// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, Worksheet, XlsxError};

// Test to demonstrate activated, hidden and selected worksheets.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet1 = Worksheet::new();
    let mut worksheet2 = Worksheet::new();
    let worksheet3 = Worksheet::new();
    let mut worksheet4 = Worksheet::new();
    let mut worksheet5 = Worksheet::new();
    let worksheet6 = Worksheet::new();

    worksheet2.set_hidden(true);
    worksheet4.set_selected(true);
    worksheet5.set_selected(true);

    workbook.push_worksheet(worksheet1);
    workbook.push_worksheet(worksheet2);
    workbook.push_worksheet(worksheet3);
    workbook.push_worksheet(worksheet4);
    workbook.push_worksheet(worksheet5);
    workbook.push_worksheet(worksheet6);

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap47_set_active_and_hidden() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap47")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
