// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test case to demonstrate setting headers and footers.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.set_header("&CPage &P of &N");
    worksheet.set_footer("&R&F");

    let worksheet = workbook.add_worksheet();

    worksheet.set_header("&C&[Page]&[Pages]&[Date]&[Time]&[Path]&[File]&[File]&[Tab]");

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap40_header_footer() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap41")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
