// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Color, Format, FormatBorder, Workbook, XlsxError};

// Test case to demonstrate creating a basic file with cell borders.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format1 = Format::new().set_border(FormatBorder::Thin);

    let format2 = Format::new()
        .set_border(FormatBorder::Hair)
        .set_border_color(Color::Red);

    let format3 = Format::new()
        .set_border_top(FormatBorder::Dotted)
        .set_border_left(FormatBorder::DashDotDot)
        .set_border_right(FormatBorder::Dashed)
        .set_border_bottom(FormatBorder::DashDot)
        .set_border_top_color(Color::Red)
        .set_border_left_color(Color::Red)
        .set_border_right_color(Color::Red)
        .set_border_bottom_color(Color::Red);

    let format4 = Format::new()
        .set_border_top(FormatBorder::MediumDashDotDot)
        .set_border_left(FormatBorder::MediumDashDotDot)
        .set_border_right(FormatBorder::MediumDashDot)
        .set_border_bottom(FormatBorder::SlantDashDot)
        .set_border_top_color(Color::Red)
        .set_border_left_color(Color::Red)
        .set_border_right_color(Color::Red)
        .set_border_bottom_color(Color::Red);

    let format5 = Format::new()
        .set_border_top(FormatBorder::MediumDashed)
        .set_border_left(FormatBorder::Medium)
        .set_border_right(FormatBorder::Double)
        .set_border_bottom(FormatBorder::Thick)
        .set_border_top_color(Color::Red)
        .set_border_left_color(Color::Red)
        .set_border_right_color(Color::Red)
        .set_border_bottom_color(Color::Red);

    let worksheet = workbook.add_worksheet();

    worksheet.write_blank(2, 1, &format1)?;
    worksheet.write_blank(4, 1, &format2)?;
    worksheet.write_blank(6, 1, &format3)?;
    worksheet.write_blank(8, 1, &format4)?;
    worksheet.write_blank(10, 1, &format5)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap32_borders() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap32")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
