// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, FormatAlign, Workbook, XlsxError};

// Test case to demonstrate creating a basic file with alignment formatting.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();
    let format1 = Format::new().set_align(FormatAlign::Left);
    let format2 = Format::new().set_align(FormatAlign::Center);
    let format3 = Format::new().set_align(FormatAlign::Right);
    let format4 = Format::new().set_align(FormatAlign::Fill);
    let format5 = Format::new().set_align(FormatAlign::Justify);
    let format6 = Format::new().set_align(FormatAlign::CenterAcross);
    let format7 = Format::new().set_align(FormatAlign::Distributed);
    let format8 = Format::new().set_align(FormatAlign::Bottom);
    let format9 = Format::new().set_align(FormatAlign::VerticalCenter);
    let format10 = Format::new().set_align(FormatAlign::Top);
    let format11 = Format::new().set_align(FormatAlign::VerticalJustify);
    let format12 = Format::new().set_align(FormatAlign::VerticalDistributed);
    let format13 = Format::new()
        .set_align(FormatAlign::Center)
        .set_align(FormatAlign::VerticalCenter);

    worksheet.write_string(0, 0, "Rust")?;
    worksheet.write_string_with_format(1, 0, "Rust", &format1)?;
    worksheet.write_string_with_format(2, 0, "Rust", &format2)?;
    worksheet.write_string_with_format(3, 0, "Rust", &format3)?;
    worksheet.write_string_with_format(4, 0, "Rust", &format4)?;
    worksheet.write_string_with_format(5, 0, "Rust", &format5)?;
    worksheet.write_string_with_format(6, 0, "Rust", &format6)?;
    worksheet.write_string_with_format(7, 0, "Rust", &format7)?;
    worksheet.write_string_with_format(8, 0, "Rust", &format8)?;
    worksheet.write_string_with_format(9, 0, "Rust", &format9)?;
    worksheet.write_string_with_format(10, 0, "Rust", &format10)?;
    worksheet.write_string_with_format(11, 0, "Rust", &format11)?;
    worksheet.write_string_with_format(12, 0, "Rust", &format12)?;
    worksheet.write_string_with_format(13, 0, "Rust", &format13)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap29_alignment() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap29")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
