// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test case to demonstrate creating a basic file with user defined column.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();
    let format1 = Format::new().set_bold();
    let format2 = Format::new().set_italic();
    let format3 = Format::new().set_bold().set_italic();

    worksheet.set_column_format(0, &format1)?;
    worksheet.set_column_format(1, &format2)?;
    worksheet.set_column_format(2, &format1)?;

    worksheet.set_column_format(3, &format1)?;
    worksheet.set_column_width(3, 5.86)?;

    worksheet.set_column_format(4, &format1)?;
    worksheet.set_column_format(5, &format1)?;
    worksheet.set_column_format(6, &format1)?;
    worksheet.set_column_format(7, &format1)?;
    worksheet.set_column_width(4, 6.43)?;
    worksheet.set_column_width(5, 6.43)?;
    worksheet.set_column_width(6, 6.43)?;
    worksheet.set_column_width(7, 6.43)?;

    worksheet.set_column_format(8, &format2)?;
    worksheet.set_column_format(5, &format3)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap28_set_column_contiguous_formats() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap28")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
