// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test case to demonstrate creating a basic file with user defined row.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format1 = Format::new().set_bold();
    let format2 = Format::new().set_italic();

    let worksheet = workbook.add_worksheet();
    worksheet.set_row_format(2, &format1)?;

    let worksheet = workbook.add_worksheet();
    worksheet.set_row_format(2, &format2)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap27_set_row_2_worksheets() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap27")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
