// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, FormatUnderline, Workbook, XlsxError};

// Test case to demonstrate cell font formatting.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format1 = Format::new().set_underline(FormatUnderline::None);
    let format2 = Format::new().set_underline(FormatUnderline::Single);
    let format3 = Format::new().set_underline(FormatUnderline::Double);
    let format4 = Format::new().set_underline(FormatUnderline::SingleAccounting);
    let format5 = Format::new().set_underline(FormatUnderline::DoubleAccounting);

    let worksheet = workbook.add_worksheet();
    worksheet.write_string_with_format(0, 0, "Rust", &format1)?;
    worksheet.write_string_with_format(1, 0, "Rust", &format2)?;
    worksheet.write_string_with_format(2, 0, "Rust", &format3)?;
    worksheet.write_string_with_format(3, 0, "Rust", &format4)?;
    worksheet.write_string_with_format(4, 0, "Rust", &format5)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap20_font_underlines() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap20")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
