// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test case to demonstrate handling NaN and Inf numbers. For now these are
// handled as strings but at a latter stage them may be stored as Excel error
// types.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.set_nan_value("#NUM!");
    worksheet.set_infinity_value("#DIV/0!");
    worksheet.set_neg_infinity_value("#DIV/0!");

    worksheet.write_number(0, 0, f64::NAN)?;
    worksheet.write_number(1, 0, f64::INFINITY)?;
    worksheet.write_number(2, 0, f64::NEG_INFINITY)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap16_test_nan() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap16")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
