// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test case to demonstrate creating a basic file with some string cell data.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format = Format::new().set_bold();

    let worksheet = workbook.add_worksheet();
    worksheet.write_string_with_format(0, 0, "Hello", &format)?;

    workbook.save(filename)?;

    Ok(())
}

// Write formatted string with generic write().
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format = Format::new().set_bold();

    let worksheet = workbook.add_worksheet();
    worksheet.write_with_format(0, 0, "Hello", &format)?;

    workbook.save(filename)?;

    Ok(())
}

// Write Option<T> with generic write().
fn create_new_xlsx_file_3(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format = Format::new().set_bold();

    let worksheet = workbook.add_worksheet();
    worksheet.write_with_format(0, 0, Some("Hello"), &format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap09_write_a_formatted_string() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap09")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn bootstrap09_with_generic_write() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap09")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn bootstrap09_with_write_option() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap09")
        .set_function(create_new_xlsx_file_3)
        .unique("3")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
