// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test case to demonstrate creating a basic file with some numeric cell data.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.write_number(0, 0, 1)?;
    worksheet.write_number(1, 1, 2)?;
    worksheet.write_number(2, 2, 3)?;

    workbook.save(filename)?;

    Ok(())
}

// Write numbers with generic write().
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, 1)?;
    worksheet.write(1, 1, 2)?;
    worksheet.write(2, 2, 3)?;

    workbook.save(filename)?;

    Ok(())
}

// Write Option<T> with generic write().
fn create_new_xlsx_file_3(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, Some(1))?;
    worksheet.write(1, 1, 2)?;
    worksheet.write(2, 2, 3)?;

    // This should be ignored.
    worksheet.write(0, 0, None::<u8>)?;

    workbook.save(filename)?;

    Ok(())
}

// Write i64/u64 numbers.
fn create_new_xlsx_file_4(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    let num = 3_u64;

    worksheet.write(0, 0, 1_i64)?;
    worksheet.write(1, 1, 2_u64)?;
    worksheet.write_number(2, 2, num as f64)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn bootstrap04_write_numbers_1() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap04")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn bootstrap04_write_numbers_2() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap04")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn bootstrap04_write_numbers_3() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap04")
        .set_function(create_new_xlsx_file_3)
        .unique("3")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn bootstrap04_write_numbers_4() {
    let test_runner = common::TestRunner::new()
        .set_name("bootstrap04")
        .set_function(create_new_xlsx_file_4)
        .unique("4")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
