// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{HeaderImagePosition, Image, Note, Workbook, XlsxError};

// Create rust_xlsxwriter file to compare against Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();
    worksheet.set_paper_size(9);
    worksheet.set_default_note_author("John");

    let note = Note::new("Some text").add_author_prefix(false);
    worksheet.write(0, 0, "Foo")?;
    worksheet.insert_note(1, 1, &note)?;

    let image = Image::new("tests/input/images/logo.jpg")?.set_alt_text("logo.jpg");

    worksheet.insert_image(8, 4, &image)?;
    worksheet.insert_background_image(&image);

    let image = Image::new("tests/input/images/blue.jpg")?;

    worksheet.set_header("&C&G");
    worksheet.set_header_image(&image, HeaderImagePosition::Center)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_background07() {
    let test_runner = common::TestRunner::new()
        .set_name("background07")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
