// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test to demonstrate autofit.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write_array_formula(0, 0, 2, 0, "{=SUM(B1:C1*B2:C2)}")?;
    worksheet.set_formula_result(0, 0, "1000");

    worksheet.write_number(0, 1, 20)?;
    worksheet.write_number(1, 1, 30)?;
    worksheet.write_number(2, 1, 40)?;

    worksheet.write_number(0, 2, 10)?;
    worksheet.write_number(1, 2, 40)?;
    worksheet.write_number(2, 2, 20)?;

    worksheet.autofit();

    // Put these after the autofit() so that the autofit in on the formula
    // result.
    worksheet.write_number(1, 0, 1000)?;
    worksheet.write_number(2, 0, 1000)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_autofit12() {
    let test_runner = common::TestRunner::new()
        .set_name("autofit12")
        .set_function(create_new_xlsx_file)
        .ignore_calc_chain()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
