// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test to demonstrate autofit.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let text_wrap = Format::new().set_text_wrap();

    worksheet.write_string_with_format(0, 0, "Hello\nFoo", &text_wrap)?;
    worksheet.write_string_with_format(2, 2, "Foo\nBamboo\nBar", &text_wrap)?;

    worksheet.set_row_height(0, 33)?;
    worksheet.set_row_height(2, 48)?;

    worksheet.autofit();

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_autofit09() {
    let test_runner = common::TestRunner::new()
        .set_name("autofit09")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
