// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{FilterCondition, Workbook, XlsxError};

// Test to demonstrate autofilters.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    // Write the headers.
    worksheet.write_string(2, 3, "Region")?;
    worksheet.write_string(2, 4, "Item")?;
    worksheet.write_string(2, 5, "Volume")?;
    worksheet.write_string(2, 6, "Month")?;

    // Write the data used in the autofilter.
    let data = common::get_autofilter_data();
    for (row, data) in data.iter().enumerate() {
        let row = 3 + row as u32;
        worksheet.write_string(row, 3, data.0)?;
        worksheet.write_string(row, 4, data.1)?;
        worksheet.write_number(row, 5, data.2)?;
        worksheet.write_string(row, 6, data.3)?;
    }

    worksheet.autofilter(2, 3, 52, 6)?;

    let filter_condition = FilterCondition::new().add_list_filter("East");

    worksheet.filter_column(3, &filter_condition)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_autofilter07() {
    let test_runner = common::TestRunner::new()
        .set_name("autofilter07")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
