// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Formula, Workbook, XlsxError};

// Test case to test array formulas.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write_array_formula(0, 0, 2, 0, "=SUM(B1:C1*B2:C2)")?;

    worksheet.write_number(0, 1, 0)?;
    worksheet.write_number(1, 1, 0)?;
    worksheet.write_number(2, 1, 0)?;
    worksheet.write_number(0, 2, 0)?;
    worksheet.write_number(1, 2, 0)?;
    worksheet.write_number(2, 2, 0)?;

    workbook.save(filename)?;

    Ok(())
}

// Test case to test array formulas using generics.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write_array_formula(0, 0, 2, 0, Formula::new("=SUM(B1:C1*B2:C2)"))?;

    worksheet.write_number(0, 1, 0)?;
    worksheet.write_number(1, 1, 0)?;
    worksheet.write_number(2, 1, 0)?;
    worksheet.write_number(0, 2, 0)?;
    worksheet.write_number(1, 2, 0)?;
    worksheet.write_number(2, 2, 0)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_array_formula01() {
    let test_runner = common::TestRunner::new()
        .set_name("array_formula01")
        .set_function(create_new_xlsx_file_1)
        .ignore_calc_chain()
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_array_formula01_generic() {
    let test_runner = common::TestRunner::new()
        .set_name("array_formula01")
        .set_function(create_new_xlsx_file_2)
        .ignore_calc_chain()
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
