// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

//! The following example demonstrates setting the scale of the worksheet page
//! when printed.

use rust_xlsxwriter::{Workbook, XlsxError};

fn main() -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    // Add a worksheet to the workbook.
    let worksheet = workbook.add_worksheet();

    // Scale the printed worksheet to 50%.
    worksheet.set_print_scale(50);

    workbook.save("worksheet.xlsx")?;

    Ok(())
}
