use crate::*;

#[test]
fn vp9() {
    const ENCODED: &[u8] = &[
        0x00, 0x00, 0x00, 0x24, 0x66, 0x74, 0x79, 0x70, 0x69, 0x73, 0x6F, 0x6D, 0x00, 0x00, 0x00,
        0x00, 0x69, 0x73, 0x6F, 0x38, 0x6D, 0x70, 0x34, 0x31, 0x64, 0x61, 0x73, 0x68, 0x76, 0x70,
        0x30, 0x39, 0x63, 0x6D, 0x66, 0x63, 0x00, 0x00, 0x02, 0xF2, 0x6D, 0x6F, 0x6F, 0x76, 0x00,
        0x00, 0x00, 0x6C, 0x6D, 0x76, 0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0xD5, 0x26, 0xB4, 0xAA,
        0xD5, 0x26, 0xB4, 0xAA, 0x00, 0x0F, 0x42, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x02, 0x00, 0x00, 0x00, 0x87, 0x6D, 0x65, 0x74, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x20, 0x68, 0x64, 0x6C, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x49, 0x44, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x5B, 0x49, 0x44, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x15, 0xC7,
        0x49, 0x44, 0x33, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x50, 0x52, 0x49, 0x56, 0x00,
        0x00, 0x00, 0x39, 0x00, 0x00, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x67, 0x69,
        0x74, 0x68, 0x75, 0x62, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x67, 0x6F, 0x6F, 0x67, 0x6C, 0x65,
        0x2F, 0x73, 0x68, 0x61, 0x6B, 0x61, 0x2D, 0x70, 0x61, 0x63, 0x6B, 0x61, 0x67, 0x65, 0x72,
        0x00, 0x35, 0x66, 0x63, 0x39, 0x30, 0x37, 0x36, 0x66, 0x39, 0x32, 0x2D, 0x64, 0x65, 0x62,
        0x75, 0x67, 0x00, 0x00, 0x01, 0xBF, 0x74, 0x72, 0x61, 0x6B, 0x00, 0x00, 0x00, 0x5C, 0x74,
        0x6B, 0x68, 0x64, 0x00, 0x00, 0x00, 0x07, 0xD5, 0x26, 0xB4, 0xAA, 0xD5, 0x26, 0xB4, 0xAA,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x40, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x5B, 0x6D, 0x64, 0x69, 0x61, 0x00, 0x00, 0x00, 0x20, 0x6D, 0x64, 0x68, 0x64, 0x00, 0x00,
        0x00, 0x00, 0xD5, 0x26, 0xB4, 0xAA, 0xD5, 0x26, 0xB4, 0xAA, 0x00, 0x0F, 0x42, 0x40, 0x00,
        0x00, 0x00, 0x00, 0x55, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x68, 0x64, 0x6C, 0x72,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x69, 0x64, 0x65, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x48,
        0x61, 0x6E, 0x64, 0x6C, 0x65, 0x72, 0x00, 0x00, 0x00, 0x01, 0x06, 0x6D, 0x69, 0x6E, 0x66,
        0x00, 0x00, 0x00, 0x24, 0x64, 0x69, 0x6E, 0x66, 0x00, 0x00, 0x00, 0x1C, 0x64, 0x72, 0x65,
        0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C, 0x75, 0x72,
        0x6C, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xC6, 0x73, 0x74, 0x62, 0x6C, 0x00,
        0x00, 0x00, 0x7A, 0x73, 0x74, 0x73, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x6A, 0x76, 0x70, 0x30, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x40, 0x00, 0xF0, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x56, 0x50, 0x43, 0x20, 0x43, 0x6F, 0x64, 0x69, 0x6E,
        0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x14,
        0x76, 0x70, 0x63, 0x43, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x82, 0x02, 0x02, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x73, 0x74, 0x73, 0x7A, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x63,
        0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x76, 0x6D,
        0x68, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x38, 0x6D, 0x76, 0x65, 0x78, 0x00, 0x00, 0x00, 0x10, 0x6D, 0x65, 0x68, 0x64,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xBF, 0x80, 0x00, 0x00, 0x00, 0x20, 0x74, 0x72, 0x65,
        0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x73,
        0x69, 0x64, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0F, 0x42, 0x40,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x07,
        0xC8, 0x00, 0x29, 0xBF, 0x80, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x6D, 0x6F,
        0x6F, 0x66, 0x00, 0x00, 0x00, 0x10, 0x6D, 0x66, 0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x18, 0x74, 0x72, 0x61, 0x66, 0x00, 0x00, 0x00, 0x14,
        0x74, 0x66, 0x68, 0x64, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x10, 0x74, 0x66, 0x64, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0xEC, 0x74, 0x72, 0x75, 0x6E, 0x00, 0x00, 0x07, 0x01, 0x00,
        0x00, 0x00, 0x52, 0x00, 0x00, 0x04, 0x38, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x0E, 0xD0,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x00, 0x40, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x00, 0x77, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x00, 0x9A, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x00, 0xD9, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x00, 0xF0,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x01, 0x17, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x00, 0xF1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x01, 0x40, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x01, 0x6F, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x01, 0x5E,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x01, 0xF2, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x02, 0x68, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x02, 0x86, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x0A,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x44, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x02, 0xE5, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x03, 0xCB, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x02, 0xC3, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0xE7,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0x13, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0x7D, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x84, 0xD0, 0x00, 0x00, 0x04, 0x69, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x02, 0xFA, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0x30,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x73, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x0E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x84, 0xD0, 0x00, 0x00, 0x05, 0x23, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x03, 0x30, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x1A,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0xBE, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0x96, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x04, 0xC1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x02, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0xDA,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x07, 0x9D, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x01, 0x5F, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x04, 0xAB, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x02, 0x30, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x04, 0x89,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x05, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0x7E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x04, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x03, 0x77, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x64,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0xFA, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0xC7, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x03, 0xC2, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x04, 0x64, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x02, 0x82,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0xB3, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0xAE, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x84, 0xD0, 0x00, 0x00, 0x04, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x02, 0xA3, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0xE5,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0xAD, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0xDE, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x84, 0xD0, 0x00, 0x00, 0x03, 0x5B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x02, 0xF8, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x04, 0x6F,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x02, 0x5E, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0xCC, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x02, 0xE2, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x02, 0xC1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x1E,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x03, 0x96, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x02, 0xEC, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x03, 0x79, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x02, 0xDB, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x23,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x03, 0x99, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x01, 0xEE, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00,
        0x00, 0x05, 0x78, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x01, 0xAD,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x05, 0x61, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x02, 0x33, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x80, 0xE8, 0x00, 0x00, 0x01, 0xE9, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00,
        0x00, 0x05, 0x73, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0xD0, 0x00, 0x00, 0x01, 0x6F,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x05, 0x93, 0x00, 0x01, 0x00,
        0x00,
    ];

    let buf = &mut std::io::Cursor::new(&ENCODED);

    let ftyp = Ftyp::decode(buf).expect("failed to decode ftyp");

    assert_eq!(
        ftyp,
        Ftyp {
            major_brand: b"isom".into(),
            minor_version: 0,
            compatible_brands: vec![
                b"iso8".into(),
                b"mp41".into(),
                b"dash".into(),
                b"vp09".into(),
                b"cmfc".into()
            ],
        }
    );

    let moov = Moov::decode(buf).expect("failed to decode moov");
    assert_eq!(
        moov,
        Moov {
            mvhd: Mvhd {
                creation_time: 3576083626,
                modification_time: 3576083626,
                timescale: 1000000,
                duration: 0,
                rate: 1.into(),
                volume: 1.into(),
                matrix: Matrix {
                    a: 65536,
                    b: 0,
                    u: 0,
                    c: 0,
                    d: 65536,
                    v: 0,
                    x: 0,
                    y: 0,
                    w: 1073741824
                },
                next_track_id: 2
            },
            meta: Some(Meta {
                hdlr: Hdlr {
                    handler: FourCC::new(b"ID32"),
                    name: "".into()
                },
                items: vec![Any::Unknown(
                    FourCC::new(b"ID32"),
                    vec![
                        0, 0, 0, 0, 21, 199, 73, 68, 51, 4, 0, 0, 0, 0, 0, 67, 80, 82, 73, 86, 0,
                        0, 0, 57, 0, 0, 104, 116, 116, 112, 115, 58, 47, 47, 103, 105, 116, 104,
                        117, 98, 46, 99, 111, 109, 47, 103, 111, 111, 103, 108, 101, 47, 115, 104,
                        97, 107, 97, 45, 112, 97, 99, 107, 97, 103, 101, 114, 0, 53, 102, 99, 57,
                        48, 55, 54, 102, 57, 50, 45, 100, 101, 98, 117, 103
                    ]
                )]
            }),
            mvex: Some(Mvex {
                mehd: Some(Mehd {
                    fragment_duration: 2736000
                }),
                trex: vec![Trex {
                    track_id: 1,
                    default_sample_description_index: 1,
                    default_sample_duration: 33000,
                    default_sample_size: 0,
                    default_sample_flags: 0
                }]
            }),
            trak: vec![Trak {
                tkhd: Tkhd {
                    creation_time: 3576083626,
                    modification_time: 3576083626,
                    track_id: 1,
                    duration: 0,
                    layer: 0,
                    alternate_group: 0,
                    enabled: true,
                    volume: 0.into(),
                    matrix: Matrix {
                        a: 65536,
                        b: 0,
                        u: 0,
                        c: 0,
                        d: 65536,
                        v: 0,
                        x: 0,
                        y: 0,
                        w: 1073741824
                    },
                    width: 320.into(),
                    height: 240.into()
                },
                edts: None,
                meta: None,
                mdia: Mdia {
                    mdhd: Mdhd {
                        creation_time: 3576083626,
                        modification_time: 3576083626,
                        timescale: 1000000,
                        duration: 0,
                        language: "und".to_string()
                    },
                    hdlr: Hdlr {
                        handler: b"vide".into(),
                        name: "VideoHandler".to_string()
                    },
                    minf: Minf {
                        vmhd: Some(Vmhd {
                            graphics_mode: 0,
                            op_color: RgbColor {
                                red: 0,
                                green: 0,
                                blue: 0
                            }
                        }),
                        smhd: None,
                        dinf: Dinf {
                            dref: Dref {
                                urls: vec![Url {
                                    location: "".to_string()
                                }]
                            }
                        },
                        stbl: Stbl {
                            stsd: Stsd {
                                codecs: vec![Vp09 {
                                    visual: Visual {
                                        data_reference_index: 1,
                                        width: 320,
                                        height: 240,
                                        horizresolution: 72.into(),
                                        vertresolution: 72.into(),
                                        frame_count: 1,
                                        compressor: "\nVPC Coding".into(),
                                        depth: 24
                                    },
                                    vpcc: VpcC {
                                        profile: 0,
                                        level: 10,
                                        bit_depth: 8,
                                        chroma_subsampling: 1,
                                        video_full_range_flag: false,
                                        color_primaries: 2,
                                        transfer_characteristics: 2,
                                        matrix_coefficients: 2,
                                        codec_initialization_data: vec![]
                                    }
                                }
                                .into()],
                            },
                            stts: Stts { entries: vec![] },
                            ctts: None,
                            stss: None,
                            stsc: Stsc { entries: vec![] },
                            stsz: Stsz::default(),
                            stco: Some(Stco { entries: vec![] }),
                            co64: None,
                            sbgp: vec![],
                            sgpd: vec![],
                            subs: vec![],
                            saio: vec![],
                            saiz: vec![],
                        }
                    }
                },
                udta: None,
            }],
            udta: None
        }
    );

    // Make sure the vp09 atom encodes/decodes to the exact same content.
    let vp09 = &moov.trak[0].mdia.minf.stbl.stsd.codecs[0];
    vp09.assert_encode_decode();

    let mut buf = Vec::new();

    ftyp.encode(&mut buf).expect("failed to encode ftyp");
    moov.encode(&mut buf).expect("failed to encode moov");

    // One day:
    // assert_eq!(buf, ENCODED);
}
