use std::vec;

use crate::*;

#[test]
fn uncompressed() {
    // Simple example generated by gpac
    const ENCODED: &[u8] = &[
        0x00, 0x00, 0x00, 0x14, 0x66, 0x74, 0x79, 0x70, 0x69, 0x73, 0x6f, 0x6d, 0x00, 0x00, 0x00,
        0x01, 0x69, 0x73, 0x6f, 0x6d, 0x00, 0x00, 0x03, 0x3c, 0x6d, 0x6f, 0x6f, 0x76, 0x00, 0x00,
        0x00, 0x6c, 0x6d, 0x76, 0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x1f, 0xd4, 0x82, 0xe4,
        0x1f, 0xd4, 0x82, 0x00, 0x00, 0x02, 0x58, 0x00, 0x00, 0x04, 0xb0, 0x00, 0x01, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x02, 0x3e, 0x74, 0x72, 0x61, 0x6b, 0x00, 0x00, 0x00, 0x5c, 0x74, 0x6b,
        0x68, 0x64, 0x00, 0x00, 0x00, 0x07, 0xe4, 0x1f, 0xd4, 0x82, 0xe4, 0x1f, 0xd4, 0x82, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
        0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0xda,
        0x6d, 0x64, 0x69, 0x61, 0x00, 0x00, 0x00, 0x20, 0x6d, 0x64, 0x68, 0x64, 0x00, 0x00, 0x00,
        0x00, 0xe4, 0x1f, 0xd4, 0x82, 0xe4, 0x1f, 0xd4, 0x82, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x00, 0x02, 0x55, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x68, 0x64, 0x6c, 0x72, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x69, 0x64, 0x65, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x50, 0x41, 0x43, 0x20, 0x49, 0x53,
        0x4f, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x20, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
        0x00, 0x00, 0x00, 0x01, 0x7b, 0x6d, 0x69, 0x6e, 0x66, 0x00, 0x00, 0x00, 0x14, 0x76, 0x6d,
        0x68, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x24, 0x64, 0x69, 0x6e, 0x66, 0x00, 0x00, 0x00, 0x1c, 0x64, 0x72, 0x65, 0x66,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x75, 0x72, 0x6c,
        0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x3b, 0x73, 0x74, 0x62, 0x6c, 0x00, 0x00,
        0x00, 0xc7, 0x73, 0x74, 0x73, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xb7, 0x75, 0x6e, 0x63, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x01, 0x09, 0x52, 0x61, 0x77, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00, 0x12, 0x63,
        0x6d, 0x70, 0x64, 0x00, 0x00, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x00,
        0x00, 0x3b, 0x75, 0x6e, 0x63, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x02,
        0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x14, 0x62, 0x74, 0x72, 0x74, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
        0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x73, 0x74, 0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x28,
        0x73, 0x74, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14, 0x73, 0x74, 0x73, 0x7a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x18,
        0x73, 0x74, 0x63, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03,
        0x58, 0x00, 0x00, 0x03, 0x5e, 0x00, 0x00, 0x00, 0x8a, 0x75, 0x64, 0x74, 0x61, 0x00, 0x00,
        0x00, 0x82, 0x6d, 0x65, 0x74, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x68,
        0x64, 0x6c, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x64, 0x69, 0x72,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x55, 0x69, 0x6c, 0x73, 0x74, 0x00, 0x00, 0x00, 0x4d, 0xa9, 0x74, 0x6f, 0x6f, 0x00,
        0x00, 0x00, 0x45, 0x64, 0x61, 0x74, 0x61, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x47, 0x50, 0x41, 0x43, 0x2d, 0x32, 0x2e, 0x35, 0x2d, 0x44, 0x45, 0x56, 0x2d, 0x72, 0x65,
        0x76, 0x32, 0x30, 0x37, 0x36, 0x2d, 0x67, 0x64, 0x32, 0x34, 0x35, 0x62, 0x61, 0x35, 0x37,
        0x35, 0x2d, 0x72, 0x61, 0x77, 0x66, 0x66, 0x5f, 0x61, 0x6d, 0x64, 0x32, 0x5f, 0x32, 0x30,
        0x32, 0x34, 0x2d, 0x30, 0x37, 0x2d, 0x30, 0x36, 0x00, 0x00, 0x00, 0x14, 0x6d, 0x64, 0x61,
        0x74, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x5a, 0x66, 0x72, 0x65, 0x65, 0x49, 0x73, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x20,
        0x46, 0x69, 0x6c, 0x65, 0x20, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x77,
        0x69, 0x74, 0x68, 0x20, 0x47, 0x50, 0x41, 0x43, 0x20, 0x32, 0x2e, 0x35, 0x2d, 0x44, 0x45,
        0x56, 0x2d, 0x72, 0x65, 0x76, 0x32, 0x30, 0x37, 0x36, 0x2d, 0x67, 0x64, 0x32, 0x34, 0x35,
        0x62, 0x61, 0x35, 0x37, 0x35, 0x2d, 0x72, 0x61, 0x77, 0x66, 0x66, 0x5f, 0x61, 0x6d, 0x64,
        0x32, 0x5f, 0x32, 0x30, 0x32, 0x34, 0x2d, 0x30, 0x37, 0x2d, 0x30, 0x36, 0x00,
    ];

    let buf = &mut std::io::Cursor::new(ENCODED);
    let ftyp = Ftyp::decode(buf).expect("failed to decode ftyp");

    assert_eq!(
        ftyp,
        Ftyp {
            major_brand: b"isom".into(),
            minor_version: 1,
            compatible_brands: vec![b"isom".into(),],
        }
    );

    let moov = Moov::decode(buf).expect("failed to decode moov");

    assert_eq!(
        moov,
        Moov {
            mvhd: Mvhd {
                creation_time: 3827291266,
                modification_time: 3827291266,
                timescale: 600,
                duration: 1200,
                rate: 1.into(),
                volume: 1.into(),
                matrix: Matrix {
                    a: 65536,
                    b: 0,
                    u: 0,
                    c: 0,
                    d: 65536,
                    v: 0,
                    x: 0,
                    y: 0,
                    w: 1073741824
                },
                next_track_id: 2
            },
            meta: None,
            mvex: None,
            trak: [Trak {
                tkhd: Tkhd {
                    creation_time: 3827291266,
                    modification_time: 3827291266,
                    track_id: 1,
                    duration: 1200,
                    layer: 0,
                    alternate_group: 0,
                    enabled: true,
                    volume: 0.into(),
                    matrix: Matrix {
                        a: 65536,
                        b: 0,
                        u: 0,
                        c: 0,
                        d: 65536,
                        v: 0,
                        x: 0,
                        y: 0,
                        w: 1073741824
                    },
                    width: 2.into(),
                    height: 1.into(),
                },
                edts: None,
                meta: None,
                mdia: Mdia {
                    mdhd: Mdhd {
                        creation_time: 3827291266,
                        modification_time: 3827291266,
                        timescale: 1,
                        duration: 2,
                        language: "und".to_string(),
                    },
                    hdlr: Hdlr {
                        handler: FourCC::new(b"vide"),
                        name: "GPAC ISO Video Handler".into(),
                    },
                    minf: Minf {
                        vmhd: Some(Vmhd {
                            graphics_mode: 0,
                            op_color: RgbColor {
                                red: 0,
                                green: 0,
                                blue: 0
                            }
                        }),
                        smhd: None,
                        dinf: Dinf {
                            dref: Dref {
                                urls: vec![Url {
                                    location: "".into()
                                }],
                            }
                        },
                        stbl: Stbl {
                            stsd: Stsd {
                                codecs: vec![Codec::Uncv(Uncv {
                                    visual: Visual {
                                        data_reference_index: 1,
                                        width: 2u16,
                                        height: 1u16,
                                        horizresolution: FixedPoint::new(0, 72),
                                        vertresolution: FixedPoint::new(0, 72),
                                        frame_count: 1,
                                        compressor: "\tRaw Video".into(),
                                        depth: 24
                                    },
                                    cmpd: Some(Cmpd {
                                        components: vec![
                                            Component {
                                                component_type: 4,
                                                component_type_uri: None
                                            },
                                            Component {
                                                component_type: 5,
                                                component_type_uri: None
                                            },
                                            Component {
                                                component_type: 6,
                                                component_type_uri: None
                                            }
                                        ]
                                    }),
                                    uncc: UncC::V0 {
                                        profile: FourCC::new(b"\0\0\0\0"),
                                        components: vec![
                                            UncompressedComponent {
                                                component_index: 0,
                                                component_bit_depth_minus_one: 7,
                                                component_format: 0,
                                                component_align_size: 0
                                            },
                                            UncompressedComponent {
                                                component_index: 1,
                                                component_bit_depth_minus_one: 7,
                                                component_format: 0,
                                                component_align_size: 0
                                            },
                                            UncompressedComponent {
                                                component_index: 2,
                                                component_bit_depth_minus_one: 7,
                                                component_format: 0,
                                                component_align_size: 0
                                            },
                                        ],
                                        sampling_type: 0,
                                        interleave_type: 1,
                                        block_size: 0,
                                        components_little_endian: false,
                                        block_pad_lsb: false,
                                        block_little_endian: false,
                                        block_reversed: false,
                                        pad_unknown: false,
                                        pixel_size: 0,
                                        row_align_size: 0,
                                        tile_align_size: 0,
                                        num_tile_cols_minus_one: 0,
                                        num_tile_rows_minus_one: 0
                                    },
                                    btrt: Some(Btrt {
                                        buffer_size_db: 6,
                                        max_bitrate: 48,
                                        avg_bitrate: 48
                                    }),
                                    ccst: None,
                                    pasp: None
                                })],
                            },
                            stts: Stts {
                                entries: [SttsEntry {
                                    sample_count: 2,
                                    sample_delta: 1
                                }]
                                .into()
                            },
                            ctts: None,
                            stss: None,
                            stsc: Stsc {
                                entries: [
                                    StscEntry {
                                        first_chunk: 1,
                                        samples_per_chunk: 1,
                                        sample_description_index: 1
                                    },
                                    StscEntry {
                                        first_chunk: 2,
                                        samples_per_chunk: 1,
                                        sample_description_index: 1
                                    }
                                ]
                                .into()
                            },
                            stsz: Stsz {
                                samples: StszSamples::Identical { count: 2, size: 6 },
                            },
                            stco: Some(Stco {
                                entries: [856, 862].into()
                            }),
                            co64: None,
                            sbgp: vec![],
                            sgpd: vec![],
                            subs: vec![],
                            saiz: vec![],
                            saio: vec![],
                        }
                    }
                },
                udta: None,
            }]
            .into(),
            udta: Some(Udta {
                meta: Some(Meta {
                    hdlr: Hdlr {
                        handler: FourCC::new(b"mdir"),
                        name: "".into()
                    },
                    items: vec![Ilst::default().into()],
                }),
            })
        }
    );

    let mdat = Mdat::decode(buf).expect("failed to decode mdat");

    let mut buf = Vec::new();
    ftyp.encode(&mut buf).expect("failed to encode ftyp");
    moov.encode(&mut buf).expect("failed to encode moov");
    mdat.encode(&mut buf).expect("failed to encode mdat");

    // assert_eq!(buf, ENCODED);
}
