use crate::*;

#[test]
fn flac() {
    const ENCODED: &[u8] = &[
        0x00, 0x00, 0x00, 0x14, 0x66, 0x74, 0x79, 0x70, 0x69, 0x73, 0x6f, 0x36, 0x00, 0x00, 0x00,
        0x00, 0x69, 0x73, 0x6f, 0x36, 0x00, 0x00, 0x02, 0xb1, 0x6d, 0x6f, 0x6f, 0x76, 0x00, 0x00,
        0x00, 0x78, 0x6d, 0x76, 0x68, 0x64, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4,
        0xe9, 0xa4, 0xe9, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xe9, 0xa4, 0xe9, 0x00, 0x00, 0xac, 0x44,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
        0x02, 0x09, 0x74, 0x72, 0x61, 0x6b, 0x00, 0x00, 0x00, 0x68, 0x74, 0x6b, 0x68, 0x64, 0x01,
        0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xe9, 0xa4, 0xe9, 0x00, 0x00, 0x00, 0x00,
        0xe4, 0xe9, 0xa4, 0xe9, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x99, 0x6d, 0x64, 0x69, 0x61, 0x00, 0x00,
        0x00, 0x2c, 0x6d, 0x64, 0x68, 0x64, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4,
        0xe9, 0xa4, 0xe9, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xe9, 0xa4, 0xe9, 0x00, 0x00, 0xac, 0x44,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x2d, 0x68, 0x64, 0x6c, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x6f,
        0x75, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53,
        0x6f, 0x75, 0x6e, 0x64, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x00, 0x00, 0x00, 0x01,
        0x38, 0x6d, 0x69, 0x6e, 0x66, 0x00, 0x00, 0x00, 0x10, 0x73, 0x6d, 0x68, 0x64, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x64, 0x69, 0x6e, 0x66, 0x00,
        0x00, 0x00, 0x1c, 0x64, 0x72, 0x65, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x0c, 0x75, 0x72, 0x6c, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xfc, 0x73, 0x74, 0x62, 0x6c, 0x00, 0x00, 0x00, 0xb0, 0x73, 0x74, 0x73, 0x64, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xa0, 0x66, 0x4c, 0x61, 0x43, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7c, 0x64, 0x66, 0x4c, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x00,
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc4, 0x40, 0x70, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x84, 0x00, 0x00, 0x46, 0x20, 0x00, 0x00, 0x00, 0x72, 0x65, 0x66, 0x65, 0x72,
        0x65, 0x6e, 0x63, 0x65, 0x20, 0x6c, 0x69, 0x62, 0x46, 0x4c, 0x41, 0x43, 0x20, 0x31, 0x2e,
        0x34, 0x2e, 0x33, 0x20, 0x32, 0x30, 0x32, 0x33, 0x30, 0x36, 0x32, 0x33, 0x01, 0x00, 0x00,
        0x00, 0x1a, 0x00, 0x00, 0x00, 0x44, 0x45, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f,
        0x4e, 0x3d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x74, 0x65, 0x73, 0x74, 0x20, 0x77, 0x61, 0x76,
        0x65, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x73, 0x74, 0x73, 0x7a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x63,
        0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6d, 0x76,
        0x65, 0x78, 0x00, 0x00, 0x00, 0x20, 0x74, 0x72, 0x65, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x73, 0x74, 0x79, 0x70, 0x69, 0x73, 0x6f,
        0x36, 0x00, 0x00, 0x00, 0x00, 0x69, 0x73, 0x6f, 0x36, 0x6c, 0x6d, 0x73, 0x67, 0x00, 0x00,
        0x00, 0x68, 0x6d, 0x6f, 0x6f, 0x66, 0x00, 0x00, 0x00, 0x10, 0x6d, 0x66, 0x68, 0x64, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x74, 0x72, 0x61, 0x66,
        0x00, 0x00, 0x00, 0x18, 0x74, 0x66, 0x68, 0x64, 0x00, 0x02, 0x00, 0x28, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x12, 0x00, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x74, 0x66,
        0x64, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x74,
        0x72, 0x75, 0x6e, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x70,
        0x00, 0x00, 0x04, 0x31, 0x00, 0x00, 0x04, 0x33, 0x00, 0x00, 0x00, 0xfb, 0x00, 0x00, 0x09,
        0x67, 0x6d, 0x64, 0x61, 0x74, 0xff, 0xf8, 0x59, 0x02, 0x00, 0xbe, 0x14, 0x06, 0x0c, 0x0c,
        0x0b, 0xe9, 0x52, 0xee, 0xdd, 0xbb, 0x7b, 0x7a, 0x5d, 0x34, 0xa7, 0xf3, 0xcc, 0xa4, 0xa1,
        0x4c, 0xce, 0x73, 0x3c, 0xca, 0x7e, 0x59, 0x65, 0xa5, 0x22, 0x5d, 0xdd, 0xb7, 0x76, 0x95,
        0xf7, 0xd3, 0x4d, 0x3c, 0xa6, 0x53, 0x39, 0xcc, 0xca, 0x14, 0x9e, 0x73, 0x94, 0xf2, 0x96,
        0x5f, 0xbd, 0xea, 0x54, 0x89, 0x52, 0x25, 0xb4, 0x89, 0x7b, 0x22, 0x74, 0xa6, 0x9c, 0xa6,
        0x53, 0x3c, 0x94, 0x29, 0x99, 0xce, 0x73, 0xcf, 0xca, 0x59, 0x7d, 0xe9, 0x12, 0xdd, 0xdb,
        0x77, 0x7b, 0x4b, 0xd3, 0x4a, 0x7e, 0x52, 0x53, 0x99, 0xce, 0x66, 0x50, 0xa6, 0x73, 0xcd,
        0x25, 0x96, 0x59, 0x69, 0x74, 0xaf, 0x6e, 0xdd, 0xbb, 0xda, 0x5f, 0x4d, 0x29, 0xf3, 0x42,
        0x9c, 0xe6, 0x73, 0x39, 0x94, 0x29, 0x9e, 0x53, 0xca, 0x59, 0x7e, 0xe9, 0x52, 0xa4, 0x4b,
        0x6e, 0xed, 0xee, 0xca, 0x9d, 0x29, 0xa6, 0x53, 0xce, 0x73, 0x99, 0x09, 0xce, 0x73, 0x3e,
        0x7e, 0x52, 0xcb, 0xd2, 0xd2, 0xdd, 0xd4, 0xa9, 0x12, 0xa4, 0x4b, 0xba, 0x5e, 0x9a, 0x53,
        0xf3, 0xcf, 0x25, 0x25, 0x0a, 0x4a, 0x14, 0xcc, 0xa4, 0xa4, 0xa5, 0x32, 0xca, 0x5c, 0xa9,
        0x4a, 0x96, 0xf5, 0xed, 0xbb, 0xbb, 0xdf, 0xa6, 0x94, 0xf2, 0x9c, 0xf3, 0x39, 0xcc, 0xcf,
        0x25, 0x25, 0x32, 0x9e, 0x59, 0x65, 0xf4, 0xa9, 0x69, 0x5d, 0xdb, 0x48, 0x96, 0xef, 0x4b,
        0x4d, 0x34, 0xe8, 0x59, 0xca, 0x14, 0xe6, 0x73, 0x39, 0x9c, 0xf3, 0x9f, 0xca, 0x59, 0x74,
        0xbd, 0xda, 0x57, 0x6e, 0xd2, 0x25, 0xbe, 0xfa, 0x69, 0x4f, 0x94, 0xca, 0x4a, 0x4f, 0x33,
        0x39, 0xcc, 0xf3, 0x94, 0xe5, 0x94, 0xbf, 0xbd, 0xdd, 0xdb, 0x78, 0x97, 0x69, 0x52, 0xfd,
        0x34, 0xd3, 0x94, 0xca, 0x4a, 0x67, 0x25, 0x25, 0x0a, 0x4a, 0x4f, 0x3c, 0xf9, 0x65, 0x97,
        0xde, 0xf5, 0x2a, 0x44, 0xa9, 0x5d, 0xa5, 0x4b, 0x4b, 0xa6, 0x81, 0xa7, 0xe5, 0x25, 0x33,
        0x94, 0x3c, 0xcc, 0xe7, 0x39, 0xe7, 0xf2, 0x96, 0x5d, 0x2e, 0xf6, 0xee, 0xdb, 0xd4, 0xa9,
        0x69, 0x7d, 0x29, 0xa7, 0xcf, 0x99, 0x42, 0x99, 0xcc, 0xe4, 0xa6, 0x73, 0xca, 0x72, 0xca,
        0x5f, 0xdd, 0xee, 0xdd, 0xbb, 0x74, 0x89, 0x76, 0x44, 0xe9, 0xa6, 0x99, 0x4f, 0x39, 0x94,
        0x29, 0x99, 0xce, 0x4a, 0x65, 0x25, 0x3e, 0x59, 0x65, 0xe9, 0x69, 0x52, 0xbd, 0xb7, 0x76,
        0xf7, 0x4b, 0xd2, 0x9a, 0x7e, 0x79, 0xce, 0x73, 0x33, 0xc9, 0xe6, 0x52, 0x52, 0x92, 0xe5,
        0x2c, 0xb4, 0xa5, 0x4a, 0x96, 0xd2, 0x25, 0x48, 0x95, 0x2b, 0xde, 0xfd, 0x29, 0xa7, 0x94,
        0xe7, 0x28, 0x52, 0x50, 0xa4, 0xa4, 0xe7, 0x32, 0x99, 0x4f, 0x2c, 0xa5, 0xfb, 0xed, 0xdd,
        0xdb, 0x77, 0x77, 0xa5, 0xa6, 0x94, 0xe9, 0x2c, 0xe7, 0x99, 0xce, 0x66, 0x50, 0xa4, 0xa4,
        0xa7, 0x3f, 0x2c, 0xa5, 0xe9, 0x7b, 0x48, 0x96, 0xe0, 0xdd, 0xbb, 0xa4, 0x4d, 0xf4, 0xa6,
        0x9f, 0x29, 0x9e, 0x73, 0x39, 0x9c, 0xcf, 0x25, 0x39, 0x4c, 0xb2, 0xcb, 0x2a, 0x6f, 0x76,
        0x91, 0x2d, 0xbb, 0xb7, 0x4a, 0x97, 0xe9, 0x4d, 0x3c, 0xa6, 0x79, 0xce, 0x66, 0x73, 0x99,
        0x42, 0x9e, 0x7c, 0xb2, 0x97, 0xef, 0x77, 0x76, 0xd2, 0x25, 0x7b, 0x4b, 0x4b, 0xa6, 0x94,
        0xe8, 0x59, 0xe5, 0x0a, 0x66, 0x50, 0xa4, 0xa1, 0x49, 0x49, 0xe7, 0x9f, 0x96, 0x52, 0xf4,
        0xbb, 0xbd, 0x48, 0x96, 0xdd, 0xda, 0x5a, 0x5e, 0x9a, 0x69, 0xf3, 0xe4, 0xa6, 0x73, 0x99,
        0x9c, 0xe7, 0x28, 0x52, 0x99, 0x65, 0x97, 0xe9, 0x6f, 0x6e, 0xed, 0xa4, 0x4a, 0x96, 0xf7,
        0xf4, 0xa6, 0x9c, 0xa7, 0x99, 0xe6, 0x73, 0x39, 0x9c, 0xe5, 0x25, 0x3e, 0x52, 0xcb, 0xe9,
        0x52, 0xee, 0xdd, 0xbb, 0x7b, 0x7a, 0x5d, 0x34, 0xa7, 0xf3, 0xcc, 0xa4, 0xa1, 0x4c, 0xce,
        0x73, 0x3c, 0xca, 0x7e, 0x41, 0x96, 0x5a, 0x52, 0x25, 0xdd, 0xdb, 0x77, 0x69, 0x5f, 0x7d,
        0x34, 0xd3, 0xca, 0x65, 0x33, 0x9c, 0xcc, 0xa1, 0x49, 0xe7, 0x39, 0x4f, 0x29, 0x65, 0xfb,
        0xde, 0xa5, 0x48, 0x95, 0x22, 0x5b, 0x48, 0x97, 0xb2, 0x27, 0x4a, 0x69, 0xca, 0x65, 0x33,
        0xc9, 0x42, 0x99, 0x9c, 0xe7, 0x3c, 0xfc, 0xa5, 0x97, 0xde, 0x91, 0x2d, 0xdd, 0xb7, 0x77,
        0xb4, 0xbd, 0x34, 0xa7, 0xe5, 0x25, 0x39, 0x9c, 0xe6, 0x65, 0x0a, 0x67, 0x3c, 0xd2, 0x59,
        0x65, 0x96, 0x97, 0x4a, 0xf6, 0xed, 0xdb, 0xbd, 0xa5, 0xf4, 0xd2, 0x9f, 0x34, 0x29, 0xce,
        0x67, 0x33, 0x99, 0x42, 0x99, 0xe5, 0x3c, 0xa5, 0x97, 0xee, 0x95, 0x2a, 0x44, 0xb6, 0xee,
        0xde, 0xec, 0xa9, 0xd2, 0x9a, 0x65, 0x3c, 0xe7, 0x39, 0x99, 0xce, 0x73, 0x3e, 0x7e, 0x52,
        0xcb, 0xd2, 0xd2, 0xdd, 0xd4, 0xa9, 0x12, 0xa4, 0x4b, 0xba, 0x5e, 0x9a, 0x53, 0xf3, 0xcf,
        0x25, 0x25, 0x08, 0x24, 0xa1, 0x4c, 0xca, 0x4a, 0x4a, 0x53, 0x2c, 0xa5, 0xca, 0x94, 0xa9,
        0x6f, 0x5e, 0xdb, 0xbb, 0xbd, 0xfa, 0x69, 0x4f, 0x29, 0xcf, 0x33, 0x9c, 0xcc, 0xf2, 0x52,
        0x53, 0x29, 0xe5, 0x96, 0x5f, 0x4a, 0x96, 0x95, 0xdd, 0xb4, 0x89, 0x6e, 0xf4, 0xb4, 0xd3,
        0x4e, 0x85, 0x9c, 0xa1, 0x4e, 0x67, 0x33, 0x99, 0xcf, 0x39, 0xfc, 0xa5, 0x97, 0x4b, 0xdd,
        0xa5, 0x76, 0xed, 0x22, 0x5b, 0xef, 0xa6, 0x94, 0xf9, 0x4c, 0xa4, 0xa4, 0xf3, 0x33, 0x9c,
        0xcf, 0x39, 0x4e, 0x59, 0x4b, 0xfb, 0xdd, 0xdd, 0xb7, 0x89, 0x76, 0x95, 0x2f, 0xd3, 0x4d,
        0x39, 0x4c, 0xa4, 0xa6, 0x72, 0x52, 0x50, 0xa4, 0xa4, 0xf3, 0xcf, 0x96, 0x59, 0x7d, 0xef,
        0x52, 0xa4, 0x4a, 0x95, 0xda, 0x54, 0xb4, 0xba, 0x69, 0xa7, 0xe5, 0x25, 0x33, 0x94, 0x3c,
        0xcc, 0xe7, 0x39, 0xe7, 0xf2, 0x96, 0x5d, 0x2e, 0xf6, 0xee, 0xdb, 0xd4, 0xa9, 0x69, 0x7d,
        0x02, 0x9a, 0x7c, 0xf9, 0x94, 0x29, 0x9c, 0xce, 0x4a, 0x67, 0x3c, 0xa7, 0x2c, 0xa5, 0xfd,
        0xde, 0xed, 0xdb, 0xb7, 0x48, 0x97, 0x64, 0x4e, 0x9a, 0x69, 0x94, 0xf3, 0x99, 0x42, 0x99,
        0x9c, 0xe4, 0xa6, 0x52, 0x53, 0xe5, 0x96, 0x5e, 0x96, 0x95, 0x2b, 0xdb, 0x77, 0x6f, 0x74,
        0xbd, 0x29, 0xa7, 0xe7, 0x9c, 0xe7, 0x33, 0x3c, 0x9e, 0x65, 0x25, 0x29, 0x2e, 0x52, 0xcb,
        0x4a, 0x54, 0xa9, 0x6d, 0x22, 0x54, 0x89, 0x52, 0xbd, 0xef, 0xd2, 0x9a, 0x79, 0x4e, 0x72,
        0x85, 0x25, 0x0a, 0x4a, 0x4e, 0x73, 0x29, 0x94, 0xf2, 0xca, 0x5f, 0xbe, 0xdd, 0xdd, 0xb7,
        0x77, 0x7a, 0x5a, 0x69, 0x4e, 0x92, 0xce, 0x79, 0x9c, 0xe6, 0x65, 0x0a, 0x4a, 0x4a, 0x73,
        0xf2, 0xca, 0x5e, 0x97, 0xb4, 0x89, 0x6e, 0xdd, 0xbb, 0xa4, 0x4d, 0xf4, 0xa6, 0x9f, 0x29,
        0x9e, 0x73, 0x39, 0x9c, 0xcf, 0x25, 0x39, 0x4c, 0xb2, 0xcb, 0x2a, 0x6f, 0x76, 0x91, 0x28,
        0x5b, 0xbb, 0x74, 0xa9, 0x7e, 0x94, 0xd3, 0xca, 0x67, 0x9c, 0xe6, 0x67, 0x39, 0x94, 0x29,
        0xe7, 0xcb, 0x29, 0x7e, 0xf7, 0x77, 0x6d, 0x22, 0x57, 0xb4, 0xb4, 0xba, 0x69, 0x4e, 0x85,
        0x9e, 0x50, 0xa6, 0x65, 0x0a, 0x4a, 0x14, 0x94, 0x9e, 0x79, 0xf9, 0x65, 0x2f, 0x4b, 0xbb,
        0xd4, 0x89, 0x6d, 0xdd, 0xa5, 0xa5, 0xe9, 0xa6, 0x9f, 0x3e, 0x4a, 0x67, 0x39, 0x99, 0xce,
        0x72, 0x85, 0x29, 0x96, 0x59, 0x7e, 0x96, 0xf6, 0xee, 0xda, 0x44, 0xa9, 0x6f, 0x7f, 0x4a,
        0x69, 0xca, 0x79, 0x9e, 0x67, 0x33, 0x99, 0xce, 0x52, 0x53, 0xe5, 0x2c, 0xbe, 0x95, 0x2e,
        0xed, 0xdb, 0xb7, 0xb7, 0xa5, 0xd3, 0x4a, 0x7f, 0x3c, 0xca, 0x4a, 0x14, 0xcc, 0xe7, 0x33,
        0xcc, 0xa7, 0xe5, 0x96, 0x5a, 0x52, 0x25, 0xdd, 0xdb, 0x77, 0x69, 0x5f, 0x7d, 0x34, 0xd3,
        0xca, 0x65, 0x33, 0x9c, 0xcc, 0xa1, 0x49, 0xe7, 0x39, 0x4f, 0x20, 0xe8, 0x5a, 0xff, 0xf8,
        0x59, 0x02, 0x01, 0xb9, 0x14, 0xf6, 0xfd, 0x0c, 0x19, 0x7e, 0xf7, 0xa9, 0x52, 0x25, 0x48,
        0x96, 0xd2, 0x25, 0xec, 0x89, 0xd2, 0x9a, 0x72, 0x99, 0x4c, 0xf2, 0x50, 0xa6, 0x67, 0x39,
        0xcf, 0x3f, 0x29, 0x65, 0xf7, 0xa4, 0x4b, 0x77, 0x6d, 0xdd, 0xed, 0x2f, 0x4d, 0x29, 0xf9,
        0x49, 0x4e, 0x67, 0x39, 0x99, 0x42, 0x99, 0xcf, 0x34, 0x96, 0x59, 0x65, 0xa5, 0xd2, 0xbd,
        0xbb, 0x76, 0xef, 0x69, 0x7d, 0x34, 0xa7, 0xcd, 0x0a, 0x73, 0x99, 0xcc, 0xe6, 0x50, 0xa6,
        0x79, 0x4f, 0x29, 0x65, 0xfb, 0xa5, 0x4a, 0x91, 0x2d, 0xbb, 0xb7, 0xbb, 0x2a, 0x74, 0xa6,
        0x99, 0x4f, 0x39, 0xce, 0x66, 0x73, 0x9c, 0xcf, 0x9f, 0x94, 0xb2, 0xf4, 0xb4, 0xb7, 0x75,
        0x2a, 0x44, 0xa9, 0x12, 0xee, 0x97, 0xa6, 0x94, 0xfc, 0xf3, 0xc9, 0x49, 0x42, 0x92, 0x85,
        0x33, 0x29, 0x29, 0x29, 0x4c, 0xb2, 0x97, 0x2a, 0x52, 0xa5, 0xbd, 0x7b, 0x6e, 0xee, 0xf7,
        0xe9, 0xa5, 0x3c, 0xa7, 0x3c, 0xce, 0x43, 0x33, 0x3c, 0x94, 0x94, 0xca, 0x79, 0x65, 0x97,
        0xd2, 0xa5, 0xa5, 0x77, 0x6d, 0x22, 0x5b, 0xbd, 0x2d, 0x34, 0xd3, 0xa1, 0x67, 0x28, 0x53,
        0x99, 0xcc, 0xe6, 0x73, 0xce, 0x7f, 0x29, 0x65, 0xd2, 0xf7, 0x69, 0x5d, 0xbb, 0x48, 0x96,
        0xfb, 0xe9, 0xa5, 0x3e, 0x53, 0x29, 0x29, 0x3c, 0xcc, 0xe7, 0x33, 0xce, 0x53, 0x96, 0x52,
        0xfe, 0xf7, 0x77, 0x6d, 0xe2, 0x5d, 0xa5, 0x4b, 0xf4, 0xd3, 0x4e, 0x53, 0x29, 0x29, 0x9c,
        0x94, 0x94, 0x29, 0x29, 0x3c, 0xf3, 0xe5, 0x96, 0x5f, 0x7b, 0xd4, 0xa9, 0x12, 0xa5, 0x76,
        0x95, 0x2d, 0x2e, 0x9a, 0x69, 0xf9, 0x49, 0x4c, 0xe5, 0x0f, 0x33, 0x39, 0xce, 0x79, 0xfc,
        0xa5, 0x97, 0x4b, 0xbd, 0xbb, 0xb6, 0xf5, 0x2a, 0x5a, 0x5f, 0x4a, 0x69, 0xf3, 0xe6, 0x50,
        0xa6, 0x73, 0x39, 0x29, 0x9c, 0xf2, 0x9c, 0xb2, 0x97, 0xf7, 0x7b, 0xb7, 0x6e, 0xdd, 0x22,
        0x5d, 0x91, 0x30, 0xa6, 0x9a, 0x65, 0x3c, 0xe6, 0x50, 0xa6, 0x67, 0x39, 0x29, 0x94, 0x94,
        0xf9, 0x65, 0x97, 0xa5, 0xa5, 0x4a, 0xf6, 0xdd, 0xdb, 0xdd, 0x2f, 0x4a, 0x69, 0xf9, 0xe7,
        0x39, 0xcc, 0xcf, 0x27, 0x99, 0x49, 0x4a, 0x4b, 0x94, 0xb2, 0xd2, 0x95, 0x2a, 0x5b, 0x48,
        0x95, 0x22, 0x54, 0xaf, 0x7b, 0xf4, 0xa6, 0x9e, 0x53, 0x9c, 0xa1, 0x49, 0x42, 0x92, 0x93,
        0x9c, 0xca, 0x65, 0x3c, 0xb2, 0x97, 0xef, 0xb7, 0x77, 0x6d, 0xdd, 0xde, 0x96, 0x9a, 0x53,
        0xa4, 0xb3, 0x9e, 0x67, 0x39, 0x99, 0x42, 0x92, 0x92, 0x9c, 0xfc, 0xb2, 0x97, 0xa5, 0xed,
        0x22, 0x5b, 0xb7, 0x6e, 0xe9, 0x13, 0x7d, 0x29, 0xa7, 0xca, 0x67, 0x9c, 0xce, 0x67, 0x33,
        0xc9, 0x4e, 0x53, 0x2c, 0xb2, 0xca, 0x9b, 0xdd, 0xa4, 0x4b, 0x6e, 0xed, 0xd2, 0xa5, 0xfa,
        0x53, 0x4f, 0x29, 0x9e, 0x73, 0x99, 0x9c, 0xe6, 0x50, 0xa7, 0x9f, 0x2c, 0xa5, 0xfb, 0xdd,
        0xdc, 0x1b, 0x48, 0x95, 0xed, 0x2d, 0x2e, 0x9a, 0x53, 0xa1, 0x67, 0x94, 0x29, 0x99, 0x42,
        0x92, 0x85, 0x25, 0x27, 0x9e, 0x7e, 0x59, 0x4b, 0xd2, 0xee, 0xf5, 0x22, 0x5b, 0x77, 0x69,
        0x69, 0x7a, 0x69, 0xa7, 0xcf, 0x92, 0x99, 0xce, 0x66, 0x73, 0x9c, 0xa1, 0x4a, 0x65, 0x96,
        0x5f, 0xa5, 0xbd, 0xbb, 0xb6, 0x91, 0x2a, 0x5b, 0xdf, 0xd2, 0x9a, 0x72, 0x9e, 0x67, 0x99,
        0xcc, 0xe6, 0x73, 0x94, 0x94, 0xf9, 0x4b, 0x2f, 0xa5, 0x4b, 0xbb, 0x76, 0xed, 0xed, 0xe9,
        0x74, 0xd2, 0x9f, 0xcf, 0x32, 0x92, 0x85, 0x33, 0x39, 0xcc, 0xf3, 0x29, 0xf9, 0x65, 0x96,
        0x94, 0x89, 0x77, 0x76, 0xdd, 0xda, 0x57, 0xdf, 0x4d, 0x34, 0xf2, 0x99, 0x4c, 0xe7, 0x33,
        0x28, 0x52, 0x79, 0xce, 0x53, 0xca, 0x59, 0x7e, 0xf7, 0xa9, 0x52, 0x25, 0x48, 0x96, 0xd2,
        0x25, 0xec, 0x89, 0xd2, 0x9a, 0x72, 0x99, 0x4c, 0xf2, 0x50, 0xa6, 0x67, 0x39, 0xcf, 0x3e,
        0x12, 0x96, 0x5f, 0x7a, 0x44, 0xb7, 0x76, 0xdd, 0xde, 0xd2, 0xf4, 0xd2, 0x9f, 0x94, 0x94,
        0xe6, 0x73, 0x99, 0x94, 0x29, 0x9c, 0xf3, 0x49, 0x65, 0x96, 0x5a, 0x5d, 0x2b, 0xdb, 0xb7,
        0x6e, 0xf6, 0x97, 0xd3, 0x4a, 0x7c, 0xd0, 0xa7, 0x39, 0x9c, 0xce, 0x65, 0x0a, 0x67, 0x94,
        0xf2, 0x96, 0x5f, 0xba, 0x54, 0xa9, 0x12, 0xdb, 0xbb, 0x7b, 0xb2, 0xa7, 0x4a, 0x69, 0x94,
        0xf3, 0x9c, 0xe6, 0x67, 0x39, 0xcc, 0xf9, 0xf9, 0x4b, 0x2f, 0x4b, 0x4b, 0x77, 0x52, 0xa4,
        0x4a, 0x91, 0x2e, 0xe9, 0x7a, 0x69, 0x4f, 0xcf, 0x3c, 0x94, 0x94, 0x29, 0x28, 0x53, 0x32,
        0x92, 0x92, 0x94, 0xcb, 0x29, 0x72, 0xa5, 0x2a, 0x5b, 0xd7, 0xb6, 0xee, 0xef, 0x7e, 0x9a,
        0x53, 0xca, 0x73, 0xcc, 0xe7, 0x33, 0x3c, 0x94, 0x94, 0xca, 0x79, 0x65, 0x97, 0xd2, 0xa5,
        0xa5, 0x77, 0x6d, 0x22, 0x5b, 0xbd, 0x2d, 0x34, 0xd3, 0xa1, 0x67, 0x28, 0x53, 0x98, 0x1c,
        0xce, 0x67, 0x3c, 0xe7, 0xf2, 0x96, 0x5d, 0x2f, 0x76, 0x95, 0xdb, 0xb4, 0x89, 0x6f, 0xbe,
        0x9a, 0x53, 0xe5, 0x32, 0x92, 0x93, 0xcc, 0xce, 0x73, 0x3c, 0xe5, 0x39, 0x65, 0x2f, 0xef,
        0x77, 0x76, 0xde, 0x25, 0xda, 0x54, 0xbf, 0x4d, 0x34, 0xe5, 0x32, 0x92, 0x99, 0xc9, 0x49,
        0x42, 0x92, 0x93, 0xcf, 0x3e, 0x59, 0x65, 0xf7, 0xbd, 0x4a, 0x91, 0x2a, 0x57, 0x69, 0x52,
        0xd2, 0xe9, 0xa6, 0x9f, 0x94, 0x94, 0xce, 0x50, 0xf3, 0x33, 0x9c, 0xe7, 0x9f, 0xca, 0x59,
        0x74, 0xbb, 0xdb, 0xbb, 0x6f, 0x52, 0xa5, 0xa5, 0xf4, 0xa6, 0x9f, 0x3e, 0x65, 0x0a, 0x67,
        0x33, 0x92, 0x99, 0xcf, 0x29, 0xcb, 0x29, 0x7f, 0x77, 0xbb, 0x76, 0xed, 0xd2, 0x25, 0xd9,
        0x13, 0xa6, 0x9a, 0x65, 0x3c, 0xe6, 0x50, 0xa6, 0x67, 0x39, 0x29, 0x94, 0x94, 0xf9, 0x65,
        0x97, 0xa5, 0xa5, 0x4a, 0xf6, 0xdd, 0xdb, 0xdd, 0x2e, 0x14, 0xa6, 0x9f, 0x9e, 0x73, 0x9c,
        0xcc, 0xf2, 0x79, 0x94, 0x94, 0xa4, 0xb9, 0x4b, 0x2d, 0x29, 0x52, 0xa5, 0xb4, 0x89, 0x52,
        0x25, 0x4a, 0xf7, 0xbf, 0x4a, 0x69, 0xe5, 0x39, 0xca, 0x14, 0x94, 0x29, 0x29, 0x39, 0xcc,
        0xa6, 0x53, 0xcb, 0x29, 0x7e, 0xfb, 0x77, 0x76, 0xdd, 0xdd, 0xe9, 0x69, 0xa5, 0x3a, 0x4b,
        0x39, 0xe6, 0x73, 0x99, 0x94, 0x29, 0x29, 0x29, 0xcf, 0xcb, 0x29, 0x7a, 0x5e, 0xd2, 0x25,
        0xbb, 0x76, 0xee, 0x91, 0x37, 0xd2, 0x9a, 0x7c, 0xa6, 0x79, 0xcc, 0xe6, 0x73, 0x3c, 0x94,
        0xe5, 0x32, 0xcb, 0x2c, 0xa9, 0xbd, 0xda, 0x44, 0xb6, 0xee, 0xdd, 0x2a, 0x5f, 0xa5, 0x34,
        0xf2, 0x99, 0xe7, 0x39, 0x99, 0xce, 0x65, 0x0a, 0x79, 0xf2, 0xca, 0x5f, 0xbd, 0xdd, 0xdb,
        0x48, 0x95, 0xed, 0x2d, 0x2e, 0x9a, 0x53, 0xa1, 0x67, 0x94, 0x29, 0x99, 0x42, 0x92, 0x85,
        0x25, 0x27, 0x9e, 0x7e, 0x59, 0x4b, 0xd2, 0xee, 0xf4, 0x12, 0x25, 0xb7, 0x76, 0x96, 0x97,
        0xa6, 0x9a, 0x7c, 0xf9, 0x29, 0x9c, 0xe6, 0x67, 0x39, 0xca, 0x14, 0xa6, 0x59, 0x65, 0xfa,
        0x5b, 0xdb, 0xbb, 0x69, 0x12, 0xa5, 0xbd, 0xfd, 0x29, 0xa7, 0x29, 0xe6, 0x79, 0x9c, 0xce,
        0x67, 0x39, 0x49, 0x4f, 0x94, 0xb2, 0xfa, 0x54, 0xbb, 0xb7, 0x6e, 0xde, 0xde, 0x97, 0x4d,
        0x29, 0xfc, 0xf3, 0x29, 0x28, 0x53, 0x33, 0x9c, 0xcf, 0x32, 0x9f, 0x96, 0x59, 0x69, 0x48,
        0x97, 0x77, 0x6d, 0xdd, 0xa5, 0x7d, 0xf4, 0xd3, 0x4f, 0x29, 0x94, 0xce, 0x73, 0x32, 0x85,
        0x27, 0x9c, 0xe5, 0x3c, 0xa5, 0x97, 0xef, 0x7a, 0x95, 0x22, 0x54, 0x89, 0x6d, 0x22, 0x5e,
        0xc8, 0x9d, 0x29, 0xa7, 0x29, 0x94, 0xcf, 0x25, 0x0a, 0x66, 0x73, 0x9c, 0xf3, 0xf2, 0x96,
        0x5f, 0x7a, 0x44, 0xb7, 0x76, 0xdd, 0xde, 0xd2, 0xf4, 0xd2, 0x9f, 0x94, 0x94, 0xe6, 0x73,
        0x99, 0x94, 0x29, 0x9c, 0xf3, 0x48, 0x22, 0x5b, 0xff, 0xf8, 0xa9, 0x02, 0x02, 0xdc, 0x14,
        0xe7, 0xed, 0x0c, 0x25, 0x96, 0x5a, 0x5d, 0x2b, 0xdb, 0xb7, 0x6e, 0xf6, 0x97, 0xd3, 0x4a,
        0x7c, 0xd0, 0xa7, 0x39, 0x9c, 0xce, 0x65, 0x0a, 0x67, 0x94, 0xf2, 0x96, 0x5f, 0xba, 0x54,
        0xa9, 0x12, 0x85, 0xbb, 0xb7, 0xbb, 0x2a, 0x74, 0xa6, 0x99, 0x4f, 0x39, 0xce, 0x66, 0x73,
        0x9c, 0xcf, 0x9f, 0x94, 0xb2, 0xf4, 0xb4, 0xb7, 0x75, 0x2a, 0x44, 0xa9, 0x12, 0xee, 0x97,
        0xa6, 0x81, 0x4f, 0xcf, 0x3c, 0x94, 0x94, 0x29, 0x28, 0x53, 0x32, 0x92, 0x92, 0x94, 0xcb,
        0x29, 0x72, 0xa5, 0x2a, 0x5b, 0xd7, 0xb6, 0xee, 0xef, 0x7e, 0x9a, 0x53, 0xca, 0x73, 0xcc,
        0xe7, 0x33, 0x03, 0xc9, 0x49, 0x4c, 0xa7, 0x96, 0x59, 0x7d, 0x2a, 0x5a, 0x57, 0x76, 0xd2,
        0x25, 0xbb, 0xd2, 0xd3, 0x4d, 0x3a, 0x16, 0x72, 0x85, 0x39, 0x9c, 0xce, 0x67, 0x3c, 0xe7,
        0xf2, 0x96, 0x58, 0x52, 0xf7, 0x69, 0x5d, 0xbb, 0x48, 0x96, 0xfb, 0xe9, 0xa5, 0x3e, 0x53,
        0x29, 0x29, 0x3c, 0xcc, 0xe7, 0x33, 0xce, 0x53, 0x96, 0x52, 0xfe, 0xf7, 0x77, 0x6d, 0xe2,
        0x58, 0x5a, 0x54, 0xbf, 0x4d, 0x34, 0xe5, 0x32, 0x92, 0x99, 0xc9, 0x49, 0x42, 0x92, 0x93,
        0xcf, 0x3e, 0x59, 0x65, 0xf7, 0xbd, 0x4a, 0x91, 0x2a, 0x57, 0x69, 0x52, 0xd2, 0xe9, 0xa6,
        0x9f, 0x94, 0x81, 0x4c, 0xe5, 0x0f, 0x33, 0x39, 0xce, 0x79, 0xfc, 0xa5, 0x97, 0x4b, 0xbd,
        0xbb, 0xb6, 0xf5, 0x2a, 0x5a, 0x5f, 0x4a, 0x69, 0xf3, 0xe6, 0x50, 0xa6, 0x73, 0x39, 0x29,
        0x9c, 0xc3, 0x29, 0xcb, 0x29, 0x7f, 0x77, 0xbb, 0x76, 0xed, 0xd2, 0x25, 0xd9, 0x13, 0xa6,
        0x9a, 0x65, 0x3c, 0xe6, 0x50, 0xa6, 0x67, 0x39, 0x29, 0x94, 0x94, 0xf9, 0x65, 0x97, 0xa5,
        0xa5, 0x48, 0x02, 0xe6,
    ];

    let buf = &mut std::io::Cursor::new(&ENCODED);

    let ftyp = Ftyp::decode(buf).expect("failed to decode ftyp");

    assert_eq!(
        ftyp,
        Ftyp {
            major_brand: b"iso6".into(),
            minor_version: 0,
            compatible_brands: vec![b"iso6".into(),],
        }
    );

    let moov = Moov::decode(buf).expect("failed to decode moov");
    assert_eq!(
        moov,
        Moov {
            mvhd: Mvhd {
                creation_time: 3840517353,
                modification_time: 3840517353,
                timescale: 44100,
                duration: 0,
                rate: 1.into(),
                volume: 1.into(),
                matrix: Matrix {
                    a: 65536,
                    b: 0,
                    u: 0,
                    c: 0,
                    d: 65536,
                    v: 0,
                    x: 0,
                    y: 0,
                    w: 1073741824
                },
                next_track_id: 2
            },
            meta: None,
            mvex: Some(Mvex {
                mehd: None,
                trex: vec![Trex {
                    track_id: 1,
                    default_sample_description_index: 1,
                    default_sample_duration: 0,
                    default_sample_size: 0,
                    default_sample_flags: 0
                }]
            }),
            trak: vec![Trak {
                tkhd: Tkhd {
                    creation_time: 3840517353,
                    modification_time: 3840517353,
                    track_id: 1,
                    duration: 0,
                    layer: 0,
                    alternate_group: 0,
                    enabled: true,
                    volume: 1.into(),
                    matrix: Matrix {
                        a: 65536,
                        b: 0,
                        u: 0,
                        c: 0,
                        d: 65536,
                        v: 0,
                        x: 0,
                        y: 0,
                        w: 1073741824
                    },
                    width: 0.into(),
                    height: 0.into(),
                },
                edts: None,
                meta: None,
                mdia: Mdia {
                    mdhd: Mdhd {
                        creation_time: 3840517353,
                        modification_time: 3840517353,
                        timescale: 44100,
                        duration: 0,
                        language: "und".into(),
                    },
                    hdlr: Hdlr {
                        handler: b"soun".into(),
                        name: "SoundHandler".into(),
                    },
                    minf: Minf {
                        vmhd: None,
                        smhd: Some(Smhd { balance: 0.into() }),
                        dinf: Dinf {
                            dref: Dref {
                                urls: vec![Url {
                                    location: "".into()
                                }]
                            }
                        },
                        stbl: Stbl {
                            stsd: Stsd {
                                codecs: vec![Flac {
                                    audio: Audio {
                                        data_reference_index: 1,
                                        channel_count: 1,
                                        sample_size: 8,
                                        sample_rate: 44100.into(),
                                    },
                                    dfla: Dfla {
                                        blocks: vec![
                                            FlacMetadataBlock::StreamInfo {
                                                minimum_block_size: 4608,
                                                maximum_block_size: 4608,
                                                minimum_frame_size: 0u32
                                                    .try_into()
                                                    .expect("should fit in u24"),
                                                maximum_frame_size: 0u32
                                                    .try_into()
                                                    .expect("should fit in u24"),
                                                sample_rate: 44100,
                                                num_channels_minus_one: 0,
                                                bits_per_sample_minus_one: 7,
                                                number_of_interchannel_samples: 0,
                                                md5_checksum: vec![
                                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
                                                ]
                                            },
                                            FlacMetadataBlock::VorbisComment {
                                                vendor_string: "reference libFLAC 1.4.3 20230623"
                                                    .into(),
                                                comments: vec!["DESCRIPTION=audiotest wave".into()]
                                            },
                                        ],
                                    },
                                }
                                .into(),]
                            },
                            stts: Stts { entries: vec![] },
                            ctts: None,
                            stss: None,
                            stsc: Stsc { entries: vec![] },
                            stsz: Stsz::default(),
                            stco: Some(Stco { entries: [].into() }),
                            co64: None,
                            sbgp: vec![],
                            sgpd: vec![],
                            subs: vec![],
                            saio: vec![],
                            saiz: vec![],
                        }
                    }
                },
                udta: None
            }],
            udta: None
        }
    );

    // Make sure the FLAC atom encodes/decodes to the exact same content.
    let flac = &moov.trak[0].mdia.minf.stbl.stsd.codecs[0];
    flac.assert_encode_decode();

    let mut buf = Vec::new();
    ftyp.encode(&mut buf).expect("failed to encode ftyp");
    moov.encode(&mut buf).expect("failed to encode moov");
}
