mod mvex;
mod mvhd;
mod trak;
mod udta;

pub use mvex::*;
pub use mvhd::*;
pub use trak::*;
pub use udta::*;

use crate::*;

#[derive(Debug, Clone, PartialEq, Default)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Moov {
    pub mvhd: Mvhd,
    pub meta: Option<Meta>,
    pub mvex: Option<Mvex>,
    pub trak: Vec<Trak>,
    pub udta: Option<Udta>,
}

impl Atom for Moov {
    const KIND: FourCC = FourCC::new(b"moov");

    nested! {
        required: [ Mvhd ],
        optional: [ Meta, Mvex, Udta ],
        multiple: [ Trak ],
    }
}

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn test_meta() {
        const ENCODED: &[u8] = &[
            0x00, 0x00, 0x03, 0x3A, 0x6D, 0x6F, 0x6F, 0x76, 0x00, 0x00, 0x00, 0x6C, 0x6D, 0x76,
            0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xEF, 0xCF, 0xD6, 0xE0, 0xEF, 0xCF, 0xD6,
            0x00, 0x01, 0x5F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x8D, 0x6D, 0x65, 0x74, 0x61, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x68, 0x64, 0x6C, 0x72, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x49, 0x44, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x49, 0x44, 0x33, 0x32,
            0x00, 0x00, 0x00, 0x00, 0x15, 0xC7, 0x49, 0x44, 0x33, 0x04, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x49, 0x50, 0x52, 0x49, 0x56, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x68, 0x74,
            0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2E, 0x63,
            0x6F, 0x6D, 0x2F, 0x67, 0x6F, 0x6F, 0x67, 0x6C, 0x65, 0x2F, 0x73, 0x68, 0x61, 0x6B,
            0x61, 0x2D, 0x70, 0x61, 0x63, 0x6B, 0x61, 0x67, 0x65, 0x72, 0x00, 0x76, 0x32, 0x2E,
            0x36, 0x2E, 0x31, 0x2D, 0x36, 0x33, 0x34, 0x61, 0x66, 0x36, 0x35, 0x2D, 0x72, 0x65,
            0x6C, 0x65, 0x61, 0x73, 0x65, 0x00, 0x00, 0x02, 0x01, 0x74, 0x72, 0x61, 0x6B, 0x00,
            0x00, 0x00, 0x5C, 0x74, 0x6B, 0x68, 0x64, 0x00, 0x00, 0x00, 0x07, 0xE0, 0xEF, 0xCF,
            0xD6, 0xE0, 0xEF, 0xCF, 0xD6, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x07,
            0x80, 0x00, 0x00, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x01, 0x79, 0x6D, 0x64, 0x69,
            0x61, 0x00, 0x00, 0x00, 0x20, 0x6D, 0x64, 0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0xE0,
            0xEF, 0xCF, 0xD6, 0xE0, 0xEF, 0xCF, 0xD6, 0x00, 0x01, 0x5F, 0x90, 0x00, 0x00, 0x00,
            0x00, 0x55, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x68, 0x64, 0x6C, 0x72, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x69, 0x64, 0x65, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x69, 0x64, 0x65, 0x6F,
            0x48, 0x61, 0x6E, 0x64, 0x6C, 0x65, 0x72, 0x00, 0x00, 0x00, 0x01, 0x24, 0x6D, 0x69,
            0x6E, 0x66, 0x00, 0x00, 0x00, 0x24, 0x64, 0x69, 0x6E, 0x66, 0x00, 0x00, 0x00, 0x1C,
            0x64, 0x72, 0x65, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x0C, 0x75, 0x72, 0x6C, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4,
            0x73, 0x74, 0x62, 0x6C, 0x00, 0x00, 0x00, 0x98, 0x73, 0x74, 0x73, 0x64, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x88, 0x61, 0x76, 0x63, 0x31,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x04, 0x38,
            0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
            0x0A, 0x41, 0x56, 0x43, 0x20, 0x43, 0x6F, 0x64, 0x69, 0x6E, 0x67, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x32, 0x61, 0x76,
            0x63, 0x43, 0x01, 0x64, 0x00, 0x28, 0xFF, 0xE1, 0x00, 0x1A, 0x67, 0x64, 0x00, 0x28,
            0xAC, 0xD9, 0x40, 0x78, 0x02, 0x27, 0xE5, 0x84, 0x00, 0x00, 0x03, 0x00, 0x04, 0x00,
            0x00, 0x03, 0x00, 0xF0, 0x3C, 0x60, 0xC6, 0x58, 0x01, 0x00, 0x05, 0x68, 0xEB, 0xEC,
            0xB2, 0x2C, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x74, 0x73, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x73, 0x63, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x73, 0x74, 0x73, 0x7A,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x10, 0x73, 0x74, 0x63, 0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x14, 0x76, 0x6D, 0x68, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x65, 0x64, 0x74, 0x73,
            0x00, 0x00, 0x00, 0x1C, 0x65, 0x6C, 0x73, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x70, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x38, 0x6D, 0x76, 0x65, 0x78, 0x00, 0x00, 0x00, 0x10, 0x6D, 0x65,
            0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0x01, 0xB9, 0x31, 0x50, 0x00, 0x00, 0x00, 0x20,
            0x74, 0x72, 0x65, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x01, 0x00, 0x00, 0x0B, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        ];

        let decoded = Moov::decode(&mut &ENCODED[..]).unwrap();
        assert_eq!(
            decoded,
            Moov {
                mvhd: Mvhd {
                    creation_time: 3773812694,
                    modification_time: 3773812694,
                    timescale: 90000,
                    rate: 1.into(),
                    volume: 1.into(),
                    next_track_id: 2,
                    ..Default::default()
                },
                meta: Some(Meta {
                    hdlr: Hdlr {
                        handler: FourCC::new(b"ID32"),
                        name: "".into()
                    },
                    items: vec![Any::Unknown(
                        FourCC::new(b"ID32"),
                        vec![
                            0, 0, 0, 0, 21, 199, 73, 68, 51, 4, 0, 0, 0, 0, 0, 73, 80, 82, 73, 86,
                            0, 0, 0, 63, 0, 0, 104, 116, 116, 112, 115, 58, 47, 47, 103, 105, 116,
                            104, 117, 98, 46, 99, 111, 109, 47, 103, 111, 111, 103, 108, 101, 47,
                            115, 104, 97, 107, 97, 45, 112, 97, 99, 107, 97, 103, 101, 114, 0, 118,
                            50, 46, 54, 46, 49, 45, 54, 51, 52, 97, 102, 54, 53, 45, 114, 101, 108,
                            101, 97, 115, 101
                        ]
                    )]
                }),
                mvex: Some(Mvex {
                    mehd: Some(Mehd {
                        fragment_duration: 28914000
                    }),
                    trex: vec![Trex {
                        track_id: 1,
                        default_sample_description_index: 1,
                        default_sample_duration: 3000,
                        ..Default::default()
                    }]
                }),
                trak: vec![Trak {
                    tkhd: Tkhd {
                        creation_time: 3773812694,
                        modification_time: 3773812694,
                        track_id: 1,
                        enabled: true,
                        width: 1920.into(),
                        height: 1080.into(),
                        ..Default::default()
                    },
                    edts: Some(Edts {
                        elst: Some(Elst {
                            entries: vec![ElstEntry {
                                media_time: 6000,
                                media_rate: 1,
                                ..Default::default()
                            }]
                        })
                    }),
                    meta: None,
                    mdia: Mdia {
                        mdhd: Mdhd {
                            creation_time: 3773812694,
                            modification_time: 3773812694,
                            timescale: 90000,
                            duration: 0,
                            language: "und".to_string(),
                        },
                        hdlr: Hdlr {
                            handler: b"vide".into(),
                            name: "VideoHandler".to_string(),
                        },
                        minf: Minf {
                            vmhd: Some(Vmhd {
                                graphics_mode: 0,
                                op_color: RgbColor {
                                    red: 0,
                                    green: 0,
                                    blue: 0
                                }
                            }),
                            smhd: None,
                            dinf: Dinf {
                                dref: Dref {
                                    urls: vec![Url::default()]
                                }
                            },
                            stbl: Stbl {
                                stsd: Stsd {
                                    codecs: vec![Avc1 {
                                        visual: Visual {
                                            data_reference_index: 1,
                                            width: 1920,
                                            height: 1080,
                                            horizresolution: 72.into(),
                                            vertresolution: 72.into(),
                                            frame_count: 1,
                                            compressor: "\nAVC Coding".into(),
                                            depth: 24,
                                        },
                                        avcc: Avcc {
                                            configuration_version: 1,
                                            avc_profile_indication: 100,
                                            profile_compatibility: 0,
                                            avc_level_indication: 40,
                                            length_size: 4,
                                            sequence_parameter_sets: vec![vec![
                                                103, 100, 0, 40, 172, 217, 64, 120, 2, 39, 229,
                                                132, 0, 0, 3, 0, 4, 0, 0, 3, 0, 240, 60, 96, 198,
                                                88
                                            ]],
                                            picture_parameter_sets: vec![vec![
                                                104, 235, 236, 178, 44
                                            ]],
                                            ext: None,
                                        },
                                        btrt: None,
                                        colr: None,
                                        pasp: None,
                                        taic: None,
                                    }
                                    .into()],
                                },
                                stco: Some(Stco::default()),
                                ..Default::default()
                            }
                        }
                    },
                    udta: None
                }],
                udta: None,
            }
        )
    }
}
