// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, Checker};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "SpellingTextBufferAdapter")]
    pub struct TextBufferAdapter(Object<ffi::SpellingTextBufferAdapter, ffi::SpellingTextBufferAdapterClass>) @implements gio::ActionGroup;

    match fn {
        type_ => || ffi::spelling_text_buffer_adapter_get_type(),
    }
}

impl TextBufferAdapter {
    #[doc(alias = "spelling_text_buffer_adapter_new")]
    pub fn new(buffer: &impl IsA<gtk_source::Buffer>, checker: &Checker) -> TextBufferAdapter {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::spelling_text_buffer_adapter_new(
                buffer.as_ref().to_glib_none().0,
                checker.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextBufferAdapter`] objects.
    ///
    /// This method returns an instance of [`TextBufferAdapterBuilder`](crate::builders::TextBufferAdapterBuilder) which can be used to create [`TextBufferAdapter`] objects.
    pub fn builder() -> TextBufferAdapterBuilder {
        TextBufferAdapterBuilder::new()
    }

    #[doc(alias = "spelling_text_buffer_adapter_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> Option<gtk_source::Buffer> {
        unsafe {
            from_glib_none(ffi::spelling_text_buffer_adapter_get_buffer(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_get_checker")]
    #[doc(alias = "get_checker")]
    pub fn checker(&self) -> Option<Checker> {
        unsafe {
            from_glib_none(ffi::spelling_text_buffer_adapter_get_checker(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_get_enabled")]
    #[doc(alias = "get_enabled")]
    #[doc(alias = "enabled")]
    pub fn is_enabled(&self) -> bool {
        unsafe {
            from_glib(ffi::spelling_text_buffer_adapter_get_enabled(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_get_language")]
    #[doc(alias = "get_language")]
    pub fn language(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::spelling_text_buffer_adapter_get_language(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_get_menu_model")]
    #[doc(alias = "get_menu_model")]
    pub fn menu_model(&self) -> gio::MenuModel {
        unsafe {
            from_glib_none(ffi::spelling_text_buffer_adapter_get_menu_model(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_get_tag")]
    #[doc(alias = "get_tag")]
    pub fn tag(&self) -> Option<gtk::TextTag> {
        unsafe {
            from_glib_none(ffi::spelling_text_buffer_adapter_get_tag(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_invalidate_all")]
    pub fn invalidate_all(&self) {
        unsafe {
            ffi::spelling_text_buffer_adapter_invalidate_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_set_checker")]
    #[doc(alias = "checker")]
    pub fn set_checker(&self, checker: &Checker) {
        unsafe {
            ffi::spelling_text_buffer_adapter_set_checker(
                self.to_glib_none().0,
                checker.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_set_enabled")]
    #[doc(alias = "enabled")]
    pub fn set_enabled(&self, enabled: bool) {
        unsafe {
            ffi::spelling_text_buffer_adapter_set_enabled(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "spelling_text_buffer_adapter_set_language")]
    #[doc(alias = "language")]
    pub fn set_language(&self, language: &str) {
        unsafe {
            ffi::spelling_text_buffer_adapter_set_language(
                self.to_glib_none().0,
                language.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "checker")]
    pub fn connect_checker_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_checker_trampoline<F: Fn(&TextBufferAdapter) + 'static>(
            this: *mut ffi::SpellingTextBufferAdapter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::checker\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_checker_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enabled")]
    pub fn connect_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enabled_trampoline<F: Fn(&TextBufferAdapter) + 'static>(
            this: *mut ffi::SpellingTextBufferAdapter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enabled\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enabled_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "language")]
    pub fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<F: Fn(&TextBufferAdapter) + 'static>(
            this: *mut ffi::SpellingTextBufferAdapter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_language_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for TextBufferAdapter {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextBufferAdapter`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextBufferAdapterBuilder {
    builder: glib::object::ObjectBuilder<'static, TextBufferAdapter>,
}

impl TextBufferAdapterBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<gtk_source::Buffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn checker(self, checker: &Checker) -> Self {
        Self {
            builder: self.builder.property("checker", checker.clone()),
        }
    }

    pub fn enabled(self, enabled: bool) -> Self {
        Self {
            builder: self.builder.property("enabled", enabled),
        }
    }

    pub fn language(self, language: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("language", language.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextBufferAdapter`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TextBufferAdapter {
        self.builder.build()
    }
}
