// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, Provider};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "SpellingChecker")]
    pub struct Checker(Object<ffi::SpellingChecker, ffi::SpellingCheckerClass>);

    match fn {
        type_ => || ffi::spelling_checker_get_type(),
    }
}

impl Checker {
    #[doc(alias = "spelling_checker_new")]
    pub fn new(provider: &Provider, language: &str) -> Checker {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::spelling_checker_new(
                provider.to_glib_none().0,
                language.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_checker_add_word")]
    pub fn add_word(&self, word: &str) {
        unsafe {
            ffi::spelling_checker_add_word(self.to_glib_none().0, word.to_glib_none().0);
        }
    }

    #[doc(alias = "spelling_checker_check_word")]
    pub fn check_word(&self, word: &str) -> bool {
        let word_len = word.len() as _;
        unsafe {
            from_glib(ffi::spelling_checker_check_word(
                self.to_glib_none().0,
                word.to_glib_none().0,
                word_len,
            ))
        }
    }

    #[doc(alias = "spelling_checker_get_extra_word_chars")]
    #[doc(alias = "get_extra_word_chars")]
    pub fn extra_word_chars(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::spelling_checker_get_extra_word_chars(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_checker_get_language")]
    #[doc(alias = "get_language")]
    pub fn language(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::spelling_checker_get_language(self.to_glib_none().0)) }
    }

    #[doc(alias = "spelling_checker_get_provider")]
    #[doc(alias = "get_provider")]
    pub fn provider(&self) -> Provider {
        unsafe { from_glib_none(ffi::spelling_checker_get_provider(self.to_glib_none().0)) }
    }

    #[doc(alias = "spelling_checker_ignore_word")]
    pub fn ignore_word(&self, word: &str) {
        unsafe {
            ffi::spelling_checker_ignore_word(self.to_glib_none().0, word.to_glib_none().0);
        }
    }

    #[doc(alias = "spelling_checker_list_corrections")]
    pub fn list_corrections(&self, word: &str) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::spelling_checker_list_corrections(
                self.to_glib_none().0,
                word.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spelling_checker_set_language")]
    #[doc(alias = "language")]
    pub fn set_language(&self, language: &str) {
        unsafe {
            ffi::spelling_checker_set_language(self.to_glib_none().0, language.to_glib_none().0);
        }
    }

    #[doc(alias = "spelling_checker_get_default")]
    #[doc(alias = "get_default")]
    #[allow(clippy::should_implement_trait)]
    pub fn default() -> Checker {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::spelling_checker_get_default()) }
    }

    #[doc(alias = "language")]
    pub fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<F: Fn(&Checker) + 'static>(
            this: *mut ffi::SpellingChecker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_language_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
