// See <https://github.com/apache/pdfbox/blob/4438b8fdc67a3a9ebfb194595d0e81f88b708a37/pdfbox/src/main/java/org/apache/pdfbox/pdmodel/font/encoding/WinAnsiEncoding.java>
use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    WIN_ANSI
        .get(&code)
        .or(if code > 40 { Some(&"bullet") } else { None })
        .copied()
}

static WIN_ANSI: phf::Map<u8, &'static str> = phf_map! {
        65u8 => "A",
    198u8 => "AE",
    193u8 => "Aacute",
    194u8 => "Acircumflex",
    196u8 => "Adieresis",
    192u8 => "Agrave",
    197u8 => "Aring",
    195u8 => "Atilde",
    66u8 => "B",
    67u8 => "C",
    199u8 => "Ccedilla",
    68u8 => "D",
    69u8 => "E",
    201u8 => "Eacute",
    202u8 => "Ecircumflex",
    203u8 => "Edieresis",
    200u8 => "Egrave",
    208u8 => "Eth",
    128u8 => "Euro",
    70u8 => "F",
    71u8 => "G",
    72u8 => "H",
    73u8 => "I",
    205u8 => "Iacute",
    206u8 => "Icircumflex",
    207u8 => "Idieresis",
    204u8 => "Igrave",
    74u8 => "J",
    75u8 => "K",
    76u8 => "L",
    77u8 => "M",
    78u8 => "N",
    209u8 => "Ntilde",
    79u8 => "O",
    140u8 => "OE",
    211u8 => "Oacute",
    212u8 => "Ocircumflex",
    214u8 => "Odieresis",
    210u8 => "Ograve",
    216u8 => "Oslash",
    213u8 => "Otilde",
    80u8 => "P",
    81u8 => "Q",
    82u8 => "R",
    83u8 => "S",
    138u8 => "Scaron",
    84u8 => "T",
    222u8 => "Thorn",
    85u8 => "U",
    218u8 => "Uacute",
    219u8 => "Ucircumflex",
    220u8 => "Udieresis",
    217u8 => "Ugrave",
    86u8 => "V",
    87u8 => "W",
    88u8 => "X",
    89u8 => "Y",
    221u8 => "Yacute",
    159u8 => "Ydieresis",
    90u8 => "Z",
    142u8 => "Zcaron",
    97u8 => "a",
    225u8 => "aacute",
    226u8 => "acircumflex",
    180u8 => "acute",
    228u8 => "adieresis",
    230u8 => "ae",
    224u8 => "agrave",
    38u8 => "ampersand",
    229u8 => "aring",
    94u8 => "asciicircum",
    126u8 => "asciitilde",
    42u8 => "asterisk",
    64u8 => "at",
    227u8 => "atilde",
    98u8 => "b",
    92u8 => "backslash",
    124u8 => "bar",
    123u8 => "braceleft",
    125u8 => "braceright",
    91u8 => "bracketleft",
    93u8 => "bracketright",
    166u8 => "brokenbar",
    149u8 => "bullet",
    99u8 => "c",
    231u8 => "ccedilla",
    184u8 => "cedilla",
    162u8 => "cent",
    136u8 => "circumflex",
    58u8 => "colon",
    44u8 => "comma",
    169u8 => "copyright",
    164u8 => "currency",
    100u8 => "d",
    134u8 => "dagger",
    135u8 => "daggerdbl",
    176u8 => "degree",
    168u8 => "dieresis",
    247u8 => "divide",
    36u8 => "dollar",
    101u8 => "e",
    233u8 => "eacute",
    234u8 => "ecircumflex",
    235u8 => "edieresis",
    232u8 => "egrave",
    56u8 => "eight",
    133u8 => "ellipsis",
    151u8 => "emdash",
    150u8 => "endash",
    61u8 => "equal",
    240u8 => "eth",
    33u8 => "exclam",
    161u8 => "exclamdown",
    102u8 => "f",
    53u8 => "five",
    131u8 => "florin",
    52u8 => "four",
    103u8 => "g",
    223u8 => "germandbls",
    96u8 => "grave",
    62u8 => "greater",
    171u8 => "guillemotleft",
    187u8 => "guillemotright",
    139u8 => "guilsinglleft",
    155u8 => "guilsinglright",
    104u8 => "h",
    45u8 => "hyphen",
    105u8 => "i",
    237u8 => "iacute",
    238u8 => "icircumflex",
    239u8 => "idieresis",
    236u8 => "igrave",
    106u8 => "j",
    107u8 => "k",
    108u8 => "l",
    60u8 => "less",
    172u8 => "logicalnot",
    109u8 => "m",
    175u8 => "macron",
    181u8 => "mu",
    215u8 => "multiply",
    110u8 => "n",
    57u8 => "nine",
    241u8 => "ntilde",
    35u8 => "numbersign",
    111u8 => "o",
    243u8 => "oacute",
    244u8 => "ocircumflex",
    246u8 => "odieresis",
    156u8 => "oe",
    242u8 => "ograve",
    49u8 => "one",
    189u8 => "onehalf",
    188u8 => "onequarter",
    185u8 => "onesuperior",
    170u8 => "ordfeminine",
    186u8 => "ordmasculine",
    248u8 => "oslash",
    245u8 => "otilde",
    112u8 => "p",
    182u8 => "paragraph",
    40u8 => "parenleft",
    41u8 => "parenright",
    37u8 => "percent",
    46u8 => "period",
    183u8 => "periodcentered",
    137u8 => "perthousand",
    43u8 => "plus",
    177u8 => "plusminus",
    113u8 => "q",
    63u8 => "question",
    191u8 => "questiondown",
    34u8 => "quotedbl",
    132u8 => "quotedblbase",
    147u8 => "quotedblleft",
    148u8 => "quotedblright",
    145u8 => "quoteleft",
    146u8 => "quoteright",
    130u8 => "quotesinglbase",
    39u8 => "quotesingle",
    114u8 => "r",
    174u8 => "registered",
    115u8 => "s",
    154u8 => "scaron",
    167u8 => "section",
    59u8 => "semicolon",
    55u8 => "seven",
    54u8 => "six",
    47u8 => "slash",
    32u8 => "space",
    163u8 => "sterling",
    116u8 => "t",
    254u8 => "thorn",
    51u8 => "three",
    190u8 => "threequarters",
    179u8 => "threesuperior",
    152u8 => "tilde",
    153u8 => "trademark",
    50u8 => "two",
    178u8 => "twosuperior",
    117u8 => "u",
    250u8 => "uacute",
    251u8 => "ucircumflex",
    252u8 => "udieresis",
    249u8 => "ugrave",
    95u8 => "underscore",
    118u8 => "v",
    119u8 => "w",
    120u8 => "x",
    121u8 => "y",
    253u8 => "yacute",
    255u8 => "ydieresis",
    165u8 => "yen",
    122u8 => "z",
    158u8 => "zcaron",
    48u8 => "zero",
    160u8 => "nbspace",
    173u8 => "sfthyphen",
};
