use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    SYMBOL.get(&code).copied()
}

static SYMBOL: phf::Map<u8, &'static str> = phf_map! {
    32u8 => "space",
    33u8 => "exclam",
    34u8 => "universal",
    35u8 => "numbersign",
    36u8 => "existential",
    37u8 => "percent",
    38u8 => "ampersand",
    39u8 => "suchthat",
    40u8 => "parenleft",
    41u8 => "parenright",
    42u8 => "asteriskmath",
    43u8 => "plus",
    44u8 => "comma",
    45u8 => "minus",
    46u8 => "period",
    47u8 => "slash",
    48u8 => "zero",
    49u8 => "one",
    50u8 => "two",
    51u8 => "three",
    52u8 => "four",
    53u8 => "five",
    54u8 => "six",
    55u8 => "seven",
    56u8 => "eight",
    57u8 => "nine",
    58u8 => "colon",
    59u8 => "semicolon",
    60u8 => "less",
    61u8 => "equal",
    62u8 => "greater",
    63u8 => "question",
    64u8 => "congruent",
    65u8 => "Alpha",
    66u8 => "Beta",
    67u8 => "Chi",
    68u8 => "Delta",
    69u8 => "Epsilon",
    70u8 => "Phi",
    71u8 => "Gamma",
    72u8 => "Eta",
    73u8 => "Iota",
    74u8 => "theta1",
    75u8 => "Kappa",
    76u8 => "Lambda",
    77u8 => "Mu",
    78u8 => "Nu",
    79u8 => "Omicron",
    80u8 => "Pi",
    81u8 => "Theta",
    82u8 => "Rho",
    83u8 => "Sigma",
    84u8 => "Tau",
    85u8 => "Upsilon",
    86u8 => "sigma1",
    87u8 => "Omega",
    88u8 => "Xi",
    89u8 => "Psi",
    90u8 => "Zeta",
    91u8 => "bracketleft",
    92u8 => "therefore",
    93u8 => "bracketright",
    94u8 => "perpendicular",
    95u8 => "underscore",
    96u8 => "radicalex",
    97u8 => "alpha",
    98u8 => "beta",
    99u8 => "chi",
    100u8 => "delta",
    101u8 => "epsilon",
    102u8 => "phi",
    103u8 => "gamma",
    104u8 => "eta",
    105u8 => "iota",
    106u8 => "phi1",
    107u8 => "kappa",
    108u8 => "lambda",
    109u8 => "mu",
    110u8 => "nu",
    111u8 => "omicron",
    112u8 => "pi",
    113u8 => "theta",
    114u8 => "rho",
    115u8 => "sigma",
    116u8 => "tau",
    117u8 => "upsilon",
    118u8 => "omega1",
    119u8 => "omega",
    120u8 => "xi",
    121u8 => "psi",
    122u8 => "zeta",
    123u8 => "braceleft",
    124u8 => "bar",
    125u8 => "braceright",
    126u8 => "similar",
    160u8 => "Euro",
    161u8 => "Upsilon1",
    162u8 => "minute",
    163u8 => "lessequal",
    164u8 => "fraction",
    165u8 => "infinity",
    166u8 => "florin",
    167u8 => "club",
    168u8 => "diamond",
    169u8 => "heart",
    170u8 => "spade",
    171u8 => "arrowboth",
    172u8 => "arrowleft",
    173u8 => "arrowup",
    174u8 => "arrowright",
    175u8 => "arrowdown",
    176u8 => "degree",
    177u8 => "plusminus",
    178u8 => "second",
    179u8 => "greaterequal",
    180u8 => "multiply",
    181u8 => "proportional",
    182u8 => "partialdiff",
    183u8 => "bullet",
    184u8 => "divide",
    185u8 => "notequal",
    186u8 => "equivalence",
    187u8 => "approxequal",
    188u8 => "ellipsis",
    189u8 => "arrowvertex",
    190u8 => "arrowhorizex",
    191u8 => "carriagereturn",
    192u8 => "aleph",
    193u8 => "Ifraktur",
    194u8 => "Rfraktur",
    195u8 => "weierstrass",
    196u8 => "circlemultiply",
    197u8 => "circleplus",
    198u8 => "emptyset",
    199u8 => "intersection",
    200u8 => "union",
    201u8 => "propersuperset",
    202u8 => "reflexsuperset",
    203u8 => "notsubset",
    204u8 => "propersubset",
    205u8 => "reflexsubset",
    206u8 => "element",
    207u8 => "notelement",
    208u8 => "angle",
    209u8 => "gradient",
    210u8 => "registerserif",
    211u8 => "copyrightserif",
    212u8 => "trademarkserif",
    213u8 => "product",
    214u8 => "radical",
    215u8 => "dotmath",
    216u8 => "logicalnot",
    217u8 => "logicaland",
    218u8 => "logicalor",
    219u8 => "arrowdblboth",
    220u8 => "arrowdblleft",
    221u8 => "arrowdblup",
    222u8 => "arrowdblright",
    223u8 => "arrowdbldown",
    224u8 => "lozenge",
    225u8 => "angleleft",
    226u8 => "registersans",
    227u8 => "copyrightsans",
    228u8 => "trademarksans",
    229u8 => "summation",
    230u8 => "parenlefttp",
    231u8 => "parenleftex",
    232u8 => "parenleftbt",
    233u8 => "bracketlefttp",
    234u8 => "bracketleftex",
    235u8 => "bracketleftbt",
    236u8 => "bracelefttp",
    237u8 => "braceleftmid",
    238u8 => "braceleftbt",
    239u8 => "braceex",
    241u8 => "angleright",
    242u8 => "integral",
    243u8 => "integraltp",
    244u8 => "integralex",
    245u8 => "integralbt",
    246u8 => "parenrighttp",
    247u8 => "parenrightex",
    248u8 => "parenrightbt",
    249u8 => "bracketrighttp",
    250u8 => "bracketrightex",
    251u8 => "bracketrightbt",
    252u8 => "bracerighttp",
    253u8 => "bracerightmid",
    254u8 => "bracerightbt",
};
