use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    STANDARD.get(&code).copied()
}

static STANDARD: phf::Map<u8, &'static str> = phf_map! {
    32u8 => "space",
    33u8 => "exclam",
    34u8 => "quotedbl",
    35u8 => "numbersign",
    36u8 => "dollar",
    37u8 => "percent",
    38u8 => "ampersand",
    39u8 => "quoteright",
    40u8 => "parenleft",
    41u8 => "parenright",
    42u8 => "asterisk",
    43u8 => "plus",
    44u8 => "comma",
    45u8 => "hyphen",
    46u8 => "period",
    47u8 => "slash",
    48u8 => "zero",
    49u8 => "one",
    50u8 => "two",
    51u8 => "three",
    52u8 => "four",
    53u8 => "five",
    54u8 => "six",
    55u8 => "seven",
    56u8 => "eight",
    57u8 => "nine",
    58u8 => "colon",
    59u8 => "semicolon",
    60u8 => "less",
    61u8 => "equal",
    62u8 => "greater",
    63u8 => "question",
    64u8 => "at",
    65u8 => "A",
    66u8 => "B",
    67u8 => "C",
    68u8 => "D",
    69u8 => "E",
    70u8 => "F",
    71u8 => "G",
    72u8 => "H",
    73u8 => "I",
    74u8 => "J",
    75u8 => "K",
    76u8 => "L",
    77u8 => "M",
    78u8 => "N",
    79u8 => "O",
    80u8 => "P",
    81u8 => "Q",
    82u8 => "R",
    83u8 => "S",
    84u8 => "T",
    85u8 => "U",
    86u8 => "V",
    87u8 => "W",
    88u8 => "X",
    89u8 => "Y",
    90u8 => "Z",
    91u8 => "bracketleft",
    92u8 => "backslash",
    93u8 => "bracketright",
    94u8 => "asciicircum",
    95u8 => "underscore",
    96u8 => "quoteleft",
    97u8 => "a",
    98u8 => "b",
    99u8 => "c",
    100u8 => "d",
    101u8 => "e",
    102u8 => "f",
    103u8 => "g",
    104u8 => "h",
    105u8 => "i",
    106u8 => "j",
    107u8 => "k",
    108u8 => "l",
    109u8 => "m",
    110u8 => "n",
    111u8 => "o",
    112u8 => "p",
    113u8 => "q",
    114u8 => "r",
    115u8 => "s",
    116u8 => "t",
    117u8 => "u",
    118u8 => "v",
    119u8 => "w",
    120u8 => "x",
    121u8 => "y",
    122u8 => "z",
    123u8 => "braceleft",
    124u8 => "bar",
    125u8 => "braceright",
    126u8 => "asciitilde",
    161u8 => "exclamdown",
    162u8 => "cent",
    163u8 => "sterling",
    164u8 => "fraction",
    165u8 => "yen",
    166u8 => "florin",
    167u8 => "section",
    168u8 => "currency",
    169u8 => "quotesingle",
    170u8 => "quotedblleft",
    171u8 => "guillemotleft",
    172u8 => "guilsinglleft",
    173u8 => "guilsinglright",
    174u8 => "fi",
    175u8 => "fl",
    177u8 => "endash",
    178u8 => "dagger",
    179u8 => "daggerdbl",
    180u8 => "periodcentered",
    182u8 => "paragraph",
    183u8 => "bullet",
    184u8 => "quotesinglbase",
    185u8 => "quotedblbase",
    186u8 => "quotedblright",
    187u8 => "guillemotright",
    188u8 => "ellipsis",
    189u8 => "perthousand",
    191u8 => "questiondown",
    193u8 => "grave",
    194u8 => "acute",
    195u8 => "circumflex",
    196u8 => "tilde",
    197u8 => "macron",
    198u8 => "breve",
    199u8 => "dotaccent",
    200u8 => "dieresis",
    202u8 => "ring",
    203u8 => "cedilla",
    205u8 => "hungarumlaut",
    206u8 => "ogonek",
    207u8 => "caron",
    208u8 => "emdash",
    225u8 => "AE",
    227u8 => "ordfeminine",
    232u8 => "Lslash",
    233u8 => "Oslash",
    234u8 => "OE",
    235u8 => "ordmasculine",
    241u8 => "ae",
    245u8 => "dotlessi",
    248u8 => "lslash",
    249u8 => "oslash",
    250u8 => "oe",
    251u8 => "germandbls",
};
