| Supported | Rust                             | Fastcall | V8          | Notes                                                                                                                                                                                            |
| --------- | -------------------------------- | -------- | ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| X         | bool                             | X        | Bool        |                                                                                                                                                                                                  |
| X         | i8                               | X        | Int32       |                                                                                                                                                                                                  |
| X         | u8                               | X        | Uint32      |                                                                                                                                                                                                  |
| X         | i16                              | X        | Int32       |                                                                                                                                                                                                  |
| X         | u16                              | X        | Uint32      |                                                                                                                                                                                                  |
| X         | i32                              | X        | Int32       |                                                                                                                                                                                                  |
| X         | u32                              | X        | Uint32      |                                                                                                                                                                                                  |
| X         | #[smi] ResourceId                | X        | Int32       | SMI is internally represented as a signed integer, but unsigned `#[smi]` types will be bit-converted to unsigned values for the Rust call. JavaScript code will continue to see signed integers. |
| X         | #[bigint] i64                    | X        | BigInt      |                                                                                                                                                                                                  |
| X         | #[bigint] u64                    | X        | BigInt      |                                                                                                                                                                                                  |
| X         | #[bigint] isize                  | X        | BigInt      |                                                                                                                                                                                                  |
| X         | #[bigint] usize                  | X        | BigInt      |                                                                                                                                                                                                  |
| X         | #[number] i64                    | X        | Number      | Result must fit within `Number.MIN_SAFE_INTEGER` and `Number.MAX_SAFE_INTEGER`                                                                                                                   |
| X         | #[number] u64                    | X        | Number      | Result must fit within `Number.MIN_SAFE_INTEGER` and `Number.MAX_SAFE_INTEGER`                                                                                                                   |
| X         | #[number] isize                  | X        | Number      | Result must fit within `Number.MIN_SAFE_INTEGER` and `Number.MAX_SAFE_INTEGER`                                                                                                                   |
| X         | #[number] usize                  | X        | Number      | Result must fit within `Number.MIN_SAFE_INTEGER` and `Number.MAX_SAFE_INTEGER`                                                                                                                   |
| X         | f32                              | X        | Number      |                                                                                                                                                                                                  |
| X         | f64                              | X        | Number      |                                                                                                                                                                                                  |
| X         | #[string] String                 |          | String      |                                                                                                                                                                                                  |
| X         | #[string] &str                   |          | String      |                                                                                                                                                                                                  |
| X         | #[string] Cow<str>               |          | String      |                                                                                                                                                                                                  |
| X         | #[string(onebyte)] Cow<[u8]>     |          | String      |                                                                                                                                                                                                  |
| X         | #[arraybuffer] V8Slice<u8>       |          | ArrayBuffer |                                                                                                                                                                                                  |
| X         | #[arraybuffer] Vec<u8>           |          | ArrayBuffer |                                                                                                                                                                                                  |
| X         | #[arraybuffer] Box<[u8]>         |          | ArrayBuffer |                                                                                                                                                                                                  |
| X         | #[arraybuffer] bytes::BytesMut   |          | ArrayBuffer |                                                                                                                                                                                                  |
| X         | #[buffer] V8Slice<u8>            |          | Uint8Array  |                                                                                                                                                                                                  |
| X         | #[buffer] Vec<u8>                |          | Uint8Array  |                                                                                                                                                                                                  |
| X         | #[buffer] Box<[u8]>              |          | Uint8Array  |                                                                                                                                                                                                  |
| X         | #[buffer] bytes::BytesMut        |          | Uint8Array  |                                                                                                                                                                                                  |
| X         | #[buffer] V8Slice<u32>           |          | Uint32Array |                                                                                                                                                                                                  |
|           | #[buffer] Vec<u32>               |          | Uint32Array |                                                                                                                                                                                                  |
|           | #[buffer] Box<[u32]>             |          | Uint32Array |                                                                                                                                                                                                  |
| X         | *const std::ffi::c_void          | X        | External    |                                                                                                                                                                                                  |
| X         | *mut std::ffi::c_void            | X        | External    |                                                                                                                                                                                                  |
| X         | v8::Local<v8::Value>             |          | any         |                                                                                                                                                                                                  |
| X         | v8::Local<v8::**V8**>            |          | **V8**      |                                                                                                                                                                                                  |
| X         | #[global] v8::Global<v8::Value>  |          | any         |                                                                                                                                                                                                  |
| X         | #[global] v8::Global<v8::**V8**> |          | **V8**      |                                                                                                                                                                                                  |
| X         | #[serde] SerdeType               |          | any         |                                                                                                                                                                                                  |
| X         | #[serde] (Tuple, Tuple)          |          | any         |                                                                                                                                                                                                  |
