| Supported | Rust                              | Fastcall | V8                                                  | Notes                                                                                                                                                                                                          |
| --------- | --------------------------------- | -------- | --------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| X         | bool                              | X        | Bool                                                |                                                                                                                                                                                                                |
| X         | i8                                | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | u8                                | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | i16                               | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | u16                               | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | i32                               | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | u32                               | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | #[smi] ResourceId                 | X        | Uint32, Int32, Number, BigInt                       | SMI is internally represented as a signed integer, but unsigned `#[smi]` types will be bit-converted to unsigned values for the Rust call. JavaScript code will continue to see signed integers.               |
| X         | #[bigint] i64                     | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | #[bigint] u64                     | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | #[bigint] isize                   | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | #[bigint] usize                   | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | f32                               | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | f64                               | X        | Uint32, Int32, Number, BigInt                       |                                                                                                                                                                                                                |
| X         | #[string] String                  | X        | String                                              | Fastcall available only if string is Latin-1. Will always create an allocated, UTF-8 copy of the String data.                                                                                                  |
| X         | #[string] &str                    | X        | String                                              | Fastcall available only if string is Latin-1. Will create an owned `String` copy of the String data if it doesn't fit on the stack. Will never allocate in a fastcall, but will copy Latin-1 -> UTF-8.         |
| X         | #[string] Cow<str>                | X        | String                                              | Fastcall available only if string is Latin-1. Will create a `Cow::Owned` copy of the String data if it doesn't fit on the stack. Will always be `Cow::Borrowed` in a fastcall, but will copy Latin-1 -> UTF-8. |
| X         | #[string(onebyte)] Cow<[u8]>      | X        | String                                              | Fastest `String`-type method. If the string is not Latin-1, will throw a TypeError.                                                                                                                            |
| X         | &v8::Value                        | X        | any                                                 |                                                                                                                                                                                                                |
| X         | &v8::**V8**                       | X        | **V8**                                              |                                                                                                                                                                                                                |
| X         | v8::Local<v8::Value>              | X        | any                                                 |                                                                                                                                                                                                                |
| X         | v8::Local<v8::**V8**>             | X        | **V8**                                              |                                                                                                                                                                                                                |
| X         | #[global] v8::Global<v8::Value>   |          | any                                                 | ⚠️ Slower than `v8::Local`.                                                                                                                                                                                     |
| X         | #[global] v8::Global<v8::**V8**>  |          | **V8**                                              | ⚠️ Slower than `v8::Local`.                                                                                                                                                                                     |
| X         | #[serde] SerdeType                |          | any                                                 | ⚠️ May be slow.                                                                                                                                                                                                 |
| X         | #[serde] (Tuple, Tuple)           |          | any                                                 | ⚠️ May be slow.                                                                                                                                                                                                 |
|           | #[anybuffer] &mut [u8]            | X        | ArrayBuffer, ArrayBufferView (resizable=true,false) | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
|           | #[anybuffer] &[u8]                | X        | ArrayBuffer, ArrayBufferView (resizable=true,false) | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
|           | #[anybuffer] *mut u8              | X        | ArrayBuffer, ArrayBufferView (resizable=true,false) | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly. Because of how V8 treats empty arrays in fastcalls, they will always be passed as null.                                                |
|           | #[anybuffer] *const u8            | X        | ArrayBuffer, ArrayBufferView (resizable=true,false) | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly. Because of how V8 treats empty arrays in fastcalls, they will always be passed as null.                                                |
| X         | #[arraybuffer] &mut [u8]          | X        | ArrayBuffer (resizable=true,false)                  | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
| X         | #[arraybuffer] &[u8]              | X        | ArrayBuffer (resizable=true,false)                  | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
| X         | #[arraybuffer] *mut u8            | X        | ArrayBuffer (resizable=true,false)                  | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly. Because of how V8 treats empty arrays in fastcalls, they will always be passed as null.                                                |
| X         | #[arraybuffer] *const u8          | X        | ArrayBuffer (resizable=true,false)                  | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly. Because of how V8 treats empty arrays in fastcalls, they will always be passed as null.                                                |
| X         | #[arraybuffer(copy)] Vec<u8>      | X        | ArrayBuffer (resizable=true,false)                  | Safe, but forces a copy.                                                                                                                                                                                       |
| X         | #[arraybuffer(copy)] Box<[u8]>    | X        | ArrayBuffer (resizable=true,false)                  | Safe, but forces a copy.                                                                                                                                                                                       |
| X         | #[arraybuffer(copy)] bytes::Bytes | X        | ArrayBuffer (resizable=true,false)                  | Safe, but forces a copy.                                                                                                                                                                                       |
|           | #[buffer] &mut [u8]               | X        | UInt8Array (resizable=true,false)                   | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
|           | #[buffer] &[u8]                   | X        | UInt8Array (resizable=true,false)                   | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
|           | #[buffer] *mut u8                 | X        | UInt8Array (resizable=true,false)                   | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly. Because of how V8 treats empty arrays in fastcalls, they will always be passed as null.                                                |
|           | #[buffer] *const u8               | X        | UInt8Array (resizable=true,false)                   | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly. Because of how V8 treats empty arrays in fastcalls, they will always be passed as null.                                                |
| X         | #[buffer(copy)] Vec<u8>           | X        | UInt8Array (resizable=true,false)                   | Safe, but forces a copy.                                                                                                                                                                                       |
| X         | #[buffer(copy)] Box<[u8]>         | X        | UInt8Array (resizable=true,false)                   | Safe, but forces a copy.                                                                                                                                                                                       |
| X         | #[buffer(copy)] bytes::Bytes      | X        | UInt8Array (resizable=true,false)                   | Safe, but forces a copy.                                                                                                                                                                                       |
| X         | #[buffer] &mut [u32]              | X        | UInt32Array (resizable=true,false)                  | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
| X         | #[buffer] &[u32]                  | X        | UInt32Array (resizable=true,false)                  | ⚠️ JS may modify the contents of the slice if V8 is called re-entrantly.                                                                                                                                        |
| X         | #[buffer(copy)] Vec<u32>          | X        | UInt32Array (resizable=true,false)                  | Safe, but forces a copy.                                                                                                                                                                                       |
| X         | #[buffer(copy)] Box<[u32]>        | X        | UInt32Array (resizable=true,false)                  | Safe, but forces a copy.                                                                                                                                                                                       |
|           | #[buffer] V8Slice                 | X        | ArrayBufferView (resizable=false)                   | ⚠️ JS may modify the contents of slices obtained from buffer.                                                                                                                                                   |
|           | #[buffer(detach)] V8Slice         | X        | ArrayBufferView (resizable=true,false)              | Safe.                                                                                                                                                                                                          |
|           | #[buffer] V8ResizableSlice        | X        | ArrayBufferView (resizable=true)                    | ⚠️ JS may modify the contents of slices obtained from buffer.                                                                                                                                                   |
|           | #[buffer] JsBuffer                | X        | ArrayBufferView (resizable=false)                   | ⚠️ JS may modify the contents of slices obtained from buffer.                                                                                                                                                   |
| X         | #[buffer(detach)] JsBuffer        |          | ArrayBufferView (resizable=true,false)              | Safe.                                                                                                                                                                                                          |
|           | #[buffer(unsafe)] bytes::Bytes    | X        | ArrayBufferView (resizable=false)                   | ⚠️ JS may modify the contents of the buffer.                                                                                                                                                                    |
|           | #[buffer(detach)] bytes::Bytes    | X        | ArrayBufferView (resizable=true,false)              | Safe.                                                                                                                                                                                                          |
| X         | *const std::ffi::c_void           | X        | External                                            |                                                                                                                                                                                                                |
| X         | *mut std::ffi::c_void             | X        | External                                            |                                                                                                                                                                                                                |
| X         | &OpState                          | X        |                                                     |                                                                                                                                                                                                                |
| X         | &mut OpState                      | X        |                                                     |                                                                                                                                                                                                                |
| X         | Rc<RefCell<OpState>>              | X        |                                                     |                                                                                                                                                                                                                |
| X         | &JsRuntimeState                   | X        |                                                     | Only usable in `deno_core`.                                                                                                                                                                                    |
