// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specify details to configure the streaming session, including channel definitions, encryption settings, post-stream analytics settings, resource access role ARN and vocabulary settings.</p>
/// <p>Whether you are starting a new session or resuming an existing session, your first event must be a <code>MedicalScribeConfigurationEvent</code>. If you are resuming a session, then this event must have the same configurations that you provided to start the session.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalScribeConfigurationEvent {
    /// <p>Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names are case-sensitive.</p>
    pub vocabulary_name: ::std::option::Option<::std::string::String>,
    /// <p>Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom vocabulary filter names are case-sensitive.</p>
    /// <p>If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you must also include <code>VocabularyFilterMethod</code>.</p>
    pub vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    /// <p>Specify how you want your custom vocabulary filter applied to the streaming session.</p>
    /// <p>To replace words with <code>***</code>, specify <code>mask</code>.</p>
    /// <p>To delete words, specify <code>remove</code>.</p>
    /// <p>To flag words without changing them, specify <code>tag</code>.</p>
    pub vocabulary_filter_method: ::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services HealthScribe</a>.</p>
    pub resource_access_role_arn: ::std::string::String,
    /// <p>Specify which speaker is on which audio channel.</p>
    pub channel_definitions: ::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>>,
    /// <p>Specify the encryption settings for your streaming session.</p>
    pub encryption_settings: ::std::option::Option<crate::types::MedicalScribeEncryptionSettings>,
    /// <p>Specify settings for post-stream analytics.</p>
    pub post_stream_analytics_settings: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings>,
}
impl MedicalScribeConfigurationEvent {
    /// <p>Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names are case-sensitive.</p>
    pub fn vocabulary_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom vocabulary filter names are case-sensitive.</p>
    /// <p>If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you must also include <code>VocabularyFilterMethod</code>.</p>
    pub fn vocabulary_filter_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>Specify how you want your custom vocabulary filter applied to the streaming session.</p>
    /// <p>To replace words with <code>***</code>, specify <code>mask</code>.</p>
    /// <p>To delete words, specify <code>remove</code>.</p>
    /// <p>To flag words without changing them, specify <code>tag</code>.</p>
    pub fn vocabulary_filter_method(&self) -> ::std::option::Option<&crate::types::MedicalScribeVocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services HealthScribe</a>.</p>
    pub fn resource_access_role_arn(&self) -> &str {
        use std::ops::Deref;
        self.resource_access_role_arn.deref()
    }
    /// <p>Specify which speaker is on which audio channel.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.channel_definitions.is_none()`.
    pub fn channel_definitions(&self) -> &[crate::types::MedicalScribeChannelDefinition] {
        self.channel_definitions.as_deref().unwrap_or_default()
    }
    /// <p>Specify the encryption settings for your streaming session.</p>
    pub fn encryption_settings(&self) -> ::std::option::Option<&crate::types::MedicalScribeEncryptionSettings> {
        self.encryption_settings.as_ref()
    }
    /// <p>Specify settings for post-stream analytics.</p>
    pub fn post_stream_analytics_settings(&self) -> ::std::option::Option<&crate::types::MedicalScribePostStreamAnalyticsSettings> {
        self.post_stream_analytics_settings.as_ref()
    }
}
impl MedicalScribeConfigurationEvent {
    /// Creates a new builder-style object to manufacture [`MedicalScribeConfigurationEvent`](crate::types::MedicalScribeConfigurationEvent).
    pub fn builder() -> crate::types::builders::MedicalScribeConfigurationEventBuilder {
        crate::types::builders::MedicalScribeConfigurationEventBuilder::default()
    }
}

/// A builder for [`MedicalScribeConfigurationEvent`](crate::types::MedicalScribeConfigurationEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalScribeConfigurationEventBuilder {
    pub(crate) vocabulary_name: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_method: ::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod>,
    pub(crate) resource_access_role_arn: ::std::option::Option<::std::string::String>,
    pub(crate) channel_definitions: ::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>>,
    pub(crate) encryption_settings: ::std::option::Option<crate::types::MedicalScribeEncryptionSettings>,
    pub(crate) post_stream_analytics_settings: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings>,
}
impl MedicalScribeConfigurationEventBuilder {
    /// <p>Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names are case-sensitive.</p>
    pub fn vocabulary_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names are case-sensitive.</p>
    pub fn set_vocabulary_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_name = input;
        self
    }
    /// <p>Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names are case-sensitive.</p>
    pub fn get_vocabulary_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_name
    }
    /// <p>Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom vocabulary filter names are case-sensitive.</p>
    /// <p>If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you must also include <code>VocabularyFilterMethod</code>.</p>
    pub fn vocabulary_filter_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_filter_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom vocabulary filter names are case-sensitive.</p>
    /// <p>If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you must also include <code>VocabularyFilterMethod</code>.</p>
    pub fn set_vocabulary_filter_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_filter_name = input;
        self
    }
    /// <p>Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom vocabulary filter names are case-sensitive.</p>
    /// <p>If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you must also include <code>VocabularyFilterMethod</code>.</p>
    pub fn get_vocabulary_filter_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_filter_name
    }
    /// <p>Specify how you want your custom vocabulary filter applied to the streaming session.</p>
    /// <p>To replace words with <code>***</code>, specify <code>mask</code>.</p>
    /// <p>To delete words, specify <code>remove</code>.</p>
    /// <p>To flag words without changing them, specify <code>tag</code>.</p>
    pub fn vocabulary_filter_method(mut self, input: crate::types::MedicalScribeVocabularyFilterMethod) -> Self {
        self.vocabulary_filter_method = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify how you want your custom vocabulary filter applied to the streaming session.</p>
    /// <p>To replace words with <code>***</code>, specify <code>mask</code>.</p>
    /// <p>To delete words, specify <code>remove</code>.</p>
    /// <p>To flag words without changing them, specify <code>tag</code>.</p>
    pub fn set_vocabulary_filter_method(mut self, input: ::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod>) -> Self {
        self.vocabulary_filter_method = input;
        self
    }
    /// <p>Specify how you want your custom vocabulary filter applied to the streaming session.</p>
    /// <p>To replace words with <code>***</code>, specify <code>mask</code>.</p>
    /// <p>To delete words, specify <code>remove</code>.</p>
    /// <p>To flag words without changing them, specify <code>tag</code>.</p>
    pub fn get_vocabulary_filter_method(&self) -> &::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod> {
        &self.vocabulary_filter_method
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services HealthScribe</a>.</p>
    /// This field is required.
    pub fn resource_access_role_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_access_role_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services HealthScribe</a>.</p>
    pub fn set_resource_access_role_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_access_role_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services HealthScribe</a>.</p>
    pub fn get_resource_access_role_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_access_role_arn
    }
    /// Appends an item to `channel_definitions`.
    ///
    /// To override the contents of this collection use [`set_channel_definitions`](Self::set_channel_definitions).
    ///
    /// <p>Specify which speaker is on which audio channel.</p>
    pub fn channel_definitions(mut self, input: crate::types::MedicalScribeChannelDefinition) -> Self {
        let mut v = self.channel_definitions.unwrap_or_default();
        v.push(input);
        self.channel_definitions = ::std::option::Option::Some(v);
        self
    }
    /// <p>Specify which speaker is on which audio channel.</p>
    pub fn set_channel_definitions(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>>) -> Self {
        self.channel_definitions = input;
        self
    }
    /// <p>Specify which speaker is on which audio channel.</p>
    pub fn get_channel_definitions(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>> {
        &self.channel_definitions
    }
    /// <p>Specify the encryption settings for your streaming session.</p>
    pub fn encryption_settings(mut self, input: crate::types::MedicalScribeEncryptionSettings) -> Self {
        self.encryption_settings = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the encryption settings for your streaming session.</p>
    pub fn set_encryption_settings(mut self, input: ::std::option::Option<crate::types::MedicalScribeEncryptionSettings>) -> Self {
        self.encryption_settings = input;
        self
    }
    /// <p>Specify the encryption settings for your streaming session.</p>
    pub fn get_encryption_settings(&self) -> &::std::option::Option<crate::types::MedicalScribeEncryptionSettings> {
        &self.encryption_settings
    }
    /// <p>Specify settings for post-stream analytics.</p>
    /// This field is required.
    pub fn post_stream_analytics_settings(mut self, input: crate::types::MedicalScribePostStreamAnalyticsSettings) -> Self {
        self.post_stream_analytics_settings = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify settings for post-stream analytics.</p>
    pub fn set_post_stream_analytics_settings(
        mut self,
        input: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings>,
    ) -> Self {
        self.post_stream_analytics_settings = input;
        self
    }
    /// <p>Specify settings for post-stream analytics.</p>
    pub fn get_post_stream_analytics_settings(&self) -> &::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings> {
        &self.post_stream_analytics_settings
    }
    /// Consumes the builder and constructs a [`MedicalScribeConfigurationEvent`](crate::types::MedicalScribeConfigurationEvent).
    /// This method will fail if any of the following fields are not set:
    /// - [`resource_access_role_arn`](crate::types::builders::MedicalScribeConfigurationEventBuilder::resource_access_role_arn)
    pub fn build(self) -> ::std::result::Result<crate::types::MedicalScribeConfigurationEvent, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MedicalScribeConfigurationEvent {
            vocabulary_name: self.vocabulary_name,
            vocabulary_filter_name: self.vocabulary_filter_name,
            vocabulary_filter_method: self.vocabulary_filter_method,
            resource_access_role_arn: self.resource_access_role_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "resource_access_role_arn",
                    "resource_access_role_arn was not specified but it is required when building MedicalScribeConfigurationEvent",
                )
            })?,
            channel_definitions: self.channel_definitions,
            encryption_settings: self.encryption_settings,
            post_stream_analytics_settings: self.post_stream_analytics_settings,
        })
    }
}
