// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartMedicalScribeStream`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`session_id(impl Into<String>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::session_id) / [`set_session_id(Option<String>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::set_session_id):<br>required: **false**<br><p>Specify an identifier for your streaming session (in UUID format). If you don't include a SessionId in your request, Amazon Web Services HealthScribe generates an ID and returns it in the response.</p><br>
    ///   - [`language_code(MedicalScribeLanguageCode)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::language_code) / [`set_language_code(Option<MedicalScribeLanguageCode>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::set_language_code):<br>required: **true**<br><p>Specify the language code for your HealthScribe streaming session.</p><br>
    ///   - [`media_sample_rate_hertz(i32)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::media_sample_rate_hertz) / [`set_media_sample_rate_hertz(Option<i32>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::set_media_sample_rate_hertz):<br>required: **true**<br><p>Specify the sample rate of the input audio (in hertz). Amazon Web Services HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you specify must match that of your audio.</p><br>
    ///   - [`media_encoding(MedicalScribeMediaEncoding)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::media_encoding) / [`set_media_encoding(Option<MedicalScribeMediaEncoding>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::set_media_encoding):<br>required: **true**<br><p>Specify the encoding used for the input audio.</p> <p>Supported formats are:</p> <ul>  <li>   <p>FLAC</p></li>  <li>   <p>OPUS-encoded audio in an Ogg container</p></li>  <li>   <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p><br>
    ///   - [`input_stream(EventStreamSender<MedicalScribeInputStream, MedicalScribeInputStreamError>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::input_stream) / [`set_input_stream(EventStreamSender<MedicalScribeInputStream, MedicalScribeInputStreamError>)`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::set_input_stream):<br>required: **true**<br><p>Specify the input stream where you will send events in real time.</p> <p>The first element of the input stream must be a <code>MedicalScribeConfigurationEvent</code>.</p><br>
    /// - On success, responds with [`StartMedicalScribeStreamOutput`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput) with field(s):
    ///   - [`session_id(Option<String>)`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput::session_id): <p>The identifier (in UUID format) for your streaming session.</p> <p>If you already started streaming, this is same ID as the one you specified in your initial <code>StartMedicalScribeStreamRequest</code>.</p>
    ///   - [`request_id(Option<String>)`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput::request_id): <p>The unique identifier for your streaming request.</p>
    ///   - [`language_code(Option<MedicalScribeLanguageCode>)`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput::language_code): <p>The Language Code that you specified in your request. Same as provided in the <code>StartMedicalScribeStreamRequest</code>.</p>
    ///   - [`media_sample_rate_hertz(Option<i32>)`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput::media_sample_rate_hertz): <p>The sample rate (in hertz) that you specified in your request. Same as provided in the <code>StartMedicalScribeStreamRequest</code></p>
    ///   - [`media_encoding(Option<MedicalScribeMediaEncoding>)`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput::media_encoding): <p>The Media Encoding you specified in your request. Same as provided in the <code>StartMedicalScribeStreamRequest</code></p>
    ///   - [`result_stream(EventReceiver<MedicalScribeResultStream, MedicalScribeResultStreamError>)`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamOutput::result_stream): <p>The result stream where you will receive the output events.</p>
    /// - On failure, responds with [`SdkError<StartMedicalScribeStreamError>`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError)
    pub fn start_medical_scribe_stream(&self) -> crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder {
        crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamFluentBuilder::new(self.handle.clone())
    }
}
