# Policy on usage of Artifical Intelligence and other tools

## Background

From time to time I do get pull requests where the author has done
little else than running some tool on the code and submitting it as a
pull request.  Those pull requests may have value to the project, but
it's dishonest to not be transparent about it; teaching me how to run
the tool and integrating it into the CI workflow may have a bigger
value than the changes provided by the tool.  Recently I've also
started receiving pull requests with code changes generated by AI (and
I've seen people posting screenshots of simple questions and answers
from ChatGPT in forum discussions, without contributing anything else).

As of 2025-12, I've spent some time testing Claude.  I'm actually
positively surprised, it's doing a much better job than what I had
expected.  The AI may do things faster, smarter and better than a good
coder.  Sometimes.  Other times it may spend a lot of "tokens" and a
long time coming up with sub-optimal solutions, or even solutions that
doesn't work at all.  Perhaps at some time in the near future the AI
will do the developer profession obsoleted - but as of 2025-11, my
experiences is that the AI performs best when being "supervised" and
"guided" by a good coder knowing the project.

## The rules

* Do **respect the maintainers time**.  If/when the maintainer gets
  overwhelmed by pull requests of questionable quality or pull
  requests that do not pull the project in the right direction, then
  it will be needed to add more requirements to the Contributors
  Guidelines.

* **YOU should add value to the project**. If your contribution
  consists of nothing else than using a tool on the code and
  submitting the resulting code, then the value is coming from the
  tool and not from you.  I could probably have used the tool myself.
  Ok, so you may have done some research, found the tool, installed it
  locally, maybe paid money for a subscription, for sure there is some
  value in that - but if you end up as a messenger copying my comments
  to some AI tools and copying the answer back again - then you're not
  delivering value anymore, then it would be better if the AI tool
  itself would be delivering the pull request and responding to my
  comments.

* **YOU should look through and understand the changes**.  The change
  goes into the project attributed to your name (or at least github
  handle), so I do expect you to at least understand the change you're
  proposing.

* **Transparency** is important.  Ok, so a lot of tools may have been
  used while writing the pull request, I don't need to know all the
  details, but if a significant part of the changes was generated by
  some tool or by some AI, then that should be informed about.
  I.e. if your job was to run `ruff` on the code and found some
  imporant things that should be changed, then don't write "I found
  this issue and here is a fix", but rather "I ran the ruff tool on
  the code, found this issue, and here is the fix".  If some AI was
  used for generating significant parts of the code changs, then it
  should be informed about both in the pull request itself and in the
  git commit message.  The most common way to do this is to add
  "Assisted-by: (name of AI-tool)" at the end of the message.  Claude
  seems to sign off with `Co-Authored-By: Claude
  <noreply@anthropic.com>` when it's doing commits, that's also OK.

* **YOU** should be ready to follow up and respond to feedback and
  questions on the contribution.  If all you do is to relay it to the
  AI and relaying the AI output back to the pull request, then
  you're not adding value to the project and you're not transparent
  and honest.  You should at least do a quick QA on the AI-answer and
  acknowledge that it was generated by the AI.

* The Contributors Guidelines aren't strongly enforced on this project
  as of 2025-12, and I can hardly see cases where the AI would break
  the Code of Conduct, but at the end of the day **YOU** should take
  care to ensure the contribution follows those guidelines.
