{
  description = "exfetch is a shell-extensible fetching utility, written in crystal";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs?ref=master";
    flake-utils.url = "github:numtide/flake-utils";
    self.submodules = true;
  };

  outputs = { self, nixpkgs, flake-utils }:
    flake-utils.lib.eachDefaultSystem (system:
      let
        pkgs = import nixpkgs { inherit system; };
        version = self.sourceInfo.dirtyShortRev or self.sourceInfo.shortRev;
      in
      {
        packages.exfetch = with pkgs;
          crystal.buildCrystalPackage rec {
            inherit version;
            pname = "exfetch";
            
            src = ./.;
            buildPhase = "make";

            doCheck = false;
            meta = {
              description = "Shell-extensible fetching utility, written in crystal";
              mainProgram = "exfetch";
              homepage = "https://codeberg.org/Izder456/exfetch";
              license = lib.licenses.isc;
            };
          };

        packages.default = self.packages.${system}.exfetch;
      });
}
