// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// CreateCorrelationCommand CreateCorrelationCommand is the command for creating a correlation
//
// swagger:model CreateCorrelationCommand
type CreateCorrelationCommand struct {

	// config
	Config *CorrelationConfig `json:"config,omitempty"`

	// Optional description of the correlation
	// Example: Logs to Traces
	Description string `json:"description,omitempty"`

	// Optional label identifying the correlation
	// Example: My label
	Label string `json:"label,omitempty"`

	// True if correlation was created with provisioning. This makes it read-only.
	Provisioned bool `json:"provisioned,omitempty"`

	// Target data source UID to which the correlation is created. required if config.type = query
	// Example: PE1C5CBDA0504A6A3
	TargetUID string `json:"targetUID,omitempty"`
}

// Validate validates this create correlation command
func (m *CreateCorrelationCommand) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfig(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateCorrelationCommand) validateConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.Config) { // not required
		return nil
	}

	if m.Config != nil {
		if err := m.Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create correlation command based on the context it is used
func (m *CreateCorrelationCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateCorrelationCommand) contextValidateConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.Config != nil {

		if swag.IsZero(m.Config) { // not required
			return nil
		}

		if err := m.Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CreateCorrelationCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CreateCorrelationCommand) UnmarshalBinary(b []byte) error {
	var res CreateCorrelationCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
