// Code generated by go-swagger; DO NOT EDIT.

package snapshots

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new snapshots API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for snapshots API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateDashboardSnapshot(body *models.CreateDashboardSnapshotCommand, opts ...ClientOption) (*CreateDashboardSnapshotOK, error)
	CreateDashboardSnapshotWithParams(params *CreateDashboardSnapshotParams, opts ...ClientOption) (*CreateDashboardSnapshotOK, error)

	DeleteDashboardSnapshot(key string, opts ...ClientOption) (*DeleteDashboardSnapshotOK, error)
	DeleteDashboardSnapshotWithParams(params *DeleteDashboardSnapshotParams, opts ...ClientOption) (*DeleteDashboardSnapshotOK, error)

	DeleteDashboardSnapshotByDeleteKey(deleteKey string, opts ...ClientOption) (*DeleteDashboardSnapshotByDeleteKeyOK, error)
	DeleteDashboardSnapshotByDeleteKeyWithParams(params *DeleteDashboardSnapshotByDeleteKeyParams, opts ...ClientOption) (*DeleteDashboardSnapshotByDeleteKeyOK, error)

	GetDashboardSnapshot(key string, opts ...ClientOption) (*GetDashboardSnapshotOK, error)
	GetDashboardSnapshotWithParams(params *GetDashboardSnapshotParams, opts ...ClientOption) (*GetDashboardSnapshotOK, error)

	GetSharingOptions(opts ...ClientOption) (*GetSharingOptionsOK, error)
	GetSharingOptionsWithParams(params *GetSharingOptionsParams, opts ...ClientOption) (*GetSharingOptionsOK, error)

	SearchDashboardSnapshots(params *SearchDashboardSnapshotsParams, opts ...ClientOption) (*SearchDashboardSnapshotsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateDashboardSnapshot whens creating a snapshot using the API you have to provide the full dashboard payload including the snapshot data this endpoint is designed for the grafana UI

Snapshot public mode should be enabled or authentication is required.
*/
func (a *Client) CreateDashboardSnapshot(body *models.CreateDashboardSnapshotCommand, opts ...ClientOption) (*CreateDashboardSnapshotOK, error) {
	params := NewCreateDashboardSnapshotParams().WithBody(body)
	return a.CreateDashboardSnapshotWithParams(params, opts...)
}

func (a *Client) CreateDashboardSnapshotWithParams(params *CreateDashboardSnapshotParams, opts ...ClientOption) (*CreateDashboardSnapshotOK, error) {
	if params == nil {
		params = NewCreateDashboardSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createDashboardSnapshot",
		Method:             "POST",
		PathPattern:        "/snapshots",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateDashboardSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateDashboardSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createDashboardSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteDashboardSnapshot deletes snapshot by key
*/
func (a *Client) DeleteDashboardSnapshot(key string, opts ...ClientOption) (*DeleteDashboardSnapshotOK, error) {
	params := NewDeleteDashboardSnapshotParams().WithKey(key)
	return a.DeleteDashboardSnapshotWithParams(params, opts...)
}

func (a *Client) DeleteDashboardSnapshotWithParams(params *DeleteDashboardSnapshotParams, opts ...ClientOption) (*DeleteDashboardSnapshotOK, error) {
	if params == nil {
		params = NewDeleteDashboardSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteDashboardSnapshot",
		Method:             "DELETE",
		PathPattern:        "/snapshots/{key}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteDashboardSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteDashboardSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteDashboardSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteDashboardSnapshotByDeleteKey deletes snapshot by delete key

Snapshot public mode should be enabled or authentication is required.
*/
func (a *Client) DeleteDashboardSnapshotByDeleteKey(deleteKey string, opts ...ClientOption) (*DeleteDashboardSnapshotByDeleteKeyOK, error) {
	params := NewDeleteDashboardSnapshotByDeleteKeyParams().WithDeleteKey(deleteKey)
	return a.DeleteDashboardSnapshotByDeleteKeyWithParams(params, opts...)
}

func (a *Client) DeleteDashboardSnapshotByDeleteKeyWithParams(params *DeleteDashboardSnapshotByDeleteKeyParams, opts ...ClientOption) (*DeleteDashboardSnapshotByDeleteKeyOK, error) {
	if params == nil {
		params = NewDeleteDashboardSnapshotByDeleteKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteDashboardSnapshotByDeleteKey",
		Method:             "GET",
		PathPattern:        "/snapshots-delete/{deleteKey}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteDashboardSnapshotByDeleteKeyReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteDashboardSnapshotByDeleteKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteDashboardSnapshotByDeleteKey: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDashboardSnapshot gets snapshot by key
*/
func (a *Client) GetDashboardSnapshot(key string, opts ...ClientOption) (*GetDashboardSnapshotOK, error) {
	params := NewGetDashboardSnapshotParams().WithKey(key)
	return a.GetDashboardSnapshotWithParams(params, opts...)
}

func (a *Client) GetDashboardSnapshotWithParams(params *GetDashboardSnapshotParams, opts ...ClientOption) (*GetDashboardSnapshotOK, error) {
	if params == nil {
		params = NewGetDashboardSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDashboardSnapshot",
		Method:             "GET",
		PathPattern:        "/snapshots/{key}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDashboardSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDashboardSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDashboardSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSharingOptions gets snapshot sharing settings
*/
func (a *Client) GetSharingOptions(opts ...ClientOption) (*GetSharingOptionsOK, error) {
	params := NewGetSharingOptionsParams()
	return a.GetSharingOptionsWithParams(params, opts...)
}

func (a *Client) GetSharingOptionsWithParams(params *GetSharingOptionsParams, opts ...ClientOption) (*GetSharingOptionsOK, error) {
	if params == nil {
		params = NewGetSharingOptionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSharingOptions",
		Method:             "GET",
		PathPattern:        "/snapshot/shared-options",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSharingOptionsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSharingOptionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSharingOptions: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SearchDashboardSnapshots lists snapshots
*/

func (a *Client) SearchDashboardSnapshots(params *SearchDashboardSnapshotsParams, opts ...ClientOption) (*SearchDashboardSnapshotsOK, error) {
	if params == nil {
		params = NewSearchDashboardSnapshotsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "searchDashboardSnapshots",
		Method:             "GET",
		PathPattern:        "/dashboard/snapshots",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SearchDashboardSnapshotsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SearchDashboardSnapshotsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for searchDashboardSnapshots: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
