// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteOrgByIDReader is a Reader for the DeleteOrgByID structure.
type DeleteOrgByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteOrgByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteOrgByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteOrgByIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteOrgByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteOrgByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteOrgByIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteOrgByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /orgs/{org_id}] deleteOrgByID", response, response.Code())
	}
}

// NewDeleteOrgByIDOK creates a DeleteOrgByIDOK with default headers values
func NewDeleteOrgByIDOK() *DeleteOrgByIDOK {
	return &DeleteOrgByIDOK{}
}

/*
DeleteOrgByIDOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteOrgByIDOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete org by Id Ok response has a 2xx status code
func (o *DeleteOrgByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete org by Id Ok response has a 3xx status code
func (o *DeleteOrgByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete org by Id Ok response has a 4xx status code
func (o *DeleteOrgByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete org by Id Ok response has a 5xx status code
func (o *DeleteOrgByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete org by Id Ok response a status code equal to that given
func (o *DeleteOrgByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete org by Id Ok response
func (o *DeleteOrgByIDOK) Code() int {
	return 200
}

func (o *DeleteOrgByIDOK) Error() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdOk  %+v", 200, o.Payload)
}

func (o *DeleteOrgByIDOK) String() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdOk  %+v", 200, o.Payload)
}

func (o *DeleteOrgByIDOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteOrgByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteOrgByIDBadRequest creates a DeleteOrgByIDBadRequest with default headers values
func NewDeleteOrgByIDBadRequest() *DeleteOrgByIDBadRequest {
	return &DeleteOrgByIDBadRequest{}
}

/*
DeleteOrgByIDBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteOrgByIDBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete org by Id bad request response has a 2xx status code
func (o *DeleteOrgByIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete org by Id bad request response has a 3xx status code
func (o *DeleteOrgByIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete org by Id bad request response has a 4xx status code
func (o *DeleteOrgByIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete org by Id bad request response has a 5xx status code
func (o *DeleteOrgByIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete org by Id bad request response a status code equal to that given
func (o *DeleteOrgByIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete org by Id bad request response
func (o *DeleteOrgByIDBadRequest) Code() int {
	return 400
}

func (o *DeleteOrgByIDBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteOrgByIDBadRequest) String() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteOrgByIDBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteOrgByIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteOrgByIDUnauthorized creates a DeleteOrgByIDUnauthorized with default headers values
func NewDeleteOrgByIDUnauthorized() *DeleteOrgByIDUnauthorized {
	return &DeleteOrgByIDUnauthorized{}
}

/*
DeleteOrgByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteOrgByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete org by Id unauthorized response has a 2xx status code
func (o *DeleteOrgByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete org by Id unauthorized response has a 3xx status code
func (o *DeleteOrgByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete org by Id unauthorized response has a 4xx status code
func (o *DeleteOrgByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete org by Id unauthorized response has a 5xx status code
func (o *DeleteOrgByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete org by Id unauthorized response a status code equal to that given
func (o *DeleteOrgByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete org by Id unauthorized response
func (o *DeleteOrgByIDUnauthorized) Code() int {
	return 401
}

func (o *DeleteOrgByIDUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *DeleteOrgByIDUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *DeleteOrgByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteOrgByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteOrgByIDForbidden creates a DeleteOrgByIDForbidden with default headers values
func NewDeleteOrgByIDForbidden() *DeleteOrgByIDForbidden {
	return &DeleteOrgByIDForbidden{}
}

/*
DeleteOrgByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteOrgByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete org by Id forbidden response has a 2xx status code
func (o *DeleteOrgByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete org by Id forbidden response has a 3xx status code
func (o *DeleteOrgByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete org by Id forbidden response has a 4xx status code
func (o *DeleteOrgByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete org by Id forbidden response has a 5xx status code
func (o *DeleteOrgByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete org by Id forbidden response a status code equal to that given
func (o *DeleteOrgByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete org by Id forbidden response
func (o *DeleteOrgByIDForbidden) Code() int {
	return 403
}

func (o *DeleteOrgByIDForbidden) Error() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdForbidden  %+v", 403, o.Payload)
}

func (o *DeleteOrgByIDForbidden) String() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdForbidden  %+v", 403, o.Payload)
}

func (o *DeleteOrgByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteOrgByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteOrgByIDNotFound creates a DeleteOrgByIDNotFound with default headers values
func NewDeleteOrgByIDNotFound() *DeleteOrgByIDNotFound {
	return &DeleteOrgByIDNotFound{}
}

/*
DeleteOrgByIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteOrgByIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete org by Id not found response has a 2xx status code
func (o *DeleteOrgByIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete org by Id not found response has a 3xx status code
func (o *DeleteOrgByIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete org by Id not found response has a 4xx status code
func (o *DeleteOrgByIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete org by Id not found response has a 5xx status code
func (o *DeleteOrgByIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete org by Id not found response a status code equal to that given
func (o *DeleteOrgByIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete org by Id not found response
func (o *DeleteOrgByIDNotFound) Code() int {
	return 404
}

func (o *DeleteOrgByIDNotFound) Error() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdNotFound  %+v", 404, o.Payload)
}

func (o *DeleteOrgByIDNotFound) String() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdNotFound  %+v", 404, o.Payload)
}

func (o *DeleteOrgByIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteOrgByIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteOrgByIDInternalServerError creates a DeleteOrgByIDInternalServerError with default headers values
func NewDeleteOrgByIDInternalServerError() *DeleteOrgByIDInternalServerError {
	return &DeleteOrgByIDInternalServerError{}
}

/*
DeleteOrgByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteOrgByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete org by Id internal server error response has a 2xx status code
func (o *DeleteOrgByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete org by Id internal server error response has a 3xx status code
func (o *DeleteOrgByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete org by Id internal server error response has a 4xx status code
func (o *DeleteOrgByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete org by Id internal server error response has a 5xx status code
func (o *DeleteOrgByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete org by Id internal server error response a status code equal to that given
func (o *DeleteOrgByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete org by Id internal server error response
func (o *DeleteOrgByIDInternalServerError) Code() int {
	return 500
}

func (o *DeleteOrgByIDInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteOrgByIDInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /orgs/{org_id}][%d] deleteOrgByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteOrgByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteOrgByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
