// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new access control API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for access control API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddTeamRole(teamID int64, body *models.AddTeamRoleCommand, opts ...ClientOption) (*AddTeamRoleOK, error)
	AddTeamRoleWithParams(params *AddTeamRoleParams, opts ...ClientOption) (*AddTeamRoleOK, error)

	AddUserRole(userID int64, body *models.AddUserRoleCommand, opts ...ClientOption) (*AddUserRoleOK, error)
	AddUserRoleWithParams(params *AddUserRoleParams, opts ...ClientOption) (*AddUserRoleOK, error)

	CreateRole(body *models.CreateRoleForm, opts ...ClientOption) (*CreateRoleCreated, error)
	CreateRoleWithParams(params *CreateRoleParams, opts ...ClientOption) (*CreateRoleCreated, error)

	DeleteRole(params *DeleteRoleParams, opts ...ClientOption) (*DeleteRoleOK, error)

	GetAccessControlStatus(opts ...ClientOption) (*GetAccessControlStatusOK, error)
	GetAccessControlStatusWithParams(params *GetAccessControlStatusParams, opts ...ClientOption) (*GetAccessControlStatusOK, error)

	GetRole(roleUID string, opts ...ClientOption) (*GetRoleOK, error)
	GetRoleWithParams(params *GetRoleParams, opts ...ClientOption) (*GetRoleOK, error)

	GetRoleAssignments(roleUID string, opts ...ClientOption) (*GetRoleAssignmentsOK, error)
	GetRoleAssignmentsWithParams(params *GetRoleAssignmentsParams, opts ...ClientOption) (*GetRoleAssignmentsOK, error)

	ListRoles(params *ListRolesParams, opts ...ClientOption) (*ListRolesOK, error)

	ListTeamRoles(teamID int64, opts ...ClientOption) (*ListTeamRolesOK, error)
	ListTeamRolesWithParams(params *ListTeamRolesParams, opts ...ClientOption) (*ListTeamRolesOK, error)

	ListUserRoles(userID int64, opts ...ClientOption) (*ListUserRolesOK, error)
	ListUserRolesWithParams(params *ListUserRolesParams, opts ...ClientOption) (*ListUserRolesOK, error)

	RemoveTeamRole(teamID int64, roleUID string, opts ...ClientOption) (*RemoveTeamRoleOK, error)
	RemoveTeamRoleWithParams(params *RemoveTeamRoleParams, opts ...ClientOption) (*RemoveTeamRoleOK, error)

	RemoveUserRole(params *RemoveUserRoleParams, opts ...ClientOption) (*RemoveUserRoleOK, error)

	SetRoleAssignments(roleUID string, body *models.SetRoleAssignmentsCommand, opts ...ClientOption) (*SetRoleAssignmentsOK, error)
	SetRoleAssignmentsWithParams(params *SetRoleAssignmentsParams, opts ...ClientOption) (*SetRoleAssignmentsOK, error)

	SetTeamRoles(teamID int64, opts ...ClientOption) (*SetTeamRolesOK, error)
	SetTeamRolesWithParams(params *SetTeamRolesParams, opts ...ClientOption) (*SetTeamRolesOK, error)

	SetUserRoles(userID int64, body *models.SetUserRolesCommand, opts ...ClientOption) (*SetUserRolesOK, error)
	SetUserRolesWithParams(params *SetUserRolesParams, opts ...ClientOption) (*SetUserRolesOK, error)

	UpdateRole(roleUID string, body *models.UpdateRoleCommand, opts ...ClientOption) (*UpdateRoleOK, error)
	UpdateRoleWithParams(params *UpdateRoleParams, opts ...ClientOption) (*UpdateRoleOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddTeamRole adds team role

You need to have a permission with action `teams.roles:add` and scope `permissions:type:delegate`.
*/
func (a *Client) AddTeamRole(teamID int64, body *models.AddTeamRoleCommand, opts ...ClientOption) (*AddTeamRoleOK, error) {
	params := NewAddTeamRoleParams().WithBody(body).WithTeamID(teamID)
	return a.AddTeamRoleWithParams(params, opts...)
}

func (a *Client) AddTeamRoleWithParams(params *AddTeamRoleParams, opts ...ClientOption) (*AddTeamRoleOK, error) {
	if params == nil {
		params = NewAddTeamRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addTeamRole",
		Method:             "POST",
		PathPattern:        "/access-control/teams/{teamId}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddTeamRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddTeamRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addTeamRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AddUserRole adds a user role assignment

Assign a role to a specific user. For bulk updates consider Set user role assignments.

You need to have a permission with action `users.roles:add` and scope `permissions:type:delegate`. `permissions:type:delegate` scope ensures that users can only assign roles which have same, or a subset of permissions which the user has. For example, if a user does not have required permissions for creating users, they won’t be able to assign a role which will allow to do that. This is done to prevent escalation of privileges.
*/
func (a *Client) AddUserRole(userID int64, body *models.AddUserRoleCommand, opts ...ClientOption) (*AddUserRoleOK, error) {
	params := NewAddUserRoleParams().WithBody(body).WithUserID(userID)
	return a.AddUserRoleWithParams(params, opts...)
}

func (a *Client) AddUserRoleWithParams(params *AddUserRoleParams, opts ...ClientOption) (*AddUserRoleOK, error) {
	if params == nil {
		params = NewAddUserRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addUserRole",
		Method:             "POST",
		PathPattern:        "/access-control/users/{userId}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddUserRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddUserRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addUserRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateRole creates a new custom role

Creates a new custom role and maps given permissions to that role. Note that roles with the same prefix as Fixed Roles can’t be created.

You need to have a permission with action `roles:write` and scope `permissions:type:delegate`. `permissions:type:delegate` scope ensures that users can only create custom roles with the same, or a subset of permissions which the user has.
For example, if a user does not have required permissions for creating users, they won’t be able to create a custom role which allows to do that. This is done to prevent escalation of privileges.
*/
func (a *Client) CreateRole(body *models.CreateRoleForm, opts ...ClientOption) (*CreateRoleCreated, error) {
	params := NewCreateRoleParams().WithBody(body)
	return a.CreateRoleWithParams(params, opts...)
}

func (a *Client) CreateRoleWithParams(params *CreateRoleParams, opts ...ClientOption) (*CreateRoleCreated, error) {
	if params == nil {
		params = NewCreateRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createRole",
		Method:             "POST",
		PathPattern:        "/access-control/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRoleCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteRole deletes a custom role

Delete a role with the given UID, and it’s permissions. If the role is assigned to a built-in role, the deletion operation will fail, unless force query param is set to true, and in that case all assignments will also be deleted.

You need to have a permission with action `roles:delete` and scope `permissions:type:delegate`. `permissions:type:delegate` scope ensures that users can only delete a custom role with the same, or a subset of permissions which the user has. For example, if a user does not have required permissions for creating users, they won’t be able to delete a custom role which allows to do that.
*/

func (a *Client) DeleteRole(params *DeleteRoleParams, opts ...ClientOption) (*DeleteRoleOK, error) {
	if params == nil {
		params = NewDeleteRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteRole",
		Method:             "DELETE",
		PathPattern:        "/access-control/roles/{roleUID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAccessControlStatus gets status

Returns an indicator to check if fine-grained access control is enabled or not.

You need to have a permission with action `status:accesscontrol` and scope `services:accesscontrol`.
*/
func (a *Client) GetAccessControlStatus(opts ...ClientOption) (*GetAccessControlStatusOK, error) {
	params := NewGetAccessControlStatusParams()
	return a.GetAccessControlStatusWithParams(params, opts...)
}

func (a *Client) GetAccessControlStatusWithParams(params *GetAccessControlStatusParams, opts ...ClientOption) (*GetAccessControlStatusOK, error) {
	if params == nil {
		params = NewGetAccessControlStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getAccessControlStatus",
		Method:             "GET",
		PathPattern:        "/access-control/status",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAccessControlStatusReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAccessControlStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getAccessControlStatus: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRole gets a role

Get a role for the given UID.

You need to have a permission with action `roles:read` and scope `roles:*`.
*/
func (a *Client) GetRole(roleUID string, opts ...ClientOption) (*GetRoleOK, error) {
	params := NewGetRoleParams().WithRoleUID(roleUID)
	return a.GetRoleWithParams(params, opts...)
}

func (a *Client) GetRoleWithParams(params *GetRoleParams, opts ...ClientOption) (*GetRoleOK, error) {
	if params == nil {
		params = NewGetRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getRole",
		Method:             "GET",
		PathPattern:        "/access-control/roles/{roleUID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRoleAssignments gets role assignments

Get role assignments for the role with the given UID.

You need to have a permission with action `teams.roles:list` and scope `teams:id:*` and `users.roles:list` and scope `users:id:*`.
*/
func (a *Client) GetRoleAssignments(roleUID string, opts ...ClientOption) (*GetRoleAssignmentsOK, error) {
	params := NewGetRoleAssignmentsParams().WithRoleUID(roleUID)
	return a.GetRoleAssignmentsWithParams(params, opts...)
}

func (a *Client) GetRoleAssignmentsWithParams(params *GetRoleAssignmentsParams, opts ...ClientOption) (*GetRoleAssignmentsOK, error) {
	if params == nil {
		params = NewGetRoleAssignmentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getRoleAssignments",
		Method:             "GET",
		PathPattern:        "/access-control/roles/{roleUID}/assignments",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetRoleAssignmentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRoleAssignmentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getRoleAssignments: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListRoles gets all roles

Gets all existing roles. The response contains all global and organization local roles, for the organization which user is signed in.

You need to have a permission with action `roles:read` and scope `roles:*`.
*/

func (a *Client) ListRoles(params *ListRolesParams, opts ...ClientOption) (*ListRolesOK, error) {
	if params == nil {
		params = NewListRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "listRoles",
		Method:             "GET",
		PathPattern:        "/access-control/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listRoles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListTeamRoles gets team roles

You need to have a permission with action `teams.roles:read` and scope `teams:id:<team ID>`.
*/
func (a *Client) ListTeamRoles(teamID int64, opts ...ClientOption) (*ListTeamRolesOK, error) {
	params := NewListTeamRolesParams().WithTeamID(teamID)
	return a.ListTeamRolesWithParams(params, opts...)
}

func (a *Client) ListTeamRolesWithParams(params *ListTeamRolesParams, opts ...ClientOption) (*ListTeamRolesOK, error) {
	if params == nil {
		params = NewListTeamRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "listTeamRoles",
		Method:             "GET",
		PathPattern:        "/access-control/teams/{teamId}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListTeamRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListTeamRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listTeamRoles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListUserRoles lists roles assigned to a user

Lists the roles that have been directly assigned to a given user. The list does not include built-in roles (Viewer, Editor, Admin or Grafana Admin), and it does not include roles that have been inherited from a team.

You need to have a permission with action `users.roles:read` and scope `users:id:<user ID>`.
*/
func (a *Client) ListUserRoles(userID int64, opts ...ClientOption) (*ListUserRolesOK, error) {
	params := NewListUserRolesParams().WithUserID(userID)
	return a.ListUserRolesWithParams(params, opts...)
}

func (a *Client) ListUserRolesWithParams(params *ListUserRolesParams, opts ...ClientOption) (*ListUserRolesOK, error) {
	if params == nil {
		params = NewListUserRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "listUserRoles",
		Method:             "GET",
		PathPattern:        "/access-control/users/{userId}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListUserRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListUserRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listUserRoles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RemoveTeamRole removes team role

You need to have a permission with action `teams.roles:remove` and scope `permissions:type:delegate`.
*/
func (a *Client) RemoveTeamRole(teamID int64, roleUID string, opts ...ClientOption) (*RemoveTeamRoleOK, error) {
	params := NewRemoveTeamRoleParams().WithRoleUID(roleUID).WithTeamID(teamID)
	return a.RemoveTeamRoleWithParams(params, opts...)
}

func (a *Client) RemoveTeamRoleWithParams(params *RemoveTeamRoleParams, opts ...ClientOption) (*RemoveTeamRoleOK, error) {
	if params == nil {
		params = NewRemoveTeamRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "removeTeamRole",
		Method:             "DELETE",
		PathPattern:        "/access-control/teams/{teamId}/roles/{roleUID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RemoveTeamRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RemoveTeamRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for removeTeamRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RemoveUserRole removes a user role assignment

Revoke a role from a user. For bulk updates consider Set user role assignments.

You need to have a permission with action `users.roles:remove` and scope `permissions:type:delegate`. `permissions:type:delegate` scope ensures that users can only unassign roles which have same, or a subset of permissions which the user has. For example, if a user does not have required permissions for creating users, they won’t be able to unassign a role which will allow to do that. This is done to prevent escalation of privileges.
*/

func (a *Client) RemoveUserRole(params *RemoveUserRoleParams, opts ...ClientOption) (*RemoveUserRoleOK, error) {
	if params == nil {
		params = NewRemoveUserRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "removeUserRole",
		Method:             "DELETE",
		PathPattern:        "/access-control/users/{userId}/roles/{roleUID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RemoveUserRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RemoveUserRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for removeUserRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SetRoleAssignments sets role assignments

Set role assignments for the role with the given UID.

You need to have a permission with action `teams.roles:add` and `teams.roles:remove` and scope `permissions:type:delegate`, and `users.roles:add` and `users.roles:remove` and scope `permissions:type:delegate`.
*/
func (a *Client) SetRoleAssignments(roleUID string, body *models.SetRoleAssignmentsCommand, opts ...ClientOption) (*SetRoleAssignmentsOK, error) {
	params := NewSetRoleAssignmentsParams().WithBody(body).WithRoleUID(roleUID)
	return a.SetRoleAssignmentsWithParams(params, opts...)
}

func (a *Client) SetRoleAssignmentsWithParams(params *SetRoleAssignmentsParams, opts ...ClientOption) (*SetRoleAssignmentsOK, error) {
	if params == nil {
		params = NewSetRoleAssignmentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "setRoleAssignments",
		Method:             "PUT",
		PathPattern:        "/access-control/roles/{roleUID}/assignments",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SetRoleAssignmentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetRoleAssignmentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for setRoleAssignments: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SetTeamRoles updates team role

You need to have a permission with action `teams.roles:add` and `teams.roles:remove` and scope `permissions:type:delegate` for each.
*/
func (a *Client) SetTeamRoles(teamID int64, opts ...ClientOption) (*SetTeamRolesOK, error) {
	params := NewSetTeamRolesParams().WithTeamID(teamID)
	return a.SetTeamRolesWithParams(params, opts...)
}

func (a *Client) SetTeamRolesWithParams(params *SetTeamRolesParams, opts ...ClientOption) (*SetTeamRolesOK, error) {
	if params == nil {
		params = NewSetTeamRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "setTeamRoles",
		Method:             "PUT",
		PathPattern:        "/access-control/teams/{teamId}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SetTeamRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetTeamRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for setTeamRoles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SetUserRoles sets user role assignments

Update the user’s role assignments to match the provided set of UIDs. This will remove any assigned roles that aren’t in the request and add roles that are in the set but are not already assigned to the user.
If you want to add or remove a single role, consider using Add a user role assignment or Remove a user role assignment instead.

You need to have a permission with action `users.roles:add` and `users.roles:remove` and scope `permissions:type:delegate` for each. `permissions:type:delegate`  scope ensures that users can only assign or unassign roles which have same, or a subset of permissions which the user has. For example, if a user does not have required permissions for creating users, they won’t be able to assign or unassign a role which will allow to do that. This is done to prevent escalation of privileges.
*/
func (a *Client) SetUserRoles(userID int64, body *models.SetUserRolesCommand, opts ...ClientOption) (*SetUserRolesOK, error) {
	params := NewSetUserRolesParams().WithBody(body).WithUserID(userID)
	return a.SetUserRolesWithParams(params, opts...)
}

func (a *Client) SetUserRolesWithParams(params *SetUserRolesParams, opts ...ClientOption) (*SetUserRolesOK, error) {
	if params == nil {
		params = NewSetUserRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "setUserRoles",
		Method:             "PUT",
		PathPattern:        "/access-control/users/{userId}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SetUserRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetUserRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for setUserRoles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRole updates a custom role

You need to have a permission with action `roles:write` and scope `permissions:type:delegate`. `permissions:type:delegate` scope ensures that users can only create custom roles with the same, or a subset of permissions which the user has.
*/
func (a *Client) UpdateRole(roleUID string, body *models.UpdateRoleCommand, opts ...ClientOption) (*UpdateRoleOK, error) {
	params := NewUpdateRoleParams().WithBody(body).WithRoleUID(roleUID)
	return a.UpdateRoleWithParams(params, opts...)
}

func (a *Client) UpdateRoleWithParams(params *UpdateRoleParams, opts ...ClientOption) (*UpdateRoleOK, error) {
	if params == nil {
		params = NewUpdateRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateRole",
		Method:             "PUT",
		PathPattern:        "/access-control/roles/{roleUID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateRole: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
