//
//Copyright 2019 The Vitess Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file contains all the types and servers necessary to make
// RPC calls to VtTablet for the binlog protocol, used by filtered
// replication only.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.3
// source: dolthub/vt/binlogdata.proto

package binlogdata

import (
	query "github.com/dolthub/vitess/go/vt/proto/query"
	topodata "github.com/dolthub/vitess/go/vt/proto/topodata"
	vtrpc "github.com/dolthub/vitess/go/vt/proto/vtrpc"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// OnDDLAction lists the possible actions for DDLs.
type OnDDLAction int32

const (
	OnDDLAction_IGNORE      OnDDLAction = 0
	OnDDLAction_STOP        OnDDLAction = 1
	OnDDLAction_EXEC        OnDDLAction = 2
	OnDDLAction_EXEC_IGNORE OnDDLAction = 3
)

// Enum value maps for OnDDLAction.
var (
	OnDDLAction_name = map[int32]string{
		0: "IGNORE",
		1: "STOP",
		2: "EXEC",
		3: "EXEC_IGNORE",
	}
	OnDDLAction_value = map[string]int32{
		"IGNORE":      0,
		"STOP":        1,
		"EXEC":        2,
		"EXEC_IGNORE": 3,
	}
)

func (x OnDDLAction) Enum() *OnDDLAction {
	p := new(OnDDLAction)
	*p = x
	return p
}

func (x OnDDLAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnDDLAction) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_binlogdata_proto_enumTypes[0].Descriptor()
}

func (OnDDLAction) Type() protoreflect.EnumType {
	return &file_dolthub_vt_binlogdata_proto_enumTypes[0]
}

func (x OnDDLAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnDDLAction.Descriptor instead.
func (OnDDLAction) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{0}
}

// VEventType enumerates the event types.
// This list is comprehensive. Many of these types
// will not be encountered in RBR mode.
type VEventType int32

const (
	VEventType_UNKNOWN   VEventType = 0
	VEventType_GTID      VEventType = 1
	VEventType_BEGIN     VEventType = 2
	VEventType_COMMIT    VEventType = 3
	VEventType_ROLLBACK  VEventType = 4
	VEventType_DDL       VEventType = 5
	VEventType_INSERT    VEventType = 6
	VEventType_REPLACE   VEventType = 7
	VEventType_UPDATE    VEventType = 8
	VEventType_DELETE    VEventType = 9
	VEventType_SET       VEventType = 10
	VEventType_OTHER     VEventType = 11
	VEventType_ROW       VEventType = 12
	VEventType_FIELD     VEventType = 13
	VEventType_HEARTBEAT VEventType = 14
	VEventType_VGTID     VEventType = 15
	VEventType_JOURNAL   VEventType = 16
)

// Enum value maps for VEventType.
var (
	VEventType_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "GTID",
		2:  "BEGIN",
		3:  "COMMIT",
		4:  "ROLLBACK",
		5:  "DDL",
		6:  "INSERT",
		7:  "REPLACE",
		8:  "UPDATE",
		9:  "DELETE",
		10: "SET",
		11: "OTHER",
		12: "ROW",
		13: "FIELD",
		14: "HEARTBEAT",
		15: "VGTID",
		16: "JOURNAL",
	}
	VEventType_value = map[string]int32{
		"UNKNOWN":   0,
		"GTID":      1,
		"BEGIN":     2,
		"COMMIT":    3,
		"ROLLBACK":  4,
		"DDL":       5,
		"INSERT":    6,
		"REPLACE":   7,
		"UPDATE":    8,
		"DELETE":    9,
		"SET":       10,
		"OTHER":     11,
		"ROW":       12,
		"FIELD":     13,
		"HEARTBEAT": 14,
		"VGTID":     15,
		"JOURNAL":   16,
	}
)

func (x VEventType) Enum() *VEventType {
	p := new(VEventType)
	*p = x
	return p
}

func (x VEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_binlogdata_proto_enumTypes[1].Descriptor()
}

func (VEventType) Type() protoreflect.EnumType {
	return &file_dolthub_vt_binlogdata_proto_enumTypes[1]
}

func (x VEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VEventType.Descriptor instead.
func (VEventType) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{1}
}

// MigrationType specifies the type of migration for the Journal.
type MigrationType int32

const (
	MigrationType_TABLES MigrationType = 0
	MigrationType_SHARDS MigrationType = 1
)

// Enum value maps for MigrationType.
var (
	MigrationType_name = map[int32]string{
		0: "TABLES",
		1: "SHARDS",
	}
	MigrationType_value = map[string]int32{
		"TABLES": 0,
		"SHARDS": 1,
	}
)

func (x MigrationType) Enum() *MigrationType {
	p := new(MigrationType)
	*p = x
	return p
}

func (x MigrationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationType) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_binlogdata_proto_enumTypes[2].Descriptor()
}

func (MigrationType) Type() protoreflect.EnumType {
	return &file_dolthub_vt_binlogdata_proto_enumTypes[2]
}

func (x MigrationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationType.Descriptor instead.
func (MigrationType) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{2}
}

type BinlogTransaction_Statement_Category int32

const (
	BinlogTransaction_Statement_BL_UNRECOGNIZED BinlogTransaction_Statement_Category = 0
	BinlogTransaction_Statement_BL_BEGIN        BinlogTransaction_Statement_Category = 1
	BinlogTransaction_Statement_BL_COMMIT       BinlogTransaction_Statement_Category = 2
	BinlogTransaction_Statement_BL_ROLLBACK     BinlogTransaction_Statement_Category = 3
	// BL_DML is deprecated.
	BinlogTransaction_Statement_BL_DML_DEPRECATED BinlogTransaction_Statement_Category = 4
	BinlogTransaction_Statement_BL_DDL            BinlogTransaction_Statement_Category = 5
	BinlogTransaction_Statement_BL_SET            BinlogTransaction_Statement_Category = 6
	BinlogTransaction_Statement_BL_INSERT         BinlogTransaction_Statement_Category = 7
	BinlogTransaction_Statement_BL_UPDATE         BinlogTransaction_Statement_Category = 8
	BinlogTransaction_Statement_BL_DELETE         BinlogTransaction_Statement_Category = 9
)

// Enum value maps for BinlogTransaction_Statement_Category.
var (
	BinlogTransaction_Statement_Category_name = map[int32]string{
		0: "BL_UNRECOGNIZED",
		1: "BL_BEGIN",
		2: "BL_COMMIT",
		3: "BL_ROLLBACK",
		4: "BL_DML_DEPRECATED",
		5: "BL_DDL",
		6: "BL_SET",
		7: "BL_INSERT",
		8: "BL_UPDATE",
		9: "BL_DELETE",
	}
	BinlogTransaction_Statement_Category_value = map[string]int32{
		"BL_UNRECOGNIZED":   0,
		"BL_BEGIN":          1,
		"BL_COMMIT":         2,
		"BL_ROLLBACK":       3,
		"BL_DML_DEPRECATED": 4,
		"BL_DDL":            5,
		"BL_SET":            6,
		"BL_INSERT":         7,
		"BL_UPDATE":         8,
		"BL_DELETE":         9,
	}
)

func (x BinlogTransaction_Statement_Category) Enum() *BinlogTransaction_Statement_Category {
	p := new(BinlogTransaction_Statement_Category)
	*p = x
	return p
}

func (x BinlogTransaction_Statement_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BinlogTransaction_Statement_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_binlogdata_proto_enumTypes[3].Descriptor()
}

func (BinlogTransaction_Statement_Category) Type() protoreflect.EnumType {
	return &file_dolthub_vt_binlogdata_proto_enumTypes[3]
}

func (x BinlogTransaction_Statement_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BinlogTransaction_Statement_Category.Descriptor instead.
func (BinlogTransaction_Statement_Category) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{1, 0, 0}
}

type Filter_FieldEventMode int32

const (
	Filter_ERR_ON_MISMATCH Filter_FieldEventMode = 0
	Filter_BEST_EFFORT     Filter_FieldEventMode = 1
)

// Enum value maps for Filter_FieldEventMode.
var (
	Filter_FieldEventMode_name = map[int32]string{
		0: "ERR_ON_MISMATCH",
		1: "BEST_EFFORT",
	}
	Filter_FieldEventMode_value = map[string]int32{
		"ERR_ON_MISMATCH": 0,
		"BEST_EFFORT":     1,
	}
)

func (x Filter_FieldEventMode) Enum() *Filter_FieldEventMode {
	p := new(Filter_FieldEventMode)
	*p = x
	return p
}

func (x Filter_FieldEventMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Filter_FieldEventMode) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_binlogdata_proto_enumTypes[4].Descriptor()
}

func (Filter_FieldEventMode) Type() protoreflect.EnumType {
	return &file_dolthub_vt_binlogdata_proto_enumTypes[4]
}

func (x Filter_FieldEventMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Filter_FieldEventMode.Descriptor instead.
func (Filter_FieldEventMode) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{7, 0}
}

// Charset is the per-statement charset info from a QUERY_EVENT binlog entry.
type Charset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @@session.character_set_client
	Client int32 `protobuf:"varint,1,opt,name=client,proto3" json:"client,omitempty"`
	// @@session.collation_connection
	Conn int32 `protobuf:"varint,2,opt,name=conn,proto3" json:"conn,omitempty"`
	// @@session.collation_server
	Server int32 `protobuf:"varint,3,opt,name=server,proto3" json:"server,omitempty"`
}

func (x *Charset) Reset() {
	*x = Charset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Charset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Charset) ProtoMessage() {}

func (x *Charset) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Charset.ProtoReflect.Descriptor instead.
func (*Charset) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{0}
}

func (x *Charset) GetClient() int32 {
	if x != nil {
		return x.Client
	}
	return 0
}

func (x *Charset) GetConn() int32 {
	if x != nil {
		return x.Conn
	}
	return 0
}

func (x *Charset) GetServer() int32 {
	if x != nil {
		return x.Server
	}
	return 0
}

// BinlogTransaction describes a transaction inside the binlogs.
// It is streamed by vttablet for filtered replication, used during resharding.
type BinlogTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the statements in this transaction
	Statements []*BinlogTransaction_Statement `protobuf:"bytes,1,rep,name=statements,proto3" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken *query.EventToken `protobuf:"bytes,4,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
}

func (x *BinlogTransaction) Reset() {
	*x = BinlogTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinlogTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinlogTransaction) ProtoMessage() {}

func (x *BinlogTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinlogTransaction.ProtoReflect.Descriptor instead.
func (*BinlogTransaction) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{1}
}

func (x *BinlogTransaction) GetStatements() []*BinlogTransaction_Statement {
	if x != nil {
		return x.Statements
	}
	return nil
}

func (x *BinlogTransaction) GetEventToken() *query.EventToken {
	if x != nil {
		return x.EventToken
	}
	return nil
}

// StreamKeyRangeRequest is the payload to StreamKeyRange
type StreamKeyRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// where to start
	Position string `protobuf:"bytes,1,opt,name=position,proto3" json:"position,omitempty"`
	// what to get
	KeyRange *topodata.KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// default charset on the player side
	Charset *Charset `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
}

func (x *StreamKeyRangeRequest) Reset() {
	*x = StreamKeyRangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamKeyRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamKeyRangeRequest) ProtoMessage() {}

func (x *StreamKeyRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamKeyRangeRequest.ProtoReflect.Descriptor instead.
func (*StreamKeyRangeRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{2}
}

func (x *StreamKeyRangeRequest) GetPosition() string {
	if x != nil {
		return x.Position
	}
	return ""
}

func (x *StreamKeyRangeRequest) GetKeyRange() *topodata.KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *StreamKeyRangeRequest) GetCharset() *Charset {
	if x != nil {
		return x.Charset
	}
	return nil
}

// StreamKeyRangeResponse is the response from StreamKeyRange
type StreamKeyRangeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BinlogTransaction *BinlogTransaction `protobuf:"bytes,1,opt,name=binlog_transaction,json=binlogTransaction,proto3" json:"binlog_transaction,omitempty"`
}

func (x *StreamKeyRangeResponse) Reset() {
	*x = StreamKeyRangeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamKeyRangeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamKeyRangeResponse) ProtoMessage() {}

func (x *StreamKeyRangeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamKeyRangeResponse.ProtoReflect.Descriptor instead.
func (*StreamKeyRangeResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{3}
}

func (x *StreamKeyRangeResponse) GetBinlogTransaction() *BinlogTransaction {
	if x != nil {
		return x.BinlogTransaction
	}
	return nil
}

// StreamTablesRequest is the payload to StreamTables
type StreamTablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// where to start
	Position string `protobuf:"bytes,1,opt,name=position,proto3" json:"position,omitempty"`
	// what to get
	Tables []string `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
	// default charset on the player side
	Charset *Charset `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
}

func (x *StreamTablesRequest) Reset() {
	*x = StreamTablesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamTablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamTablesRequest) ProtoMessage() {}

func (x *StreamTablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamTablesRequest.ProtoReflect.Descriptor instead.
func (*StreamTablesRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{4}
}

func (x *StreamTablesRequest) GetPosition() string {
	if x != nil {
		return x.Position
	}
	return ""
}

func (x *StreamTablesRequest) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *StreamTablesRequest) GetCharset() *Charset {
	if x != nil {
		return x.Charset
	}
	return nil
}

// StreamTablesResponse is the response from StreamTables
type StreamTablesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BinlogTransaction *BinlogTransaction `protobuf:"bytes,1,opt,name=binlog_transaction,json=binlogTransaction,proto3" json:"binlog_transaction,omitempty"`
}

func (x *StreamTablesResponse) Reset() {
	*x = StreamTablesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamTablesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamTablesResponse) ProtoMessage() {}

func (x *StreamTablesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamTablesResponse.ProtoReflect.Descriptor instead.
func (*StreamTablesResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{5}
}

func (x *StreamTablesResponse) GetBinlogTransaction() *BinlogTransaction {
	if x != nil {
		return x.BinlogTransaction
	}
	return nil
}

// Rule represents one rule.
type Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// match can be a table name or a regular expression
	// delineated by '/' and '/'.
	Match string `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// filter can be an empty string or keyrange if the match
	// is a regular expression. Otherwise, it must be a select
	// query.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *Rule) Reset() {
	*x = Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{6}
}

func (x *Rule) GetMatch() string {
	if x != nil {
		return x.Match
	}
	return ""
}

func (x *Rule) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Filter represents a list of ordered rules. First match
// wins.
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rules          []*Rule               `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	FieldEventMode Filter_FieldEventMode `protobuf:"varint,2,opt,name=fieldEventMode,proto3,enum=dolthub.vt.binlogdata.Filter_FieldEventMode" json:"fieldEventMode,omitempty"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{7}
}

func (x *Filter) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *Filter) GetFieldEventMode() Filter_FieldEventMode {
	if x != nil {
		return x.FieldEventMode
	}
	return Filter_ERR_ON_MISMATCH
}

// BinlogSource specifies the source  and filter parameters for
// Filtered Replication. It currently supports a keyrange
// or a list of tables.
type BinlogSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the source keyspace
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	// the source tablet type
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// key_range is set if the request is for a keyrange
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// tables is set if the request is for a list of tables
	Tables []string `protobuf:"bytes,5,rep,name=tables,proto3" json:"tables,omitempty"`
	// filter is set if we're using the generalized representation
	// for the filter.
	Filter *Filter `protobuf:"bytes,6,opt,name=filter,proto3" json:"filter,omitempty"`
	// on_ddl specifies the action to be taken when a DDL is encountered.
	OnDdl OnDDLAction `protobuf:"varint,7,opt,name=on_ddl,json=onDdl,proto3,enum=dolthub.vt.binlogdata.OnDDLAction" json:"on_ddl,omitempty"`
	// Source is an external mysql. This attribute should be set to the username
	// to use in the connection
	ExternalMysql string `protobuf:"bytes,8,opt,name=external_mysql,json=externalMysql,proto3" json:"external_mysql,omitempty"`
}

func (x *BinlogSource) Reset() {
	*x = BinlogSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinlogSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinlogSource) ProtoMessage() {}

func (x *BinlogSource) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinlogSource.ProtoReflect.Descriptor instead.
func (*BinlogSource) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{8}
}

func (x *BinlogSource) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *BinlogSource) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *BinlogSource) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *BinlogSource) GetKeyRange() *topodata.KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *BinlogSource) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *BinlogSource) GetFilter() *Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *BinlogSource) GetOnDdl() OnDDLAction {
	if x != nil {
		return x.OnDdl
	}
	return OnDDLAction_IGNORE
}

func (x *BinlogSource) GetExternalMysql() string {
	if x != nil {
		return x.ExternalMysql
	}
	return ""
}

// RowChange represents one row change
type RowChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Before *query.Row `protobuf:"bytes,1,opt,name=before,proto3" json:"before,omitempty"`
	After  *query.Row `protobuf:"bytes,2,opt,name=after,proto3" json:"after,omitempty"`
}

func (x *RowChange) Reset() {
	*x = RowChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RowChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RowChange) ProtoMessage() {}

func (x *RowChange) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RowChange.ProtoReflect.Descriptor instead.
func (*RowChange) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{9}
}

func (x *RowChange) GetBefore() *query.Row {
	if x != nil {
		return x.Before
	}
	return nil
}

func (x *RowChange) GetAfter() *query.Row {
	if x != nil {
		return x.After
	}
	return nil
}

// RowEvent represent row events for one table
type RowEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TableName  string       `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	RowChanges []*RowChange `protobuf:"bytes,2,rep,name=row_changes,json=rowChanges,proto3" json:"row_changes,omitempty"`
}

func (x *RowEvent) Reset() {
	*x = RowEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RowEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RowEvent) ProtoMessage() {}

func (x *RowEvent) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RowEvent.ProtoReflect.Descriptor instead.
func (*RowEvent) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{10}
}

func (x *RowEvent) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *RowEvent) GetRowChanges() []*RowChange {
	if x != nil {
		return x.RowChanges
	}
	return nil
}

type FieldEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TableName string         `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	Fields    []*query.Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *FieldEvent) Reset() {
	*x = FieldEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldEvent) ProtoMessage() {}

func (x *FieldEvent) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldEvent.ProtoReflect.Descriptor instead.
func (*FieldEvent) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{11}
}

func (x *FieldEvent) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *FieldEvent) GetFields() []*query.Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

type ShardGtid struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard    string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	Gtid     string `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
}

func (x *ShardGtid) Reset() {
	*x = ShardGtid{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardGtid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardGtid) ProtoMessage() {}

func (x *ShardGtid) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardGtid.ProtoReflect.Descriptor instead.
func (*ShardGtid) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{12}
}

func (x *ShardGtid) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *ShardGtid) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *ShardGtid) GetGtid() string {
	if x != nil {
		return x.Gtid
	}
	return ""
}

type VGtid struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ShardGtids []*ShardGtid `protobuf:"bytes,1,rep,name=shard_gtids,json=shardGtids,proto3" json:"shard_gtids,omitempty"`
}

func (x *VGtid) Reset() {
	*x = VGtid{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VGtid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VGtid) ProtoMessage() {}

func (x *VGtid) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VGtid.ProtoReflect.Descriptor instead.
func (*VGtid) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{13}
}

func (x *VGtid) GetShardGtids() []*ShardGtid {
	if x != nil {
		return x.ShardGtids
	}
	return nil
}

type KeyspaceShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard    string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
}

func (x *KeyspaceShard) Reset() {
	*x = KeyspaceShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyspaceShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyspaceShard) ProtoMessage() {}

func (x *KeyspaceShard) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyspaceShard.ProtoReflect.Descriptor instead.
func (*KeyspaceShard) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{14}
}

func (x *KeyspaceShard) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *KeyspaceShard) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

type Journal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id              int64            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	MigrationType   MigrationType    `protobuf:"varint,2,opt,name=migration_type,json=migrationType,proto3,enum=dolthub.vt.binlogdata.MigrationType" json:"migration_type,omitempty"`
	Tables          []string         `protobuf:"bytes,3,rep,name=tables,proto3" json:"tables,omitempty"`
	LocalPosition   string           `protobuf:"bytes,4,opt,name=local_position,json=localPosition,proto3" json:"local_position,omitempty"`
	ShardGtids      []*ShardGtid     `protobuf:"bytes,5,rep,name=shard_gtids,json=shardGtids,proto3" json:"shard_gtids,omitempty"`
	Participants    []*KeyspaceShard `protobuf:"bytes,6,rep,name=participants,proto3" json:"participants,omitempty"`
	SourceWorkflows []string         `protobuf:"bytes,7,rep,name=source_workflows,json=sourceWorkflows,proto3" json:"source_workflows,omitempty"`
}

func (x *Journal) Reset() {
	*x = Journal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Journal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Journal) ProtoMessage() {}

func (x *Journal) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Journal.ProtoReflect.Descriptor instead.
func (*Journal) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{15}
}

func (x *Journal) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Journal) GetMigrationType() MigrationType {
	if x != nil {
		return x.MigrationType
	}
	return MigrationType_TABLES
}

func (x *Journal) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *Journal) GetLocalPosition() string {
	if x != nil {
		return x.LocalPosition
	}
	return ""
}

func (x *Journal) GetShardGtids() []*ShardGtid {
	if x != nil {
		return x.ShardGtids
	}
	return nil
}

func (x *Journal) GetParticipants() []*KeyspaceShard {
	if x != nil {
		return x.Participants
	}
	return nil
}

func (x *Journal) GetSourceWorkflows() []string {
	if x != nil {
		return x.SourceWorkflows
	}
	return nil
}

// VEvent represents a vstream event
type VEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type       VEventType  `protobuf:"varint,1,opt,name=type,proto3,enum=dolthub.vt.binlogdata.VEventType" json:"type,omitempty"`
	Timestamp  int64       `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Gtid       string      `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Ddl        string      `protobuf:"bytes,4,opt,name=ddl,proto3" json:"ddl,omitempty"`
	RowEvent   *RowEvent   `protobuf:"bytes,5,opt,name=row_event,json=rowEvent,proto3" json:"row_event,omitempty"`
	FieldEvent *FieldEvent `protobuf:"bytes,6,opt,name=field_event,json=fieldEvent,proto3" json:"field_event,omitempty"`
	Vgtid      *VGtid      `protobuf:"bytes,7,opt,name=vgtid,proto3" json:"vgtid,omitempty"`
	Journal    *Journal    `protobuf:"bytes,8,opt,name=journal,proto3" json:"journal,omitempty"`
	Dml        string      `protobuf:"bytes,9,opt,name=dml,proto3" json:"dml,omitempty"`
	// current_time specifies the current time to handle clock skew.
	CurrentTime int64 `protobuf:"varint,20,opt,name=current_time,json=currentTime,proto3" json:"current_time,omitempty"`
}

func (x *VEvent) Reset() {
	*x = VEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VEvent) ProtoMessage() {}

func (x *VEvent) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VEvent.ProtoReflect.Descriptor instead.
func (*VEvent) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{16}
}

func (x *VEvent) GetType() VEventType {
	if x != nil {
		return x.Type
	}
	return VEventType_UNKNOWN
}

func (x *VEvent) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *VEvent) GetGtid() string {
	if x != nil {
		return x.Gtid
	}
	return ""
}

func (x *VEvent) GetDdl() string {
	if x != nil {
		return x.Ddl
	}
	return ""
}

func (x *VEvent) GetRowEvent() *RowEvent {
	if x != nil {
		return x.RowEvent
	}
	return nil
}

func (x *VEvent) GetFieldEvent() *FieldEvent {
	if x != nil {
		return x.FieldEvent
	}
	return nil
}

func (x *VEvent) GetVgtid() *VGtid {
	if x != nil {
		return x.Vgtid
	}
	return nil
}

func (x *VEvent) GetJournal() *Journal {
	if x != nil {
		return x.Journal
	}
	return nil
}

func (x *VEvent) GetDml() string {
	if x != nil {
		return x.Dml
	}
	return ""
}

func (x *VEvent) GetCurrentTime() int64 {
	if x != nil {
		return x.CurrentTime
	}
	return 0
}

// VStreamRequest is the payload for VStream
type VStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Position          string                `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	Filter            *Filter               `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *VStreamRequest) Reset() {
	*x = VStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamRequest) ProtoMessage() {}

func (x *VStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamRequest.ProtoReflect.Descriptor instead.
func (*VStreamRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{17}
}

func (x *VStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *VStreamRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *VStreamRequest) GetTarget() *query.Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *VStreamRequest) GetPosition() string {
	if x != nil {
		return x.Position
	}
	return ""
}

func (x *VStreamRequest) GetFilter() *Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// VStreamResponse is the response from VStream
type VStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Events []*VEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *VStreamResponse) Reset() {
	*x = VStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamResponse) ProtoMessage() {}

func (x *VStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamResponse.ProtoReflect.Descriptor instead.
func (*VStreamResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{18}
}

func (x *VStreamResponse) GetEvents() []*VEvent {
	if x != nil {
		return x.Events
	}
	return nil
}

// VStreamRowsRequest is the payload for VStreamRows
type VStreamRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             string                `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Lastpk            *query.QueryResult    `protobuf:"bytes,5,opt,name=lastpk,proto3" json:"lastpk,omitempty"`
}

func (x *VStreamRowsRequest) Reset() {
	*x = VStreamRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamRowsRequest) ProtoMessage() {}

func (x *VStreamRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamRowsRequest.ProtoReflect.Descriptor instead.
func (*VStreamRowsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{19}
}

func (x *VStreamRowsRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *VStreamRowsRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *VStreamRowsRequest) GetTarget() *query.Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *VStreamRowsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *VStreamRowsRequest) GetLastpk() *query.QueryResult {
	if x != nil {
		return x.Lastpk
	}
	return nil
}

// VStreamRowsResponse is the response from VStreamRows
type VStreamRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fields   []*query.Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	Pkfields []*query.Field `protobuf:"bytes,2,rep,name=pkfields,proto3" json:"pkfields,omitempty"`
	Gtid     string         `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Rows     []*query.Row   `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	Lastpk   *query.Row     `protobuf:"bytes,5,opt,name=lastpk,proto3" json:"lastpk,omitempty"`
}

func (x *VStreamRowsResponse) Reset() {
	*x = VStreamRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamRowsResponse) ProtoMessage() {}

func (x *VStreamRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamRowsResponse.ProtoReflect.Descriptor instead.
func (*VStreamRowsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{20}
}

func (x *VStreamRowsResponse) GetFields() []*query.Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *VStreamRowsResponse) GetPkfields() []*query.Field {
	if x != nil {
		return x.Pkfields
	}
	return nil
}

func (x *VStreamRowsResponse) GetGtid() string {
	if x != nil {
		return x.Gtid
	}
	return ""
}

func (x *VStreamRowsResponse) GetRows() []*query.Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *VStreamRowsResponse) GetLastpk() *query.Row {
	if x != nil {
		return x.Lastpk
	}
	return nil
}

// VStreamResultsRequest is the payload for VStreamResults
// The ids match VStreamRows, in case we decide to merge the two.
type VStreamResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             string                `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *VStreamResultsRequest) Reset() {
	*x = VStreamResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamResultsRequest) ProtoMessage() {}

func (x *VStreamResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamResultsRequest.ProtoReflect.Descriptor instead.
func (*VStreamResultsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{21}
}

func (x *VStreamResultsRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *VStreamResultsRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *VStreamResultsRequest) GetTarget() *query.Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *VStreamResultsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// VStreamResultsResponse is the response from VStreamResults
// The ids match VStreamRows, in case we decide to merge the two.
type VStreamResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fields []*query.Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	Gtid   string         `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Rows   []*query.Row   `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *VStreamResultsResponse) Reset() {
	*x = VStreamResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamResultsResponse) ProtoMessage() {}

func (x *VStreamResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamResultsResponse.ProtoReflect.Descriptor instead.
func (*VStreamResultsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{22}
}

func (x *VStreamResultsResponse) GetFields() []*query.Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *VStreamResultsResponse) GetGtid() string {
	if x != nil {
		return x.Gtid
	}
	return ""
}

func (x *VStreamResultsResponse) GetRows() []*query.Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

type BinlogTransaction_Statement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// what type of statement is this?
	Category BinlogTransaction_Statement_Category `protobuf:"varint,1,opt,name=category,proto3,enum=dolthub.vt.binlogdata.BinlogTransaction_Statement_Category" json:"category,omitempty"`
	// charset of this statement, if different from pre-negotiated default.
	Charset *Charset `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// the sql
	Sql []byte `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (x *BinlogTransaction_Statement) Reset() {
	*x = BinlogTransaction_Statement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_binlogdata_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinlogTransaction_Statement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinlogTransaction_Statement) ProtoMessage() {}

func (x *BinlogTransaction_Statement) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_binlogdata_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinlogTransaction_Statement.ProtoReflect.Descriptor instead.
func (*BinlogTransaction_Statement) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_binlogdata_proto_rawDescGZIP(), []int{1, 0}
}

func (x *BinlogTransaction_Statement) GetCategory() BinlogTransaction_Statement_Category {
	if x != nil {
		return x.Category
	}
	return BinlogTransaction_Statement_BL_UNRECOGNIZED
}

func (x *BinlogTransaction_Statement) GetCharset() *Charset {
	if x != nil {
		return x.Charset
	}
	return nil
}

func (x *BinlogTransaction_Statement) GetSql() []byte {
	if x != nil {
		return x.Sql
	}
	return nil
}

var File_dolthub_vt_binlogdata_proto protoreflect.FileDescriptor

var file_dolthub_vt_binlogdata_proto_rawDesc = []byte{
	0x0a, 0x1b, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x62, 0x69, 0x6e,
	0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67,
	0x64, 0x61, 0x74, 0x61, 0x1a, 0x16, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74,
	0x2f, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74,
	0x2f, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x4d, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x6e, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x04, 0x63, 0x6f, 0x6e, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x22, 0x91,
	0x04, 0x0a, 0x11, 0x42, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x42, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0xdc, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x42, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x38,
	0x0a, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e,
	0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x52,
	0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x22, 0xa9, 0x01, 0x0a, 0x08, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x4c, 0x5f, 0x55, 0x4e,
	0x52, 0x45, 0x43, 0x4f, 0x47, 0x4e, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x42, 0x4c, 0x5f, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c,
	0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x4c, 0x5f,
	0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x4c,
	0x5f, 0x44, 0x4d, 0x4c, 0x5f, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x4c, 0x5f, 0x44, 0x44, 0x4c, 0x10, 0x05, 0x12, 0x0a, 0x0a,
	0x06, 0x42, 0x4c, 0x5f, 0x53, 0x45, 0x54, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x5f,
	0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x5f, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x5f, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x10, 0x09, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x03,
	0x10, 0x04, 0x22, 0xa9, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4b, 0x65, 0x79,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x68,
	0x61, 0x72, 0x73, 0x65, 0x74, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x22, 0x71,
	0x0a, 0x16, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x62, 0x69, 0x6e, 0x6c,
	0x6f, 0x67, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x6e,
	0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11,
	0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x83, 0x01, 0x0a, 0x13, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x38, 0x0a,
	0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c,
	0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x52, 0x07,
	0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x22, 0x6f, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x57, 0x0a, 0x12, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x34, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc9,
	0x01, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x31, 0x0a, 0x05, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x0e,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x52, 0x0e, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x22, 0x36, 0x0a, 0x0e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x52, 0x52, 0x5f, 0x4f, 0x4e, 0x5f, 0x4d,
	0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x53,
	0x54, 0x5f, 0x45, 0x46, 0x46, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x22, 0xef, 0x02, 0x0a, 0x0c, 0x42,
	0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x40, 0x0a,
	0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x3a, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x12, 0x35, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x6e,
	0x5f, 0x64, 0x64, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x44, 0x44, 0x4c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05,
	0x6f, 0x6e, 0x44, 0x64, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x22, 0x67, 0x0a, 0x09,
	0x52, 0x6f, 0x77, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x62, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x6f, 0x77,
	0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x61, 0x66, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x05,
	0x61, 0x66, 0x74, 0x65, 0x72, 0x22, 0x6c, 0x0a, 0x08, 0x52, 0x6f, 0x77, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x41, 0x0a, 0x0b, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f,
	0x77, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a, 0x72, 0x6f, 0x77, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x22, 0x5c, 0x0a, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2f, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x22, 0x51, 0x0a, 0x09, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x74, 0x69, 0x64, 0x12, 0x1a,
	0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x67, 0x74, 0x69, 0x64, 0x22, 0x4a, 0x0a, 0x05, 0x56, 0x47, 0x74, 0x69, 0x64, 0x12, 0x41, 0x0a,
	0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x67, 0x74, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x47, 0x74, 0x69, 0x64, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x47, 0x74, 0x69, 0x64, 0x73,
	0x22, 0x41, 0x0a, 0x0d, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x22, 0xdd, 0x02, 0x0a, 0x07, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x4b, 0x0a, 0x0e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x0b, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x5f, 0x67, 0x74, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69,
	0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x74,
	0x69, 0x64, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x47, 0x74, 0x69, 0x64, 0x73, 0x12, 0x48,
	0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x73, 0x22, 0xa8, 0x03, 0x0a, 0x06, 0x56, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x35,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x56, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x67, 0x74, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x64, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x64, 0x64, 0x6c, 0x12, 0x3c, 0x0a, 0x09, 0x72, 0x6f, 0x77,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x72,
	0x6f, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x76,
	0x67, 0x74, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x56, 0x47, 0x74, 0x69, 0x64, 0x52, 0x05, 0x76, 0x67, 0x74, 0x69, 0x64, 0x12,
	0x38, 0x0a, 0x07, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69,
	0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c,
	0x52, 0x07, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x6d, 0x6c,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x64, 0x6d, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb3,
	0x02, 0x0a, 0x0e, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70,
	0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a,
	0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54,
	0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f,
	0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0x48, 0x0a, 0x0f, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x56, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xb1,
	0x02, 0x0a, 0x12, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44,
	0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x06, 0x6c,
	0x61, 0x73, 0x74, 0x70, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x73, 0x74,
	0x70, 0x6b, 0x22, 0xe9, 0x01, 0x0a, 0x13, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x33, 0x0a, 0x08, 0x70,
	0x6b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x08, 0x70, 0x6b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x67, 0x74, 0x69, 0x64, 0x12, 0x29, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12,
	0x2d, 0x0a, 0x06, 0x6c, 0x61, 0x73, 0x74, 0x70, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x06, 0x6c, 0x61, 0x73, 0x74, 0x70, 0x6b, 0x22, 0xfd,
	0x01, 0x0a, 0x15, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x88,
	0x01, 0x0a, 0x16, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x74,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x67, 0x74, 0x69, 0x64, 0x12, 0x29,
	0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x2a, 0x3e, 0x0a, 0x0b, 0x4f, 0x6e, 0x44,
	0x44, 0x4c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x47, 0x4e, 0x4f,
	0x52, 0x45, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x45, 0x58, 0x45, 0x43, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x58, 0x45, 0x43,
	0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x10, 0x03, 0x2a, 0xd1, 0x01, 0x0a, 0x0a, 0x56, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x54, 0x49, 0x44, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f,
	0x4d, 0x4d, 0x49, 0x54, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41,
	0x43, 0x4b, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x44, 0x4c, 0x10, 0x05, 0x12, 0x0a, 0x0a,
	0x06, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x50,
	0x4c, 0x41, 0x43, 0x45, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45,
	0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x09, 0x12, 0x07,
	0x0a, 0x03, 0x53, 0x45, 0x54, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52,
	0x10, 0x0b, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x4f, 0x57, 0x10, 0x0c, 0x12, 0x09, 0x0a, 0x05, 0x46,
	0x49, 0x45, 0x4c, 0x44, 0x10, 0x0d, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x45, 0x41, 0x52, 0x54, 0x42,
	0x45, 0x41, 0x54, 0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x47, 0x54, 0x49, 0x44, 0x10, 0x0f,
	0x12, 0x0b, 0x0a, 0x07, 0x4a, 0x4f, 0x55, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x10, 0x2a, 0x27, 0x0a,
	0x0d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a,
	0x0a, 0x06, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x53, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48,
	0x41, 0x52, 0x44, 0x53, 0x10, 0x01, 0x42, 0x32, 0x5a, 0x30, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x69, 0x74,
	0x65, 0x73, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_dolthub_vt_binlogdata_proto_rawDescOnce sync.Once
	file_dolthub_vt_binlogdata_proto_rawDescData = file_dolthub_vt_binlogdata_proto_rawDesc
)

func file_dolthub_vt_binlogdata_proto_rawDescGZIP() []byte {
	file_dolthub_vt_binlogdata_proto_rawDescOnce.Do(func() {
		file_dolthub_vt_binlogdata_proto_rawDescData = protoimpl.X.CompressGZIP(file_dolthub_vt_binlogdata_proto_rawDescData)
	})
	return file_dolthub_vt_binlogdata_proto_rawDescData
}

var file_dolthub_vt_binlogdata_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_dolthub_vt_binlogdata_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_dolthub_vt_binlogdata_proto_goTypes = []interface{}{
	(OnDDLAction)(0),   // 0: dolthub.vt.binlogdata.OnDDLAction
	(VEventType)(0),    // 1: dolthub.vt.binlogdata.VEventType
	(MigrationType)(0), // 2: dolthub.vt.binlogdata.MigrationType
	(BinlogTransaction_Statement_Category)(0), // 3: dolthub.vt.binlogdata.BinlogTransaction.Statement.Category
	(Filter_FieldEventMode)(0),                // 4: dolthub.vt.binlogdata.Filter.FieldEventMode
	(*Charset)(nil),                           // 5: dolthub.vt.binlogdata.Charset
	(*BinlogTransaction)(nil),                 // 6: dolthub.vt.binlogdata.BinlogTransaction
	(*StreamKeyRangeRequest)(nil),             // 7: dolthub.vt.binlogdata.StreamKeyRangeRequest
	(*StreamKeyRangeResponse)(nil),            // 8: dolthub.vt.binlogdata.StreamKeyRangeResponse
	(*StreamTablesRequest)(nil),               // 9: dolthub.vt.binlogdata.StreamTablesRequest
	(*StreamTablesResponse)(nil),              // 10: dolthub.vt.binlogdata.StreamTablesResponse
	(*Rule)(nil),                              // 11: dolthub.vt.binlogdata.Rule
	(*Filter)(nil),                            // 12: dolthub.vt.binlogdata.Filter
	(*BinlogSource)(nil),                      // 13: dolthub.vt.binlogdata.BinlogSource
	(*RowChange)(nil),                         // 14: dolthub.vt.binlogdata.RowChange
	(*RowEvent)(nil),                          // 15: dolthub.vt.binlogdata.RowEvent
	(*FieldEvent)(nil),                        // 16: dolthub.vt.binlogdata.FieldEvent
	(*ShardGtid)(nil),                         // 17: dolthub.vt.binlogdata.ShardGtid
	(*VGtid)(nil),                             // 18: dolthub.vt.binlogdata.VGtid
	(*KeyspaceShard)(nil),                     // 19: dolthub.vt.binlogdata.KeyspaceShard
	(*Journal)(nil),                           // 20: dolthub.vt.binlogdata.Journal
	(*VEvent)(nil),                            // 21: dolthub.vt.binlogdata.VEvent
	(*VStreamRequest)(nil),                    // 22: dolthub.vt.binlogdata.VStreamRequest
	(*VStreamResponse)(nil),                   // 23: dolthub.vt.binlogdata.VStreamResponse
	(*VStreamRowsRequest)(nil),                // 24: dolthub.vt.binlogdata.VStreamRowsRequest
	(*VStreamRowsResponse)(nil),               // 25: dolthub.vt.binlogdata.VStreamRowsResponse
	(*VStreamResultsRequest)(nil),             // 26: dolthub.vt.binlogdata.VStreamResultsRequest
	(*VStreamResultsResponse)(nil),            // 27: dolthub.vt.binlogdata.VStreamResultsResponse
	(*BinlogTransaction_Statement)(nil),       // 28: dolthub.vt.binlogdata.BinlogTransaction.Statement
	(*query.EventToken)(nil),                  // 29: dolthub.vt.query.EventToken
	(*topodata.KeyRange)(nil),                 // 30: dolthub.vt.topodata.KeyRange
	(topodata.TabletType)(0),                  // 31: dolthub.vt.topodata.TabletType
	(*query.Row)(nil),                         // 32: dolthub.vt.query.Row
	(*query.Field)(nil),                       // 33: dolthub.vt.query.Field
	(*vtrpc.CallerID)(nil),                    // 34: dolthub.vt.vtrpc.CallerID
	(*query.VTGateCallerID)(nil),              // 35: dolthub.vt.query.VTGateCallerID
	(*query.Target)(nil),                      // 36: dolthub.vt.query.Target
	(*query.QueryResult)(nil),                 // 37: dolthub.vt.query.QueryResult
}
var file_dolthub_vt_binlogdata_proto_depIdxs = []int32{
	28, // 0: dolthub.vt.binlogdata.BinlogTransaction.statements:type_name -> dolthub.vt.binlogdata.BinlogTransaction.Statement
	29, // 1: dolthub.vt.binlogdata.BinlogTransaction.event_token:type_name -> dolthub.vt.query.EventToken
	30, // 2: dolthub.vt.binlogdata.StreamKeyRangeRequest.key_range:type_name -> dolthub.vt.topodata.KeyRange
	5,  // 3: dolthub.vt.binlogdata.StreamKeyRangeRequest.charset:type_name -> dolthub.vt.binlogdata.Charset
	6,  // 4: dolthub.vt.binlogdata.StreamKeyRangeResponse.binlog_transaction:type_name -> dolthub.vt.binlogdata.BinlogTransaction
	5,  // 5: dolthub.vt.binlogdata.StreamTablesRequest.charset:type_name -> dolthub.vt.binlogdata.Charset
	6,  // 6: dolthub.vt.binlogdata.StreamTablesResponse.binlog_transaction:type_name -> dolthub.vt.binlogdata.BinlogTransaction
	11, // 7: dolthub.vt.binlogdata.Filter.rules:type_name -> dolthub.vt.binlogdata.Rule
	4,  // 8: dolthub.vt.binlogdata.Filter.fieldEventMode:type_name -> dolthub.vt.binlogdata.Filter.FieldEventMode
	31, // 9: dolthub.vt.binlogdata.BinlogSource.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	30, // 10: dolthub.vt.binlogdata.BinlogSource.key_range:type_name -> dolthub.vt.topodata.KeyRange
	12, // 11: dolthub.vt.binlogdata.BinlogSource.filter:type_name -> dolthub.vt.binlogdata.Filter
	0,  // 12: dolthub.vt.binlogdata.BinlogSource.on_ddl:type_name -> dolthub.vt.binlogdata.OnDDLAction
	32, // 13: dolthub.vt.binlogdata.RowChange.before:type_name -> dolthub.vt.query.Row
	32, // 14: dolthub.vt.binlogdata.RowChange.after:type_name -> dolthub.vt.query.Row
	14, // 15: dolthub.vt.binlogdata.RowEvent.row_changes:type_name -> dolthub.vt.binlogdata.RowChange
	33, // 16: dolthub.vt.binlogdata.FieldEvent.fields:type_name -> dolthub.vt.query.Field
	17, // 17: dolthub.vt.binlogdata.VGtid.shard_gtids:type_name -> dolthub.vt.binlogdata.ShardGtid
	2,  // 18: dolthub.vt.binlogdata.Journal.migration_type:type_name -> dolthub.vt.binlogdata.MigrationType
	17, // 19: dolthub.vt.binlogdata.Journal.shard_gtids:type_name -> dolthub.vt.binlogdata.ShardGtid
	19, // 20: dolthub.vt.binlogdata.Journal.participants:type_name -> dolthub.vt.binlogdata.KeyspaceShard
	1,  // 21: dolthub.vt.binlogdata.VEvent.type:type_name -> dolthub.vt.binlogdata.VEventType
	15, // 22: dolthub.vt.binlogdata.VEvent.row_event:type_name -> dolthub.vt.binlogdata.RowEvent
	16, // 23: dolthub.vt.binlogdata.VEvent.field_event:type_name -> dolthub.vt.binlogdata.FieldEvent
	18, // 24: dolthub.vt.binlogdata.VEvent.vgtid:type_name -> dolthub.vt.binlogdata.VGtid
	20, // 25: dolthub.vt.binlogdata.VEvent.journal:type_name -> dolthub.vt.binlogdata.Journal
	34, // 26: dolthub.vt.binlogdata.VStreamRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	35, // 27: dolthub.vt.binlogdata.VStreamRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	36, // 28: dolthub.vt.binlogdata.VStreamRequest.target:type_name -> dolthub.vt.query.Target
	12, // 29: dolthub.vt.binlogdata.VStreamRequest.filter:type_name -> dolthub.vt.binlogdata.Filter
	21, // 30: dolthub.vt.binlogdata.VStreamResponse.events:type_name -> dolthub.vt.binlogdata.VEvent
	34, // 31: dolthub.vt.binlogdata.VStreamRowsRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	35, // 32: dolthub.vt.binlogdata.VStreamRowsRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	36, // 33: dolthub.vt.binlogdata.VStreamRowsRequest.target:type_name -> dolthub.vt.query.Target
	37, // 34: dolthub.vt.binlogdata.VStreamRowsRequest.lastpk:type_name -> dolthub.vt.query.QueryResult
	33, // 35: dolthub.vt.binlogdata.VStreamRowsResponse.fields:type_name -> dolthub.vt.query.Field
	33, // 36: dolthub.vt.binlogdata.VStreamRowsResponse.pkfields:type_name -> dolthub.vt.query.Field
	32, // 37: dolthub.vt.binlogdata.VStreamRowsResponse.rows:type_name -> dolthub.vt.query.Row
	32, // 38: dolthub.vt.binlogdata.VStreamRowsResponse.lastpk:type_name -> dolthub.vt.query.Row
	34, // 39: dolthub.vt.binlogdata.VStreamResultsRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	35, // 40: dolthub.vt.binlogdata.VStreamResultsRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	36, // 41: dolthub.vt.binlogdata.VStreamResultsRequest.target:type_name -> dolthub.vt.query.Target
	33, // 42: dolthub.vt.binlogdata.VStreamResultsResponse.fields:type_name -> dolthub.vt.query.Field
	32, // 43: dolthub.vt.binlogdata.VStreamResultsResponse.rows:type_name -> dolthub.vt.query.Row
	3,  // 44: dolthub.vt.binlogdata.BinlogTransaction.Statement.category:type_name -> dolthub.vt.binlogdata.BinlogTransaction.Statement.Category
	5,  // 45: dolthub.vt.binlogdata.BinlogTransaction.Statement.charset:type_name -> dolthub.vt.binlogdata.Charset
	46, // [46:46] is the sub-list for method output_type
	46, // [46:46] is the sub-list for method input_type
	46, // [46:46] is the sub-list for extension type_name
	46, // [46:46] is the sub-list for extension extendee
	0,  // [0:46] is the sub-list for field type_name
}

func init() { file_dolthub_vt_binlogdata_proto_init() }
func file_dolthub_vt_binlogdata_proto_init() {
	if File_dolthub_vt_binlogdata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_dolthub_vt_binlogdata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Charset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinlogTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamKeyRangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamKeyRangeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamTablesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamTablesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinlogSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RowChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RowEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardGtid); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VGtid); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyspaceShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Journal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_binlogdata_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinlogTransaction_Statement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_dolthub_vt_binlogdata_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_dolthub_vt_binlogdata_proto_goTypes,
		DependencyIndexes: file_dolthub_vt_binlogdata_proto_depIdxs,
		EnumInfos:         file_dolthub_vt_binlogdata_proto_enumTypes,
		MessageInfos:      file_dolthub_vt_binlogdata_proto_msgTypes,
	}.Build()
	File_dolthub_vt_binlogdata_proto = out.File
	file_dolthub_vt_binlogdata_proto_rawDesc = nil
	file_dolthub_vt_binlogdata_proto_goTypes = nil
	file_dolthub_vt_binlogdata_proto_depIdxs = nil
}
