// Code generated by optgen; DO NOT EDIT.

package memo

import (
	"fmt"
	"strings"

	"github.com/dolthub/go-mysql-server/sql"
	"github.com/dolthub/go-mysql-server/sql/plan"
)

type CrossJoin struct {
	*JoinBase
}

var _ RelExpr = (*CrossJoin)(nil)
var _ JoinRel = (*CrossJoin)(nil)

func (r *CrossJoin) String() string {
	return FormatExpr(r)
}

func (r *CrossJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type InnerJoin struct {
	*JoinBase
}

var _ RelExpr = (*InnerJoin)(nil)
var _ JoinRel = (*InnerJoin)(nil)

func (r *InnerJoin) String() string {
	return FormatExpr(r)
}

func (r *InnerJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type LeftJoin struct {
	*JoinBase
}

var _ RelExpr = (*LeftJoin)(nil)
var _ JoinRel = (*LeftJoin)(nil)

func (r *LeftJoin) String() string {
	return FormatExpr(r)
}

func (r *LeftJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type SemiJoin struct {
	*JoinBase
}

var _ RelExpr = (*SemiJoin)(nil)
var _ JoinRel = (*SemiJoin)(nil)

func (r *SemiJoin) String() string {
	return FormatExpr(r)
}

func (r *SemiJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type AntiJoin struct {
	*JoinBase
}

var _ RelExpr = (*AntiJoin)(nil)
var _ JoinRel = (*AntiJoin)(nil)

func (r *AntiJoin) String() string {
	return FormatExpr(r)
}

func (r *AntiJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type LookupJoin struct {
	*JoinBase
	Lookup    *IndexScan
	Injective bool
}

var _ RelExpr = (*LookupJoin)(nil)
var _ JoinRel = (*LookupJoin)(nil)

func (r *LookupJoin) String() string {
	return FormatExpr(r)
}

func (r *LookupJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type RangeHeapJoin struct {
	*JoinBase
	RangeHeap *RangeHeap
}

var _ RelExpr = (*RangeHeapJoin)(nil)
var _ JoinRel = (*RangeHeapJoin)(nil)

func (r *RangeHeapJoin) String() string {
	return FormatExpr(r)
}

func (r *RangeHeapJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type ConcatJoin struct {
	*JoinBase
	Concat []*IndexScan
}

var _ RelExpr = (*ConcatJoin)(nil)
var _ JoinRel = (*ConcatJoin)(nil)

func (r *ConcatJoin) String() string {
	return FormatExpr(r)
}

func (r *ConcatJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type HashJoin struct {
	*JoinBase
	RightAttrs []sql.Expression
	LeftAttrs  []sql.Expression
}

var _ RelExpr = (*HashJoin)(nil)
var _ JoinRel = (*HashJoin)(nil)

func (r *HashJoin) String() string {
	return FormatExpr(r)
}

func (r *HashJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type MergeJoin struct {
	*JoinBase
	InnerScan *IndexScan
	OuterScan *IndexScan
	SwapCmp   bool
	Injective bool
	CmpCnt    int
}

var _ RelExpr = (*MergeJoin)(nil)
var _ JoinRel = (*MergeJoin)(nil)

func (r *MergeJoin) String() string {
	return FormatExpr(r)
}

func (r *MergeJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type FullOuterJoin struct {
	*JoinBase
}

var _ RelExpr = (*FullOuterJoin)(nil)
var _ JoinRel = (*FullOuterJoin)(nil)

func (r *FullOuterJoin) String() string {
	return FormatExpr(r)
}

func (r *FullOuterJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type LateralJoin struct {
	*JoinBase
}

var _ RelExpr = (*LateralJoin)(nil)
var _ JoinRel = (*LateralJoin)(nil)

func (r *LateralJoin) String() string {
	return FormatExpr(r)
}

func (r *LateralJoin) JoinPrivate() *JoinBase {
	return r.JoinBase
}

type TableScan struct {
	*sourceBase
	Table plan.TableIdNode
}

var _ RelExpr = (*TableScan)(nil)
var _ SourceRel = (*TableScan)(nil)

func (r *TableScan) String() string {
	return FormatExpr(r)
}

func (r *TableScan) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *TableScan) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *TableScan) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *TableScan) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *TableScan) Children() []*ExprGroup {
	return nil
}

type IndexScan struct {
	*sourceBase
	Table *plan.IndexedTableAccess
	Index *Index
	Alias string
	Stats sql.Statistic
}

var _ RelExpr = (*IndexScan)(nil)
var _ SourceRel = (*IndexScan)(nil)

func (r *IndexScan) String() string {
	return FormatExpr(r)
}

func (r *IndexScan) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *IndexScan) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *IndexScan) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *IndexScan) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *IndexScan) Children() []*ExprGroup {
	return nil
}

type Values struct {
	*sourceBase
	Table *plan.ValueDerivedTable
}

var _ RelExpr = (*Values)(nil)
var _ SourceRel = (*Values)(nil)

func (r *Values) String() string {
	return FormatExpr(r)
}

func (r *Values) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *Values) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *Values) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *Values) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *Values) Children() []*ExprGroup {
	return nil
}

type TableAlias struct {
	*sourceBase
	Table *plan.TableAlias
}

var _ RelExpr = (*TableAlias)(nil)
var _ SourceRel = (*TableAlias)(nil)

func (r *TableAlias) String() string {
	return FormatExpr(r)
}

func (r *TableAlias) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *TableAlias) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *TableAlias) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *TableAlias) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *TableAlias) Children() []*ExprGroup {
	return nil
}

type RecursiveTable struct {
	*sourceBase
	Table *plan.RecursiveTable
}

var _ RelExpr = (*RecursiveTable)(nil)
var _ SourceRel = (*RecursiveTable)(nil)

func (r *RecursiveTable) String() string {
	return FormatExpr(r)
}

func (r *RecursiveTable) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *RecursiveTable) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *RecursiveTable) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *RecursiveTable) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *RecursiveTable) Children() []*ExprGroup {
	return nil
}

type RecursiveCte struct {
	*sourceBase
	Table *plan.RecursiveCte
}

var _ RelExpr = (*RecursiveCte)(nil)
var _ SourceRel = (*RecursiveCte)(nil)

func (r *RecursiveCte) String() string {
	return FormatExpr(r)
}

func (r *RecursiveCte) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *RecursiveCte) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *RecursiveCte) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *RecursiveCte) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *RecursiveCte) Children() []*ExprGroup {
	return nil
}

type SubqueryAlias struct {
	*sourceBase
	Table *plan.SubqueryAlias
}

var _ RelExpr = (*SubqueryAlias)(nil)
var _ SourceRel = (*SubqueryAlias)(nil)

func (r *SubqueryAlias) String() string {
	return FormatExpr(r)
}

func (r *SubqueryAlias) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *SubqueryAlias) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *SubqueryAlias) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *SubqueryAlias) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *SubqueryAlias) Children() []*ExprGroup {
	return nil
}

type TableFunc struct {
	*sourceBase
	Table sql.TableFunction
}

var _ RelExpr = (*TableFunc)(nil)
var _ SourceRel = (*TableFunc)(nil)

func (r *TableFunc) String() string {
	return FormatExpr(r)
}

func (r *TableFunc) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *TableFunc) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *TableFunc) TableIdNode() plan.TableIdNode {
	return nil
}

func (r *TableFunc) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *TableFunc) Children() []*ExprGroup {
	return nil
}

type JSONTable struct {
	*sourceBase
	Table *plan.JSONTable
}

var _ RelExpr = (*JSONTable)(nil)
var _ SourceRel = (*JSONTable)(nil)

func (r *JSONTable) String() string {
	return FormatExpr(r)
}

func (r *JSONTable) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *JSONTable) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *JSONTable) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *JSONTable) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *JSONTable) Children() []*ExprGroup {
	return nil
}

type EmptyTable struct {
	*sourceBase
	Table *plan.EmptyTable
}

var _ RelExpr = (*EmptyTable)(nil)
var _ SourceRel = (*EmptyTable)(nil)

func (r *EmptyTable) String() string {
	return FormatExpr(r)
}

func (r *EmptyTable) Name() string {
	return strings.ToLower(r.Table.Name())
}

func (r *EmptyTable) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *EmptyTable) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *EmptyTable) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *EmptyTable) Children() []*ExprGroup {
	return nil
}

type SetOp struct {
	*sourceBase
	Table *plan.SetOp
}

var _ RelExpr = (*SetOp)(nil)
var _ SourceRel = (*SetOp)(nil)

func (r *SetOp) String() string {
	return FormatExpr(r)
}

func (r *SetOp) Name() string {
	return ""
}

func (r *SetOp) TableId() sql.TableId {
	return TableIdForSource(r.g.Id)
}

func (r *SetOp) TableIdNode() plan.TableIdNode {
	return r.Table
}

func (r *SetOp) OutputCols() sql.Schema {
	return r.Table.Schema()
}

func (r *SetOp) Children() []*ExprGroup {
	return nil
}

type Project struct {
	*relBase
	Child       *ExprGroup
	Projections []sql.Expression
}

var _ RelExpr = (*Project)(nil)

func (r *Project) String() string {
	return FormatExpr(r)
}

func (r *Project) Children() []*ExprGroup {
	return []*ExprGroup{r.Child}
}

func (r *Project) outputCols() sql.ColSet {
	return getProjectColset(r)
}

type Distinct struct {
	*relBase
	Child *ExprGroup
}

var _ RelExpr = (*Distinct)(nil)

func (r *Distinct) String() string {
	return FormatExpr(r)
}

func (r *Distinct) Children() []*ExprGroup {
	return []*ExprGroup{r.Child}
}

func (r *Distinct) outputCols() sql.ColSet {
	return r.Child.RelProps.OutputCols()
}

type Max1Row struct {
	*relBase
	Child *ExprGroup
}

var _ RelExpr = (*Max1Row)(nil)

func (r *Max1Row) String() string {
	return FormatExpr(r)
}

func (r *Max1Row) Children() []*ExprGroup {
	return []*ExprGroup{r.Child}
}

func (r *Max1Row) outputCols() sql.ColSet {
	return r.Child.RelProps.OutputCols()
}

type Filter struct {
	*relBase
	Child   *ExprGroup
	Filters []sql.Expression
}

var _ RelExpr = (*Filter)(nil)

func (r *Filter) String() string {
	return FormatExpr(r)
}

func (r *Filter) Children() []*ExprGroup {
	return []*ExprGroup{r.Child}
}

func (r *Filter) outputCols() sql.ColSet {
	return r.Child.RelProps.OutputCols()
}

func FormatExpr(r exprType) string {
	switch r := r.(type) {
	case *CrossJoin:
		return fmt.Sprintf("crossjoin %d %d", r.Left.Id, r.Right.Id)
	case *InnerJoin:
		return fmt.Sprintf("innerjoin %d %d", r.Left.Id, r.Right.Id)
	case *LeftJoin:
		return fmt.Sprintf("leftjoin %d %d", r.Left.Id, r.Right.Id)
	case *SemiJoin:
		return fmt.Sprintf("semijoin %d %d", r.Left.Id, r.Right.Id)
	case *AntiJoin:
		return fmt.Sprintf("antijoin %d %d", r.Left.Id, r.Right.Id)
	case *LookupJoin:
		return fmt.Sprintf("lookupjoin %d %d", r.Left.Id, r.Right.Id)
	case *RangeHeapJoin:
		return fmt.Sprintf("rangeheapjoin %d %d", r.Left.Id, r.Right.Id)
	case *ConcatJoin:
		return fmt.Sprintf("concatjoin %d %d", r.Left.Id, r.Right.Id)
	case *HashJoin:
		return fmt.Sprintf("hashjoin %d %d", r.Left.Id, r.Right.Id)
	case *MergeJoin:
		return fmt.Sprintf("mergejoin %d %d", r.Left.Id, r.Right.Id)
	case *FullOuterJoin:
		return fmt.Sprintf("fullouterjoin %d %d", r.Left.Id, r.Right.Id)
	case *LateralJoin:
		return fmt.Sprintf("lateraljoin %d %d", r.Left.Id, r.Right.Id)
	case *TableScan:
		return fmt.Sprintf("tablescan: %s", r.Name())
	case *IndexScan:
		if r.Alias != "" {
			return fmt.Sprintf("indexscan: %s", r.Alias)
		}
		return fmt.Sprintf("indexscan: %s", r.Name())
	case *Values:
		return fmt.Sprintf("values: %s", r.Name())
	case *TableAlias:
		return fmt.Sprintf("tablealias: %s", r.Name())
	case *RecursiveTable:
		return fmt.Sprintf("recursivetable: %s", r.Name())
	case *RecursiveCte:
		return fmt.Sprintf("recursivecte: %s", r.Name())
	case *SubqueryAlias:
		return fmt.Sprintf("subqueryalias: %s", r.Name())
	case *TableFunc:
		return fmt.Sprintf("tablefunc: %s", r.Name())
	case *JSONTable:
		return fmt.Sprintf("jsontable: %s", r.Name())
	case *EmptyTable:
		return fmt.Sprintf("emptytable: %s", r.Name())
	case *SetOp:
		return fmt.Sprintf("setop: %s", r.Name())
	case *Project:
		return fmt.Sprintf("project: %d", r.Child.Id)
	case *Distinct:
		return fmt.Sprintf("distinct: %d", r.Child.Id)
	case *Max1Row:
		return fmt.Sprintf("max1row: %d", r.Child.Id)
	case *Filter:
		return fmt.Sprintf("filter: %d", r.Child.Id)
	default:
		panic(fmt.Sprintf("unknown RelExpr type: %T", r))
	}
}

func buildRelExpr(b *ExecBuilder, r RelExpr, children ...sql.Node) (sql.Node, error) {
	var result sql.Node
	var err error

	switch r := r.(type) {
	case *CrossJoin:
		result, err = b.buildCrossJoin(r, children...)
	case *InnerJoin:
		result, err = b.buildInnerJoin(r, children...)
	case *LeftJoin:
		result, err = b.buildLeftJoin(r, children...)
	case *SemiJoin:
		result, err = b.buildSemiJoin(r, children...)
	case *AntiJoin:
		result, err = b.buildAntiJoin(r, children...)
	case *LookupJoin:
		result, err = b.buildLookupJoin(r, children...)
	case *RangeHeapJoin:
		result, err = b.buildRangeHeapJoin(r, children...)
	case *ConcatJoin:
		result, err = b.buildConcatJoin(r, children...)
	case *HashJoin:
		result, err = b.buildHashJoin(r, children...)
	case *MergeJoin:
		result, err = b.buildMergeJoin(r, children...)
	case *FullOuterJoin:
		result, err = b.buildFullOuterJoin(r, children...)
	case *LateralJoin:
		result, err = b.buildLateralJoin(r, children...)
	case *TableScan:
		result, err = b.buildTableScan(r, children...)
	case *IndexScan:
		result, err = b.buildIndexScan(r, children...)
	case *Values:
		result, err = b.buildValues(r, children...)
	case *TableAlias:
		result, err = b.buildTableAlias(r, children...)
	case *RecursiveTable:
		result, err = b.buildRecursiveTable(r, children...)
	case *RecursiveCte:
		result, err = b.buildRecursiveCte(r, children...)
	case *SubqueryAlias:
		result, err = b.buildSubqueryAlias(r, children...)
	case *TableFunc:
		result, err = b.buildTableFunc(r, children...)
	case *JSONTable:
		result, err = b.buildJSONTable(r, children...)
	case *EmptyTable:
		result, err = b.buildEmptyTable(r, children...)
	case *SetOp:
		result, err = b.buildSetOp(r, children...)
	case *Project:
		result, err = b.buildProject(r, children...)
	case *Distinct:
		result, err = b.buildDistinct(r, children...)
	case *Max1Row:
		result, err = b.buildMax1Row(r, children...)
	case *Filter:
		result, err = b.buildFilter(r, children...)
	default:
		panic(fmt.Sprintf("unknown RelExpr type: %T", r))
	}

	if err != nil {
		return nil, err
	}

	if withDescribeStats, ok := result.(sql.WithDescribeStats); ok {
		withDescribeStats.SetDescribeStats(*DescribeStats(r))
	}
	result, err = r.Group().finalize(result)
	if err != nil {
		return nil, err
	}
	return result, nil
}
