// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin1_general_cs_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `latin1_general_cs` collation.
func Latin1_general_cs_RuneWeight(r rune) int32 {
	weight, ok := latin1_general_cs_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// latin1_general_cs_Weights contain a map from rune to weight for the `latin1_general_cs` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var latin1_general_cs_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	65:   65,
	97:   66,
	192:  67,
	224:  68,
	193:  69,
	225:  70,
	194:  71,
	226:  72,
	195:  73,
	227:  74,
	196:  75,
	228:  76,
	197:  77,
	229:  78,
	198:  79,
	230:  80,
	66:   81,
	98:   82,
	67:   83,
	99:   84,
	199:  85,
	231:  86,
	68:   87,
	100:  88,
	208:  89,
	240:  90,
	69:   91,
	101:  92,
	200:  93,
	232:  94,
	201:  95,
	233:  96,
	202:  97,
	234:  98,
	203:  99,
	235:  100,
	70:   101,
	102:  102,
	71:   103,
	103:  104,
	72:   105,
	104:  106,
	73:   107,
	105:  108,
	204:  109,
	236:  110,
	205:  111,
	237:  112,
	206:  113,
	238:  114,
	207:  115,
	239:  116,
	74:   117,
	106:  118,
	75:   119,
	107:  120,
	76:   121,
	108:  122,
	77:   123,
	109:  124,
	78:   125,
	110:  126,
	209:  127,
	241:  128,
	79:   129,
	111:  130,
	210:  131,
	242:  132,
	211:  133,
	243:  134,
	212:  135,
	244:  136,
	213:  137,
	245:  138,
	214:  139,
	246:  140,
	216:  141,
	248:  142,
	80:   143,
	112:  144,
	81:   145,
	113:  146,
	82:   147,
	114:  148,
	83:   149,
	115:  150,
	223:  151,
	84:   152,
	116:  153,
	85:   154,
	117:  155,
	217:  156,
	249:  157,
	218:  158,
	250:  159,
	219:  160,
	251:  161,
	220:  162,
	252:  163,
	86:   164,
	118:  165,
	87:   166,
	119:  167,
	88:   168,
	120:  169,
	89:   170,
	121:  171,
	221:  172,
	253:  173,
	255:  174,
	90:   175,
	122:  176,
	222:  177,
	254:  178,
	91:   179,
	92:   180,
	93:   181,
	94:   182,
	95:   183,
	96:   184,
	123:  185,
	124:  186,
	125:  187,
	126:  188,
	215:  189,
	247:  190,
	127:  191,
	8364: 192,
	129:  193,
	8218: 194,
	402:  195,
	8222: 196,
	8230: 197,
	8224: 198,
	8225: 199,
	710:  200,
	8240: 201,
	352:  202,
	8249: 203,
	338:  204,
	141:  205,
	381:  206,
	143:  207,
	144:  208,
	8216: 209,
	8217: 210,
	8220: 211,
	8221: 212,
	8226: 213,
	8211: 214,
	8212: 215,
	732:  216,
	8482: 217,
	353:  218,
	8250: 219,
	339:  220,
	157:  221,
	382:  222,
	376:  223,
	160:  224,
	161:  225,
	162:  226,
	163:  227,
	164:  228,
	165:  229,
	166:  230,
	167:  231,
	168:  232,
	169:  233,
	170:  234,
	171:  235,
	172:  236,
	173:  237,
	174:  238,
	175:  239,
	176:  240,
	177:  241,
	178:  242,
	179:  243,
	180:  244,
	181:  245,
	182:  246,
	183:  247,
	184:  248,
	185:  249,
	186:  250,
	187:  251,
	188:  252,
	189:  253,
	190:  254,
	191:  255,
}
