// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Geostd8_general_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `geostd8_general_ci` collation.
func Geostd8_general_ci_RuneWeight(r rune) int32 {
	weight, ok := geostd8_general_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// geostd8_general_ci_Weights contain a map from rune to weight for the `geostd8_general_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var geostd8_general_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	96:   64,
	65:   65,
	97:   65,
	66:   66,
	98:   66,
	67:   67,
	99:   67,
	68:   68,
	100:  68,
	69:   69,
	101:  69,
	70:   70,
	102:  70,
	71:   71,
	103:  71,
	72:   72,
	104:  72,
	73:   73,
	105:  73,
	74:   74,
	106:  74,
	75:   75,
	107:  75,
	76:   76,
	108:  76,
	77:   77,
	109:  77,
	78:   78,
	110:  78,
	79:   79,
	111:  79,
	80:   80,
	112:  80,
	81:   81,
	113:  81,
	82:   82,
	114:  82,
	83:   83,
	115:  83,
	84:   84,
	116:  84,
	85:   85,
	117:  85,
	86:   86,
	118:  86,
	87:   87,
	119:  87,
	88:   88,
	120:  88,
	89:   89,
	121:  89,
	90:   90,
	122:  90,
	91:   91,
	92:   92,
	93:   93,
	94:   94,
	95:   95,
	123:  96,
	124:  97,
	125:  98,
	126:  99,
	127:  100,
	8364: 101,
	8218: 102,
	8222: 103,
	8230: 104,
	8224: 105,
	8225: 106,
	8240: 107,
	8249: 108,
	8216: 109,
	8217: 110,
	8220: 111,
	8221: 112,
	8226: 113,
	8211: 114,
	8212: 115,
	8250: 116,
	160:  117,
	161:  118,
	162:  119,
	163:  120,
	164:  121,
	165:  122,
	166:  123,
	167:  124,
	168:  125,
	169:  126,
	170:  127,
	171:  128,
	172:  129,
	173:  130,
	174:  131,
	175:  132,
	176:  133,
	177:  134,
	178:  135,
	179:  136,
	180:  137,
	181:  138,
	182:  139,
	183:  140,
	184:  141,
	185:  142,
	186:  143,
	187:  144,
	188:  145,
	189:  146,
	190:  147,
	191:  148,
	4304: 149,
	4305: 150,
	4306: 151,
	4307: 152,
	4308: 153,
	4309: 154,
	4310: 155,
	4337: 156,
	4311: 157,
	4312: 158,
	4313: 159,
	4314: 160,
	4315: 161,
	4316: 162,
	4338: 163,
	4317: 164,
	4318: 165,
	4319: 166,
	4320: 167,
	4321: 168,
	4322: 169,
	4339: 170,
	4323: 171,
	4324: 172,
	4325: 173,
	4326: 174,
	4327: 175,
	4328: 176,
	4329: 177,
	4330: 178,
	4331: 179,
	4332: 180,
	4333: 181,
	4334: 182,
	4340: 183,
	4335: 184,
	4336: 185,
	4341: 186,
	8470: 187,
}
