// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Cp1257_lithuanian_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `cp1257_lithuanian_ci` collation.
func Cp1257_lithuanian_ci_RuneWeight(r rune) int32 {
	weight, ok := cp1257_lithuanian_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// cp1257_lithuanian_ci_Weights contain a map from rune to weight for the `cp1257_lithuanian_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var cp1257_lithuanian_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	65:   65,
	97:   65,
	260:  66,
	66:   67,
	98:   67,
	67:   68,
	99:   68,
	268:  69,
	269:  69,
	68:   70,
	100:  70,
	69:   71,
	101:  71,
	280:  72,
	281:  72,
	278:  73,
	279:  73,
	70:   74,
	102:  74,
	71:   75,
	103:  75,
	72:   76,
	104:  76,
	73:   77,
	105:  77,
	89:   78,
	121:  78,
	302:  79,
	303:  79,
	74:   80,
	106:  80,
	75:   81,
	107:  81,
	76:   82,
	108:  82,
	77:   83,
	109:  83,
	78:   84,
	110:  84,
	79:   85,
	111:  85,
	80:   86,
	112:  86,
	81:   87,
	113:  87,
	82:   88,
	114:  88,
	83:   89,
	115:  89,
	352:  90,
	353:  90,
	84:   91,
	116:  91,
	85:   92,
	117:  92,
	362:  93,
	363:  93,
	370:  94,
	371:  94,
	86:   95,
	118:  95,
	87:   96,
	119:  96,
	88:   97,
	120:  97,
	91:   98,
	92:   99,
	93:   100,
	94:   101,
	95:   102,
	96:   103,
	123:  104,
	124:  105,
	125:  106,
	126:  107,
	90:   108,
	122:  108,
	127:  108,
	160:  108,
	162:  108,
	163:  108,
	164:  108,
	166:  108,
	167:  108,
	168:  108,
	169:  108,
	171:  108,
	172:  108,
	173:  108,
	174:  108,
	175:  108,
	176:  108,
	177:  108,
	178:  108,
	179:  108,
	180:  108,
	181:  108,
	182:  108,
	183:  108,
	184:  108,
	185:  108,
	187:  108,
	188:  108,
	189:  108,
	190:  108,
	196:  108,
	197:  108,
	198:  108,
	201:  108,
	211:  108,
	213:  108,
	214:  108,
	215:  108,
	216:  108,
	220:  108,
	223:  108,
	228:  108,
	229:  108,
	230:  108,
	233:  108,
	243:  108,
	245:  108,
	246:  108,
	247:  108,
	248:  108,
	252:  108,
	256:  108,
	257:  108,
	261:  108,
	262:  108,
	263:  108,
	274:  108,
	275:  108,
	290:  108,
	291:  108,
	298:  108,
	299:  108,
	310:  108,
	311:  108,
	315:  108,
	316:  108,
	321:  108,
	322:  108,
	323:  108,
	324:  108,
	325:  108,
	326:  108,
	332:  108,
	333:  108,
	342:  108,
	343:  108,
	346:  108,
	347:  108,
	377:  108,
	378:  108,
	379:  108,
	380:  108,
	381:  108,
	382:  108,
	711:  108,
	729:  108,
	731:  108,
	8211: 108,
	8212: 108,
	8216: 108,
	8217: 108,
	8218: 108,
	8220: 108,
	8221: 108,
	8222: 108,
	8224: 108,
	8225: 108,
	8226: 108,
	8230: 108,
	8240: 108,
	8249: 108,
	8250: 108,
	8364: 108,
	8482: 108,
}
