// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Cp1256 represents the `cp1256` character set encoding.
var Cp1256 Encoder = &RangeMap{
	inputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
			{
				inputRange:  rangeBounds{{128, 128}},
				outputRange: rangeBounds{{226, 226}, {130, 130}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{129, 129}},
				outputRange: rangeBounds{{217, 217}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{130, 130}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{131, 131}},
				outputRange: rangeBounds{{198, 198}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{132, 132}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{133, 133}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{134, 135}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {160, 161}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{136, 136}},
				outputRange: rangeBounds{{203, 203}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{137, 137}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{139, 139}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{140, 140}},
				outputRange: rangeBounds{{197, 197}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{141, 141}},
				outputRange: rangeBounds{{218, 218}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{142, 142}},
				outputRange: rangeBounds{{218, 218}, {152, 152}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{144, 144}},
				outputRange: rangeBounds{{218, 218}, {175, 175}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{145, 146}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {152, 153}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{147, 148}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 157}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{149, 149}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{150, 151}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {147, 148}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{153, 153}},
				outputRange: rangeBounds{{226, 226}, {132, 132}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{155, 155}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{156, 156}},
				outputRange: rangeBounds{{197, 197}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{157, 158}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {140, 141}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{160, 160}},
				outputRange: rangeBounds{{194, 194}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{161, 161}},
				outputRange: rangeBounds{{216, 216}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{162, 169}},
				outputRange: rangeBounds{{194, 194}, {162, 169}},
				inputMults:  []int{1},
				outputMults: []int{8, 1},
			},
			{
				inputRange:  rangeBounds{{171, 185}},
				outputRange: rangeBounds{{194, 194}, {171, 185}},
				inputMults:  []int{1},
				outputMults: []int{15, 1},
			},
			{
				inputRange:  rangeBounds{{186, 186}},
				outputRange: rangeBounds{{216, 216}, {155, 155}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{187, 190}},
				outputRange: rangeBounds{{194, 194}, {187, 190}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{191, 191}},
				outputRange: rangeBounds{{216, 216}, {159, 159}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{193, 214}},
				outputRange: rangeBounds{{216, 216}, {161, 182}},
				inputMults:  []int{1},
				outputMults: []int{22, 1},
			},
			{
				inputRange:  rangeBounds{{215, 215}},
				outputRange: rangeBounds{{195, 195}, {151, 151}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{216, 219}},
				outputRange: rangeBounds{{216, 216}, {183, 186}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{220, 223}},
				outputRange: rangeBounds{{217, 217}, {128, 131}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{224, 224}},
				outputRange: rangeBounds{{195, 195}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{225, 225}},
				outputRange: rangeBounds{{217, 217}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{195, 195}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 230}},
				outputRange: rangeBounds{{217, 217}, {133, 136}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{231, 235}},
				outputRange: rangeBounds{{195, 195}, {167, 171}},
				inputMults:  []int{1},
				outputMults: []int{5, 1},
			},
			{
				inputRange:  rangeBounds{{236, 237}},
				outputRange: rangeBounds{{217, 217}, {137, 138}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{238, 239}},
				outputRange: rangeBounds{{195, 195}, {174, 175}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{240, 243}},
				outputRange: rangeBounds{{217, 217}, {139, 142}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{244, 244}},
				outputRange: rangeBounds{{195, 195}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{245, 246}},
				outputRange: rangeBounds{{217, 217}, {143, 144}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{247, 247}},
				outputRange: rangeBounds{{195, 195}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{248, 248}},
				outputRange: rangeBounds{{217, 217}, {145, 145}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{249, 249}},
				outputRange: rangeBounds{{195, 195}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{250, 250}},
				outputRange: rangeBounds{{217, 217}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{251, 252}},
				outputRange: rangeBounds{{195, 195}, {187, 188}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{253, 254}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {142, 143}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
		},
		nil,
		nil,
		nil,
	},
	outputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{129, 129}},
				outputRange: rangeBounds{{217, 217}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{131, 131}},
				outputRange: rangeBounds{{198, 198}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{136, 136}},
				outputRange: rangeBounds{{203, 203}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{140, 140}},
				outputRange: rangeBounds{{197, 197}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{141, 141}},
				outputRange: rangeBounds{{218, 218}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{142, 142}},
				outputRange: rangeBounds{{218, 218}, {152, 152}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{144, 144}},
				outputRange: rangeBounds{{218, 218}, {175, 175}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{156, 156}},
				outputRange: rangeBounds{{197, 197}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{160, 160}},
				outputRange: rangeBounds{{194, 194}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{161, 161}},
				outputRange: rangeBounds{{216, 216}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{162, 169}},
				outputRange: rangeBounds{{194, 194}, {162, 169}},
				inputMults:  []int{1},
				outputMults: []int{8, 1},
			},
			{
				inputRange:  rangeBounds{{171, 185}},
				outputRange: rangeBounds{{194, 194}, {171, 185}},
				inputMults:  []int{1},
				outputMults: []int{15, 1},
			},
			{
				inputRange:  rangeBounds{{186, 186}},
				outputRange: rangeBounds{{216, 216}, {155, 155}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{187, 190}},
				outputRange: rangeBounds{{194, 194}, {187, 190}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{191, 191}},
				outputRange: rangeBounds{{216, 216}, {159, 159}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{193, 214}},
				outputRange: rangeBounds{{216, 216}, {161, 182}},
				inputMults:  []int{1},
				outputMults: []int{22, 1},
			},
			{
				inputRange:  rangeBounds{{215, 215}},
				outputRange: rangeBounds{{195, 195}, {151, 151}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{216, 219}},
				outputRange: rangeBounds{{216, 216}, {183, 186}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{220, 223}},
				outputRange: rangeBounds{{217, 217}, {128, 131}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{224, 224}},
				outputRange: rangeBounds{{195, 195}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{225, 225}},
				outputRange: rangeBounds{{217, 217}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{195, 195}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 230}},
				outputRange: rangeBounds{{217, 217}, {133, 136}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{231, 235}},
				outputRange: rangeBounds{{195, 195}, {167, 171}},
				inputMults:  []int{1},
				outputMults: []int{5, 1},
			},
			{
				inputRange:  rangeBounds{{236, 237}},
				outputRange: rangeBounds{{217, 217}, {137, 138}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{238, 239}},
				outputRange: rangeBounds{{195, 195}, {174, 175}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{240, 243}},
				outputRange: rangeBounds{{217, 217}, {139, 142}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{244, 244}},
				outputRange: rangeBounds{{195, 195}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{245, 246}},
				outputRange: rangeBounds{{217, 217}, {143, 144}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{247, 247}},
				outputRange: rangeBounds{{195, 195}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{248, 248}},
				outputRange: rangeBounds{{217, 217}, {145, 145}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{249, 249}},
				outputRange: rangeBounds{{195, 195}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{250, 250}},
				outputRange: rangeBounds{{217, 217}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{251, 252}},
				outputRange: rangeBounds{{195, 195}, {187, 188}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{128, 128}},
				outputRange: rangeBounds{{226, 226}, {130, 130}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{130, 130}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{132, 132}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{133, 133}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{134, 135}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {160, 161}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{137, 137}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{139, 139}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{145, 146}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {152, 153}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{147, 148}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 157}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{149, 149}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{150, 151}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {147, 148}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{153, 153}},
				outputRange: rangeBounds{{226, 226}, {132, 132}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{155, 155}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{157, 158}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {140, 141}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{253, 254}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {142, 143}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
		},
		nil,
	},
	toUpper: map[rune]rune{
		84:  116,
		93:  95,
		97:  65,
		98:  66,
		99:  67,
		100: 68,
		101: 69,
		102: 70,
		103: 71,
		104: 72,
		105: 73,
		106: 74,
		107: 75,
		108: 76,
		109: 77,
		110: 78,
		111: 79,
		112: 80,
		113: 81,
		114: 82,
		115: 83,
		117: 85,
		118: 86,
		119: 87,
		120: 88,
		121: 89,
		122: 90,
		125: 127,
		339: 338,
	},
	toLower: map[rune]rune{
		65:  97,
		66:  98,
		67:  99,
		68:  100,
		69:  101,
		70:  102,
		71:  103,
		72:  104,
		73:  105,
		74:  106,
		75:  107,
		76:  108,
		77:  109,
		78:  110,
		79:  111,
		80:  112,
		81:  113,
		82:  114,
		83:  115,
		85:  117,
		86:  118,
		87:  119,
		88:  120,
		89:  121,
		90:  122,
		116: 84,
		338: 339,
	},
}
